; make2blinkmpeg.pro = morph two images into mpeg blink sequence for xanim
; last: Jul 24 2003 
; init: Jul  8 2003 Bozeman

pro make2blinkmpeg,im1,im2,xaxisarr,yaxisarr,label1,label2,blinkfilename

;+  
; pro make2blinkmpeg,im1,im2,xaxisarr,yaxisarr,label1,label2,blinkfilename
;   im1 = image array (any type)
;   im2 = image array (same size, any type)
;   xaxisarr = x-axis scale array
;   yaxisarr = y-axis scale aaray 
;   label1 = header im1 (string)
;   label2 = header im2 (string)
;   blinkfilename = output mpeg file name
;-

; display input params
if (n_params(0) lt 1) then begin
   print,'  make2blinkmpeg,im1,im2,xaxisarr,yaxisarr'
   print,'                 label1,label2,blinkfilename'
   return
endif

; byte scale both images 
im1=bytscl(im1)
im2=bytscl(im2)

; get image size
sizeim=size(im1)
nx=sizeim(1)
ny=sizeim(2)

; make axes frame  (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny,/pixmap
blank=bytarr(nx,ny)
tv,blank
contour,im1,xaxisarr,yaxisarr,/nodata,/noerase,$
  xmargin=[0,0],ymargin=[0,0],$
  xtickinterval=10,ytickinterval=10,xthick=2.5,ythick=2.5,$
  xticklen=0.015,yticklen=0.015*ny/nx
im1axes=tvrd()
wdelete

; make info string images (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny,/pixmap
blank=bytarr(nx,ny)
tv,blank
xyouts,0.05,0.95,/norm,charsize=2.2,charthick=1.5,label1
im1label=tvrd()
tv,blank
xyouts,0.05,0.95,/norm,charsize=2.2,charthick=1.5,label2
im2label=tvrd()
wdelete

; add overlays
im1(where(im1axes gt 1))=0
im2(where(im1axes gt 1))=0
im1(where(im1label gt 1))=255
im2(where(im2label gt 1))=255

; show for visual check (add in when testing)
;window,xsize=nx,ysize=ny
;tvscl,im1
;stop
;wdelete

; generate mpeg images
immov=bytarr(nx,ny,2)
immov(*,*,0)=im1
immov(*,*,1)=im2

; write mpeg movie
write_mpeg,blinkfilename,immov,/high_qual
print,'  wrote file ', blinkfilename
print,'  play with: $ playxanim ', blinkfilename

end

