; file: frimageps.pro = plot framed image on screen and postscript file
; last: Jul 12 2006 = quickie fix to not have screen output (Venus)
; todo: IDL plottinng parameter passing on trick Dan Kiselman
; note: - device-independent publication-ready output (I hope)
;       - run twice initially, to set IDL window params
;       - use \landscape only for viewgraphs, not for LaTeX inserts 
;       - custom version: use frimage_xx.idl inserts

; todo: see how Kiselman's implied plotting keywords trick works 

pro frimageps,data,$
    color=color,$
    xaxisarr=xaxisarr,yaxisarr=yaxisarr,$
    xticks=xticks,yticks=yticks,$
    xtickinterval=xtickinterval,ytickinterval=ytickinterval,$
    xtitle=xtitle,ytitle=ytitle,figtitle=figtitle,$
    xfigtitle=xfigtitle,yfigtitle=yfigtitle,$
    noscreen=noscreen,nrwindow=nrwindow,xwindow=xwindow,ywindow=ywindow,$
    ps=ps,filename=filename,scaleps=scaleps,landscape=landscape,$
    charscale=charscale,xcharscale=xcharscale,ycharscale=ycharscale,$
    titlecharscale=titlecharscale,$
    xlabeloffsetscale=xlabeloffsetscale,ylabeloffsetscale=ylabeloffsetscale
    
;+  
; pro frimage,data [,key=key]
; required variable:
;   data = input image (2D array)
; optional keys (any order; non-ambiguous abbreviations permitted)
;   color = monochrome (0) or color (1) image (default 0)
;   xaxisarr = x axis value array (default i)
;   yaxisarr = y axis value array (default j)
;   xticks = x axis ticks (default 0 = automatic setting)
;   yticks = y axis ticks (default 0 = automatic setting)
;   xtickinterval = x axis tick interval (default 0 = automatic setting) 
;   ytickinterval = y axis tick interval (default 0 = automatic setting) 
;   xtitle = x axis label (eg '!17arcsec', default 'x')
;   ytitle = y axis label (eg '!17arcsec', default 'y')
;   figtitle = figure ident (eg 'file = 'filename, default '')
;   xfigtitle, yfigtitle = start figtitle (axes fractions; default top)
;   noscreen = no output on screen (default output on screen) 
;   nrwindow = number of IDL window (default 0)
;   xwindow = x pixel position lower left window corner (default 100)
;   ywindow = y pixel position lower left window corner (default 100)
;   ps = also output on postscript file
;   filename = postscript output file name (default 'frimage.ps')
;   scaleps = ps output scale factor (1 = full page; default 1.0)
;   landscale = ps output landscape (for viewgraphs; default portrait)
;   charscale = scale factor to all symbol sizes (default 1.0)
;   xcharscale = scale factor to X axis numbers (default 1.0)
;   ycharscale = scale factor to Y axis numbers (default 1.0)
;   titlecharscale = scale factor to fig title characters (default 1.0)
;   xlabeloffsetscale = scale factor to x label offset (default 1.0)
;   ylabeloffsetscale = scale factor to y label offset (default 1.0)
; examples:
;   frimage,a
;   frimage,a,/ps,/landscape
;   frimage,a,xtit='!17Mm',ytit='!17Mm',file='map_1.ps',/ps
;-

; display input params
if (n_params(0) lt 1) then begin
  print,'frimage,data                          key defaults'
  print,'  [,color                                0'
  print,'   ,xaxisarr,yaxisarr                    i,j'
  print,'   ,xticks,yticks                        0,0'
  print,'   ,xtickinterval,ytickinterval          0,0'
  print,'   ,xtitle,ytitle,figtitle               x,y,-'
  print,'   ,xfigtitle,yfigtitle,                 -1,-1 = on top'
  print,'   ,noscreen,nrwindow,xwindow,ywindow    0,0,100,100'
  print,'   ,ps,filename,scaleps,landscape        0,frimage.ps,1,0'         
  print,'   ,charscale,xcharscale,ycharscale      1,1,1'
  print,'   ,titlecharscale,                      1'
  print,'   ,xlabeloffsetscale,ylabeloffsetscale] 1,1'
  print,'   NB: run twice initially'
  print,'       landscape only for viewgraphs, not LaTeX inserts'
  return
endif

; default key settings
datasize=size(data)
if (n_elements(color) eq 0) then color=0
if (n_elements(xaxisarr) eq 0) then xaxisarr=findgen(datasize(1))
if (n_elements(yaxisarr) eq 0) then yaxisarr=findgen(datasize(2))
if (n_elements(xticks) eq 0) then xticks=0
if (n_elements(yticks) eq 0) then yticks=0
if (n_elements(xtickinterval) eq 0) then xtickinterval=0
if (n_elements(ytickinterval) eq 0) then ytickinterval=0
if (n_elements(yticks) eq 0) then yticks=0
if (n_elements(xtitle) eq 0) then xtitle='x'
if (n_elements(ytitle) eq 0) then ytitle='y'
if (n_elements(figtitle) eq 0) then figtitle=''
if (n_elements(xfigtitle) eq 0) then xfigtitle=-1
if (n_elements(yfigtitle) eq 0) then yfigtitle=-1
if (n_elements(noscreen) eq 0) then noscreen=0
if (n_elements(nrwindow) eq 0) then nrwindow=0
if (n_elements(xwindow) eq 0) then xwindow=100
if (n_elements(ywindow) eq 0) then ywindow=100
if (n_elements(ps) eq 0) then ps=0
if (n_elements(landscape) eq 0) then landscape=0
if (n_elements(filename) eq 0) then filename='frimage.ps'
if (n_elements(scaleps) eq 0) then scaleps=1.0
if (n_elements(charscale) eq 0) then charscale=1.0
if (n_elements(xcharscale) eq 0) then xcharscale=1.0
if (n_elements(ycharscale) eq 0) then ycharscale=1.0
if (n_elements(titlecharscale) eq 0) then titlecharscale=1.0
if (n_elements(xlabeloffsetscale) eq 0) then xlabeloffsetscale=1.0
if (n_elements(ylabeloffsetscale) eq 0) then ylabeloffsetscale=1.0

; data dimensions 
datasize=size(data)
nx=datasize(1)
ny=datasize(2)

; fonts
!p.font=1

; what windows?
windowsdevice='X'
if (!d.name eq 'WIN') then windowsdevice='WIN'

; device character sizes
; IDL standard charsizes:  SUN   DEC    PS         SGI  Dell
;           !d.x_ch_size =  6     8    0.222cm     12    6
;           !d.y_ch_size = 12    10    0.352cm     12   10
xcharsun=6.                   ; SUN char width
ycharsun=12.                  ; SUN char height
xchardev=float(!d.x_ch_size)  ; this device char width
ychardev=float(!d.y_ch_size)  ; this device char height
xcharps=0.222                 ; postscript char width in cm
ycharps=0.352                 ; postscript char height in cm
xpixratio=xcharsun/xchardev   ; 1 for SUN, 0.75 for DEC, 0.5 for SGI 
ypixratio=ycharsun/ychardev   ; 1 for SUN, 1.20 for DEC, 1.0 for SGI

; set thicknesses
xthick=1.0*charscale
ythick=xthick
charthick=1.5*charscale
labelcharthick=charthick

; tick mark sizes
ticklen=-10.0*charscale*xpixratio   ; negative = outward
xticklen=ticklen/ny 
yticklen=ticklen/nx

; character sizes
charsize=1.5*charscale*xpixratio
xcharsize=charsize*xcharscale  ; bumping problem?
ycharsize=charsize*ycharscale
xlabelcharsize=2.0*charscale*xpixratio  
ylabelcharsize=xlabelcharsize
titlecharsize=xlabelcharsize*titlecharscale

; offsets and margins
xlabeloffset=4*xlabelcharsize*xlabeloffsetscale
ylabeloffset=5*ylabelcharsize*ylabeloffsetscale
toplabeloffset=3*charscale  ; in ychar units
leftmargin=ylabeloffset+5*charscale
rightmargin=4*charscale
bottommargin=xlabeloffset+1*charscale
topmargin=toplabeloffset+3*charscale
xmargin=[leftmargin,rightmargin]
ymargin=[bottommargin,topmargin]

; title color: reverse when overlay
titlecolor=0
if (yfigtitle gt 0 and yfigtitle lt 1) then titlecolor=255


; loop over output: first screen, then optional additional postscript
; ############ fix
for iloop=2,2 do begin

; 1st time = screen initialization (example Users Guide version 3.1 15-8)
  if iloop eq 1 then begin
  set_plot,windowsdevice
  device=1
  norm=0
  xcharnorm=xchardev
  ycharnorm=ychardev
  windowwidth=nx+xchardev*(leftmargin+rightmargin)    ; in xchardev
  windowheight=ny+ychardev*(bottommargin+topmargin)   ; in ychardev
  window,nrwindow,xpos=xwindow,ypos=ywindow,$
    xsize=windowwidth,ysize=windowheight,colors=255,pixmap=noscreen
  contour,data,xstyle=4,ystyle=4,/nodata,xmargin=xmargin,ymargin=ymargin
  px=!x.window*!d.x_vsize
  py=!y.window*!d.y_vsize
  xsize=nx
  ysize=ny
endif

; 2nd time = postscript initialization (example scalable pixels 15-6)
if (iloop eq 2 and ps ne 0) then begin
;;;;;;;;; ## quick fix
  set_plot,windowsdevice
  px=!x.window*!d.x_vsize
  py=!y.window*!d.y_vsize
;;;;;;;;;
  set_plot,'ps'
  device=0
  norm=1  
  pswidth=nx*xcharps/xchardev+xcharps*(leftmargin+rightmargin)  ; cm
  psheight=ny*xcharps/xchardev+ycharps*(bottommargin+topmargin) ; cm
  if (psheight/pswidth ge 1.5) then factor=24.0/psheight $
    else factor=16.0/pswidth     ; fill page portrait-wise
  if (landscape ne 0 and pswidth/psheight ge 1.5) then factor=1.5*factor
  factor=scaleps*factor
  if (landscape eq 0) then $
    device,/color,bits_per_pixel=8,file=filename,$
      xsize=pswidth,ysize=psheight,$
      scale_factor=factor,xoff=2,yoff=2,/portrait,$
      set_font='Times',/tt_font,font_size=15
  if (landscape ne 0) then $  
    device,/color,bits_per_pixel=8,file=filename,$
      xsize=pswidth,ysize=psheight,$
      scale_factor=factor,xoff=2,yoff=26,/landscape,$
      set_font='Times',/tt_font,font_size=10
  contour,data,xstyle=4,ystyle=4,/nodata,xmargin=xmargin,ymargin=ymargin
  px(0)=!x.window(0)
  py(0)=!y.window(0)
  xsize=!x.window(1)-!x.window(0)
  ysize=!y.window(1)-!y.window(0)
  xcharnorm=xcharps/pswidth
  ycharnorm=ycharps/psheight*xpixratio  ; 0.75 for DEC, 0.5 for SGI; why??
endif

if (iloop eq 1 or ps ne 0) then begin
  tv,data,px(0),py(0),xsize=xsize,ysize=ysize,device=device,norm=norm
  contour,data,xaxisarr,yaxisarr,/noerase,/nodata,device=device,norm=norm,$
    xstyle=1,ystyle=1,xmargin=xmargin,ymargin=ymargin,$
    xticks=xticks,yticks=yticks,$
    xtickinterval=xtickinterval,ytickinterval=ytickinterval,$
    xthick=xthick,ythick=ythick,$
    xticklen=xticklen,yticklen=yticklen,$
    xcharsize=xcharsize,ycharsize=ycharsize,charthick=charthick
  xyouts,device=device,norm=norm,$     ; x-axis label
    px(0)+0.5*xsize,py(0)-xlabeloffset*ycharnorm,$
    xtitle,$
    align=0.5,$
    charsize=xlabelcharsize,charthick=labelcharthick
  xyouts,device=device,norm=norm,$     ; y-axis label
    px(0)-ylabeloffset*xcharnorm,py(0)+0.5*ysize,$
    ytitle,$
    align=0.5,orientation=90,$
    charsize=ylabelcharsize,charthick=labelcharthick
  if (xfigtitle eq -1 and yfigtitle eq -1) then begin  ; title above frame
    xyouts,device=device,norm=norm,$     ; top label (file identifier)
      px(0)-ylabeloffset*xcharnorm,py(0)+ysize+toplabeloffset*ycharnorm,$
      figtitle,$
      charsize=titlecharsize,charthick=labelcharthick*titlecharscale
  endif else begin                       ; identifier within frame
    xyouts,device=device,norm=norm,$
      px(0)+xfigtitle*xsize,py(0)+yfigtitle*ysize,$ 
      figtitle,color=titlecolor,$
      charsize=titlecharsize,charthick=labelcharthick*titlecharscale
  endelse
endif

if (iloop eq 2 and ps ne 0) then begin
  print,' wrote ps file: ',filename
  device,/close
  set_plot,windowsdevice
endif

endfor  ; end of iloop over two outputs

end




