; file: findalignfulldisk.pro = trial to get scale from 2-patch matching
; init: Mar 11 2022  Rob Rutten  Deil
; last: Mar 12 2022  Rob Rutten  Deil
; note: NO SUCCESS

;+
pro findalignfulldisk,im1,im2,px1,px2,angle,$
  px2asym,shiftfor,shiftrev,nxfor,nyfor,nxrev,nyrev,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,minmetqual=minmetqual,$
  stopmetcalf=stopmetcalf,$
  trimboxim2center=trimboxim2center,inshift12center=inshift12center,$
  trimboxim2limb=trimboxim2limb,inshift12limb=inshift12limb,$
  smearim1=smearim1,smearim2=smearim2,$
  histopim1=histopim1,histopim2=histopim2,$
  muckdarkim1=muckdarkim1,muckdarkim2=muckdarkim2,$
  muckbrightim1=muckbrightim1,muckbrightim2=muckbrightim2,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  metqual=metqual,nmet=nmet,$
  finalrinse=finalrinse,$
  blink=blink,show=show,verbose=verbose

 ; for input, output, keyword parameters see findalignimages.pro.
 ; special here:
 ; trimboxim2center [mandatory]: selected trimbox near/around disk center
 ;   if -1 then start with full-disk blink to select and then specify this
 ; trimboxim2limb [optional]: =0 skip, =-1 start blink to specify
 ;   added to refine px2 value = scale im2
 ;
 ; Mar 11 2022 RR: start
;-

; answer a no-parameter query
if (n_params() lt 12) then begin
  sp,findalignfulldisk
  return
endif

; keyword defaults
if (n_elements(skipmetcalf) eq 0) then skipmetcalf=0
if (n_elements(maxmetcalf) eq 0) then maxmetcalf=4
if (n_elements(minmetqual) eq 0) then minmetqual=1E-4
if (n_elements(stopmetcalf) eq 0) then stopmetcalf=0
if (n_elements(px2asym) eq 0) then px2asym=[1.0,1.0]
if (n_elements(applypx2asym) eq 0) then applypx2asym=0
if (n_elements(trimboxim2center) eq 0) then trimboxim2center=-1
if (total([trimboxim2center]) eq 0) then trimboxim2center=-1
if (n_elements(trimboxim2limb) eq 0) then trimboxim2limb=0
if (total([trimboxim2limb]) eq 0) then trimboxim2limb=-1
if (n_elements(inshift12center) eq 0) then inshift12center=[0.,0.]
if (n_elements(inshift12limb) eq 0) then inshift12limb=[0.,0.]
if (n_elements(smearim1) eq 0) then smearim1=-1.5 ; NB default
if (n_elements(smearim2) eq 0) then smearim2=-1.5 ; NB default
if (n_elements(histopim1) eq 0) then histopim1=0
if (n_elements(histopim2) eq 0) then histopim2=0
if (n_elements(muckdarkim1) eq 0) then muckdarkim1=0 
if (n_elements(muckdarkim2) eq 0) then muckdarkim2=0 
if (n_elements(muckbrightim1) eq 0) then muckbrightim1=0 
if (n_elements(muckbrightim2) eq 0) then muckbrightim2=0 
if (n_elements(flatten) eq 0) then flatten=0 
if (n_elements(flatim1) eq 0) then flatim1=0 
if (n_elements(flatim2) eq 0) then flatim2=0 
if (n_elements(finalrinse) eq 0) then finalrinse=0
if (n_elements(blink) eq 0) then blink=10  ; NB default
if (n_elements(show) eq 0) then show=0
if (n_elements(verbose) eq 0) then verbose=0

; get im1 sizes
szim1=size(im1)
nx_im1=szim1[1]
ny_im1=szim1[2]
; get im2 sizes
szim2=size(im2)
nx_im2=szim2[1]
ny_im2=szim2[2]

; store px2_in
px2_in=px2

; dual showex for trimbox determinations
if (trimboxim2center[0] eq -1 or trimboxim2limb[0] eq -1) then begin
; transform im1 to im2 format for
  reformimage,im1,im1px2,$
    congridfactor=[px1/px2,px1/px2],$
    nxlarge=nx_im2,nylarge=ny_im2,$
    cutcentralx=nx_im2,cutcentraly=ny_im2,$
    /splinip
  print,' ##### select in B trimboxcenter and/or trimboxlimb, specify, rerun'
  showex,im1px2,im2,/blink
  return
endif

; findalignimages for trimboxcenter
print,' -----'
print,' ----- start findalignimages trimboxim2center'
print,' -----'
findalignimages,im1,im2,px1,px2,angle,px2asym,$
  shiftfor,shiftrev,nxfor,nyfor,nxrev,nyrev,$    
  nxmuckfor=nxmuckfor,nymuckfor=nymuckfor,$
  nxmuckrev=nxmuckrev,nymuckrev=nymuckrev,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,minmetqual=minmetqual,$
  stopmetcalf=stopmetcalf,$
  applypx2asym=applypx2asym,$
  trimboxim2=trimboxim2center,inshift12=inshift12center,$
  smearim1=smearim1,smearim2=smearim2,$
  histopim1=histopim1,histopim2=histopim2,$
  muckdarkim1=muckdarkim1,muckdarkim2=muckdarkim2,$
  muckbrightim1=muckbrightim1,muckbrightim2=muckbrightim2,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  metqual=metqual,nmet=nmet,finalrinse=finalrinse,$
  blink=blink,show=show,verbose=verbose

; store center result px2
px2_cent=px2

; findalignimages for trimboxlimb
print,' -----'
print,' ----- start findalignimages trimboxim2limb'
print,' -----'
findalignimages,im1,im2,px1,px2,angle,px2asym,$
  shiftfor,shiftrev,nxfor,nyfor,nxrev,nyrev,$    
  nxmuckfor=nxmuckfor,nymuckfor=nymuckfor,$
  nxmuckrev=nxmuckrev,nymuckrev=nymuckrev,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,minmetqual=minmetqual,$
  stopmetcalf=stopmetcalf,$
  applypx2asym=applypx2asym,$
  trimboxim2=trimboxim2limb,inshift12=inshift12limb,$
  smearim1=smearim1,sdistmearim2=smearim2,$
  histopim1=histopim1,histopim2=histopim2,$
  muckdarkim1=muckdarkim1,muckdarkim2=muckdarkim2,$
  muckbrightim1=muckbrightim1,muckbrightim2=muckbrightim2,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  metqual=metqual,nmet=nmet,finalrinse=finalrinse,$
  blink=blink,show=show,verbose=verbose

; find px2 scale correction
netinshift=(inshift12limb-inshift12center)  ; in px1
; assume center path is correct, limb cutout offset by wrong scale
limbxy2=[(trimboxim2limb[0]+trimboxim2limb[2])/2.,$
         (trimboxim2limb[3]+trimboxim2limb[1])/2.]   ; cutout center in px2_in
limbxy1=limbxy2*px2_cent/px1 ; in px1; smaller px1 need more tor same point
corrpx=netinshift/limbxy1 ; needed shift per px1
corrpx=inshift12limb/limbxy1 ; needed shift per px1
px2=px1*(1.+avg(corrpx))*px2_cent/px1
; ## no good, correction too large

end

; ======================== test per IDLWAVE H-c =====================

cd,'/tmp'

; get testcase AIA 304 and 131 fulldisk images
  datetime='2012.08.15_23:00'
  strput,datetime,'_',10 
  datetime_rr=str_replace(datetime,'-','.')
; get 304;  check on previous download
  if (file_test('/tmp/sdo_'+datetime_rr+'_304.fits')) then $
    sdo_getimage,'/tmp/sdo_'+datetime_rr+'_304.fits',$
    '304',sdoim304,indexfull304 else $
      sdo_getimage,datetime_rr,'304',sdoim304,indexfull304 
; get 131;  check on previous download
  if (file_test('/tmp/sdo_'+datetime_rr+'_131.fits')) then $
    sdo_getimage,'/tmp/sdo_'+datetime_rr+'_131.fits',$
    '131',sdoim131,indexfull131 else $
      sdo_getimage,datetime_rr,'131',sdoim131,indexfull131

; muck 131
  reformimage,sdoim131,sdoim131muck,$
    congridfactor=[0.8,0.8],shift=[10,15],rotate=10.

; initial values
  im1=sdoim304
  im2=sdoim131muck
  px1=0.6
  px2=0.6*1.2  ; 7.2; correct value 7.5
  angle=9.
  
; trimboxes 
  trimboxim2center=-1
  trimboxim2center=[1397,1474,1889,2005]
  trimboxim2limb=[1126,2452,1692,2767]
  
; show
  blink=10
  show=1
  verbose=1
  
findalignfulldisk,im1,im2,px1,px2,angle,$
  px2asym,shiftfor,shiftrev,nxfor,nyfor,nxrev,nyrev,$
  skipmetcalf=skipmetcalf,maxmetcalf=maxmetcalf,minmetqual=minmetqual,$
  stopmetcalf=stopmetcalf,$
  trimboxim2center=trimboxim2center,inshift12center=inshift12center,$
  trimboxim2limb=trimboxim2limb,inshift12limb=inshift12limb,$
  smearim1=smearim1,smearim2=smearim2,$
  histopim1=histopim1,histopim2=histopim2,$
  muckdarkim1=muckdarkim1,muckdarkim2=muckdarkim2,$
  muckbrightim1=muckbrightim1,muckbrightim2=muckbrightim2,$
  flatten=flatten,flatim1=flatim1,flatim2=flatim2,$
  metqual=metqual,nmet=nmet,$
  finalrinse=finalrinse,$
  blink=blink,show=show,verbose=verbose

end
