; file: disklimbfit.pro = fit limb of a full-disk solar image
; init: Apr 11 2022  Rob Rutten  Deil from ~/rr/idl/tests/rr_iris_limbfit.pro
; last: May 20 2022  Rob Rutten  Deil

;+
pro disklimbfit,image,xcen,ycen,radius,verbose=verbose

 ;
 ; INPUTS:
 ;  image = 2D image array 
 ;
 ; OPTIONAL KEYWORD INPUTS
 ; verbose = 1/0
 ;
 ; OUTPUTS:
 ; xcen,ycen: disk center location in px    
 ; radius: apparent disk radius in px
 ;
 ; HISTORY:
 ;   Apr 11 2022 RR: start from SSW limb_fit.pro
;-

; answer no-parameter query 
if (n_params(0) lt 4) then begin
  sp,disklimbfit
  return
endif

; defaults for keywords
if (n_elements(verbose) eq 0) then verbose=0


STOP ;RR always have stop at end of pro in development

end


; =============== main for testing per IDLWAVE H-c ======================

; get sequence AIA 304 images (once done existing are used)
cd,'/home/rutten/data/SDO/2019-11-11-transit/diskimages'
datetime1='2019.11.11_15:16:00'   ; Mercury transit, sits near disk center 
datetime2='2019.11.11_15:20:00'
taistart=anytim2tai(datetime1)
taiend=anytim2tai(datetime2)
wav='304'
outdir='./'
sdo_getimagesequence,taistart,taiend,wav,imarr,indexarr,outdir=outdir

; inspect
showex,imarr ; in polar CHs veel meer opstekende sprietjes

; run the program
image=imarr[0]
disklimbfit,image,xcen,ycen,radius,verbose=verbose

end
