; file: despike_rr.pro = wrapper to SSW despike 
; init: Oct  6 2015  Rob Rutten  Deil
; last: Oct  6 2015  Rob Rutten  Deil

 ;+

function despike_rr,image,sigma,_extra=despikekeywords

 ; NAME:
 ;   despike_rr
 ; PURPOSE:
 ;   wrapper to SSW iris_prep_despike.pro to have no operation for sigma=0
 ;   permits arrays 1D to 4D
 ; INPUTS:
 ;   image or image cube 
 ;   sigma = cutoff level sigmas, or 0 = don't do anything
 ; KEYWORDS:
 ;   those of SSW iris_prep_despike.pro
 ; OUTPUT:
 ;   the original image (sigma=0) or the despiked image (eg sigma=4)
 ; HISTORY:
 ;   Oct  6 2015 RR: start
;-

im=image
if (sigma eq 0) then despim=im else $
   despim=iris_prep_despike(im,sigma=sigma,_extra=despikekeywords)

return,despim
end

; =========== test Hyper-C ===================

im=readfits('/home/rutten/data/SDO/2014-01-10-test/level2/AIA20140110_120347_0171.fits')
im=alog10(im)
im[100,100]=5.*max(im)   ; single_px hit 
despim=despike_rr(im,2,silent=0)
flickrr,im,despim

end
