; file: cube2mpeg.pro = make mpeg movie from cube in memory
; init: Oct 27 2002 from /home/rutten/rr/wrk/SST/2002-09-xx makempeg.pro
; last: Nov 18 2013  Rob Rutten  Sac Peak
; note: fitscube2mpeg.pro: similar but uses assoc, no large cube in memory

pro cube2mpeg,cube,mpegfile,rebin=rebin,clock=clock,dt=dt,hh=hh,mm=mm,ss=ss

;+
 ; NAME:
 ;   cube2mpeg.pro   
 ; PURPOSE:
 ;   make an mpeg movie from an image sequence in a [x,y,t] cube
 ; DESCRIPTION:
 ;   doesn't use mpeg_encode anymore but IDL commands
 ; CALL:
 ;   cube2mpeg,cube,mpegfile,rebin=rebin,clock=clock,dt=dt,hh=hh,mm=mm,ss=ss
 ; INPUTS:
 ;   cube = image cube, any type
 ;     cut down as desired, use sqrt or alog10 as desired; will be bytescaled
 ; KEYWORDS:
 ;   rebin = multiplier to nx and ny for rebinning (larger of smaller image)
 ;   clock = add clock with start time hh:mm:ss and dt time steps
 ; OUTPUTS:
 ;   mpegfile = string with path+filename for the output filename
 ; RESTRICTIONS:
 ;   may produce funny 16x16 first-iteration px   
 ; HISTORY:
 ;   Nov 14 2013 RR: started because Pit's write_mpeg no longer works
 ;   Nov 18 2013 RR: works again in 3 ways, now uses ppmtompeg
;-

; defaults for keywords
if (n_elements(rebin) eq 0) then rebin=0
if (n_elements(clock) eq 0) then clock=0
if (n_elements(dt) eq 0) then dt=10
if (n_elements(hh) eq 0) then hh=0
if (n_elements(mm) eq 0) then mm=0
if (n_elements(ss) eq 0) then ss=0

; print warning
print,' ==== this may take long'

; get size
sizecube=size(cube)
nx=sizecube[1]
ny=sizecube[2]
nt=sizecube[3]

; rebin if requested
if (rebin ne 0) then begin
  cube=rebin(cube,nx*rebin,ny*rebin,nt,/sample)
  nx=nx*rebin
  ny=ny*rebin
endif

; cut nx and ny down to multiples of 16 px for mpeg
nx=nx/16*16
ny=ny/16*16
nt=nt/16*16
cube=cube[0:nx-1,0:ny-1,0:nt-1]

; histo_opt?? 
; cube=histo_opt_rr(cube,0.001,0.001)

; bytscale
cube=bytscl(cube)
movie=cube

if (clock eq 1) then begin
; initiate clock
  starthr=hh 
  startmin=mm
  startsec=ss
  
; clock production (Pit Suetterlin)

; clock insertion
  tt=findgen(nt)*dt+starthr*3600.+startmin*60.+startsec
  hr=fix(tt/3600.)
  mn=fix((tt mod 3600)/60)
  sc=fix(tt mod 60)
  tt=nnumber(hr,2)+":"+nnumber(mn,2)+":"+nnumber(sc,2)
  blank=bytarr(nx,ny)
  while !d.window ne -1 do wdelete,!d.window 
  window, xsize=nx, ysize=ny, /pixmap,retain=2
  for it=0,nt-1 do begin
; get clock
    tv, blank
    clock, tt[it], /dev, size=(ny/8)/16*16, position=[ny/15,ny/15]
    imclock=tvrd()
; get image, superimpose clock
    image=cube[*,*,it]
    image[where(imclock gt 1)]=255
    movie[*,*,it]=image
  endfor
endif else movie=cube


; write the first image as jpg for usage as presentation clicker
write_jpeg,mpegfile+'.jpg',bytscl(movie[*,*,0])

; write mpeg movie
write_mpeg,mpegfile,movie,/high_qual,framerate=24 
;RR Nov 14 2013 gives core dump. Alexandra Tritschler: mpeg_decode deprecated
;RR AHA: works again after change mpeg_encode to /ppmtompeg in write_mpeg

;; ; mpeg production gleaned out of David Fanning's make_mpeg_movie.pro
;; ; see IDL help mpeg_open
;;  mpegid=mpeg_open([nx,ny], filename=mpegfile,quality=100)
;; for it=0,nt-1 do mpeg_put,mpegid,image=movie[*,*,it],frame=it,/order
;; mpeg_save,mpegid
;; mpeg_close,mpegid
;RR works but gives worse quality than the old mpeg_encode

; write mpeg using png writeout and avconv
;; for it=0,nt-1 do begin
;;   filename='mpegim'+strmid(string(it+1e6,format='(i7)'),1,6)
;;   write_png,'/tmp/'+filename+'.png',mm1[*,*,it]
;; endfor
;; spawn,'avconv -f image2 -i /tmp/mpegim%06d.png -v quiet -r 24 -y '+mpegfile
;; spawn,'rm -f /tmp/mpegim*'
;RR works also but slower than ppmtompeg
end


