; file: crispex_read_header.pro
; init: Oct 10 2013  Rob Rutten
; last: Oct 10 2013  Rob Rutten
; note: adapted from Gegal Vissers version in crispex.pro Jul 17 2013 
;       Oct 10 2013 RR adapted what???
;       Sep 17 2016 RR this is for old LP format  


PRO CRISPEX_READ_HEADER, filename, header=header, datatype=datatype, $
  dims=dims, nx=nx, ny=ny, nt=nt, endian=endian, stokes=stokes, $
  ns=ns, diagnostics=diagnostics

OPENR, lun, filename, /GET_LUN
rec	= ASSOC(lun, BYTARR(512))	&	header	= STRING(rec[0])
FREE_LUN, lun
len	= STRLEN(header)

search	= 'datatype='	&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown datatype!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
datatype= LONG( STRMID(header, pos + STRLEN(search), 1) )
search	= 'dims='	&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown number of dimensions!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
dims	= LONG( STRMID(header, pos + STRLEN(search), 1) )
IF (dims LT 2) OR (dims GT 3) THEN BEGIN
  MESSAGE, /INFO, 'Number of dimensions not supported!'
  PRINT, 'Dimensions: '+dims
  RETALL
ENDIF
search	= 'nx='		&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown number of pixels in x-direction!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
pos1	= STRPOS(header, ',', pos)
nx	= LONG( STRMID(header, pos + STRLEN(search), pos1-pos) )
search	= 'ny='		&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown number of pixels in y-direction!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
pos1	= STRPOS(header, ',', pos)
ny	= LONG( STRMID(header, pos + STRLEN(search), pos1-pos) )
search	= 'nt='		&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown number of pixels in t-direction!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
pos1	= STRPOS(header, ',', pos)
nt	= LONG( STRMID(header, pos + STRLEN(search), pos1-pos) )
search	= 'endian='	&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN BEGIN
  MESSAGE, /INFO, 'Unknown endianness!'
  PRINT, 'Header: '+header
  RETALL
ENDIF
endian	= STRMID(header, pos + STRLEN(search), 1)
search	= 'ns='	&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN ns = 1 ELSE ns = STRMID(header, pos + STRLEN(search), 1)
search	= 'stokes='	&	pos	= STRPOS(header, search)
IF pos EQ -1 THEN stokes = ['I'] ELSE stokes = STRMID(header, pos + STRLEN(search), 2*ns+1)
search	= 'diagnostics='	&	pos	= STRPOS(header, search)
pos1	= STRPOS(header,']',pos)
IF pos NE -1 THEN diagnostics = STRMID(header, pos + STRLEN(search), pos1-pos)

END
