; file:
; 
; 

;+
;;; pro procname,param1,param2,keyword1=keyword1,verbose=verbose
;;; function procname,param1,param2,keyword1=keyword1,verbose=verbose

 ;
 ; INPUTS:
 ;   
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   
 ;   
 ; OUTPUTS:
 ;   
 ;   
 ; OPTIONAL KEYWORD OUTPUTS:
 ;   
 ;   
 ; RESTRICTIONS:
 ;   
 ;   
 ; HISTORY:
 ;   Sep 18 2020 RR: start
;-

; answer no-parameter query 
if (n_params(0) lt ??) then begin
  print,'??'
  sp,ratiocubefiles
  return       ;RR return,-1 when this is a function
endif

; set wall-clock timer (seconds)
timestart=systime(1) 

; defaults for keywords
if (n_elements(verbose) eq 0) then verbose=0

; print pacifier
if (verbose ne 0) then print,' ===== ?? started at UT = '+$
  anytim2utc(timestart,/vms)

; get endian for this computer 
;RR l = little, b = big; fits = big; linux machines are little
if ((byte(1L, 0, 1))[0] eq 1) then endian = 'l' else endian='b'

; ?????? 

; now open assoc
close_lun,lun,/force
openr,lun,file,swap_endian=swap_endian

; ??????

; free the input and output files
free_lun,unit_in,unit_out

; print elapsed time
timedone=systime(1)
timelaps=ntostr((timedone-timestart)/60.,format='(F11.1)')
if (verbose ne 0) then print,' ===== ?? took '+timelaps+' minutes'

STOP ;RR always have stop at end of pro in development

end


; =============== main for testing per IDLWAVE H-c ======================

end
