; file: index2mpo.pro = TEMPORARY override of the SSW version
; init: May 19 2020  Rob Rutten  Deil
; last: Jun 13 2020  Rob Rutten  Deil - reinstalled SSW but still needed
; note: offending line below killed aia-prep calls in my pipeline
;       temporary fix marked ;RR

function index2mpo, index, ds_mpo=ds_mpo, threeh=threeh, weekly=weekly, $
                    last_ds_rec=last_ds_rec, refresh=refresh, $
                    minutes_back=minutes_back, minutes_forward=minutes_forward, $
                    hours_back=hours_back, hours_forward=hours_forward, $
                    days_back=days_back, days_forward=days_forward, $
                    forward_and_back=forward_and_back, $
                    mpo_tag_set=mpo_tag_set, all_mpo_tags=all_mpo_tags, $
                    quiet=quiet, verbose=verbose, _extra=_extra

;+
;RR !!!!!!! May 19 2020 RR: temporary mucked version
;
; KEYWORDS:
;   INDEX
;     Either: A struct or vector of structure with time in any of
;     standard accepted ssw formats (see anytim.pro).
;     Or:     A time or vector of times any one of standard ssw formats.
;
; PROCEDURE:
;     Return the most recent mpo series record
;       for which INDEX.DATE_OBS tag falls within the range:
;       [MPO_REC.T_START, [MPO_REC.T_END].
; HISTORY:
;   2019-04-28 - GLS - Irreduciblized the routine, throwing out a lot of useless garbage
;-

common ssw_sdo_master_pointing_blk, mpo_arr, last_ds

if keyword_set(verbose) then begin
   help, threeh, weekly
endif

if ~exist(last_ds) then last_ds = ''

; Determine which MPO series to use:
if keyword_set(weekly) then ds_mpo = 'sdo.master_pointing'
if keyword_set(threeh) then ds_mpo = 'aia.master_pointing3h'
if ~exist(ds_mpo) then ds_mpo = 'aia.master_pointing3h'

; Limit MPO tags returned to only those needed:
if ~exist(mpo_tag_set) then $
   mpo_tag_set = $
      ['DATE', 'T_START', 'T_STOP', 'VERSION', $
       'A_094_IMSCALE',  'A_094_X0',  'A_094_Y0',  'A_094_INSTROT',  $
       'A_131_IMSCALE',  'A_131_X0',  'A_131_Y0',  'A_131_INSTROT',  $
       'A_171_IMSCALE',  'A_171_X0',  'A_171_Y0',  'A_171_INSTROT',  $
       'A_193_IMSCALE',  'A_193_X0',  'A_193_Y0',  'A_193_INSTROT',  $
       'A_211_IMSCALE',  'A_211_X0',  'A_211_Y0',  'A_211_INSTROT',  $
       'A_304_IMSCALE',  'A_304_X0',  'A_304_Y0',  'A_304_INSTROT',  $
       'A_335_IMSCALE',  'A_335_X0',  'A_335_Y0',  'A_335_INSTROT',  $
       'A_1600_IMSCALE', 'A_1600_X0', 'A_1600_Y0', 'A_1600_INSTROT', $
       'A_1700_IMSCALE', 'A_1700_X0', 'A_1700_Y0', 'A_1700_INSTROT', $
       'A_4500_IMSCALE', 'A_4500_X0', 'A_4500_Y0', 'A_4500_INSTROT']

; Explicitly report which master pointing series is being used:
if ~keyword_set(quiet) then $
   print, ' INDEX2MPO.PRO: Using JSOC SDO master pointing series ' + ds_mpo

if not exist(seconds_back_default) then $
   if ds_mpo eq 'aia.master_pointing3h' then seconds_back_default = 24*3600l else $
      seconds_back_default = 56*86400l
if not exist(seconds_forward_default) then $
   seconds_forward_default = seconds_back_default

; Test whether INDEX is a structure or a time expression (if a structure,
; then extract the time tag from it):
n_rec = n_elements(index)
typ_index = size(index, /type)
if typ_index eq 8 then begin
  t_index = index.date_obs
  if tag_exist(index, 'MPO_REC') then mpo_rec = index.mpo_rec
endif else begin
  t_index = index
endelse

; Define various time variables from t_index array:
t_sec_index = anytim(t_index)
t_ints_index = anytim(t_index, /ints)
t_sec_index_min = min(t_sec_index)
t_sec_index_max = max(t_sec_index)

; If mpo_arr already exists, check if it includes all index times:
refresh_internal = keyword_set(refresh)
if exist(mpo_arr) then begin
   t_start_mpo = mpo_arr.t_start
   t_stop_mpo = mpo_arr.t_stop
   t_sec_start_mpo = anytim(t_start_mpo)
   t_sec_stop_mpo = anytim(t_stop_mpo)
   t0_sec_mpo = min(t_sec_start_mpo)
   t1_sec_mpo = max(t_sec_stop_mpo)
   if ( (t0_sec_mpo gt t_sec_index_min) or (t1_sec_mpo lt t_sec_index_max) ) then $
      refresh_internal = 1
endif


;RR ######## temporary Rob Rutten muck
;; if ( ~exist(mpo_arr) or (ds_mpo ne last_ds) or (refresh_internal eq 1) ) then begin
if ( ~exist(mpo_arr)) then begin

  
   help, ds_mpo, last_ds, refresh_internal

;  if keyword_set(verbose) then $
   print, ' Doing JSOC query to read MPT records.'

   if exist(minutes_back) then seconds_back = minutes_back*60l
   if exist(hours_back) then seconds_back = hours_back*3600l
   if exist(days_back) then seconds_back = days_back*86400l
   if not exist(seconds_back) then seconds_back = seconds_back_default

   if exist(minutes_forward) then seconds_forward = minutes_forward*60l
   if exist(hours_forward) then seconds_forward = hours_forward*3600l
   if exist(days_forward) then seconds_forward = days_forward*86400l
   if not exist(seconds_forward) then seconds_forward = seconds_forward_default

   t0_sec_mpo_query = t_sec_index_min - seconds_back
   t1_sec_mpo_query = t_sec_index_max + seconds_forward
   t0_mpo_query = anytim(t0_sec_mpo_query, /ccsds)
   t1_mpo_query = anytim(t1_sec_mpo_query, /ccsds)

   if ~keyword_set(all_mpo_tags) then $
      ssw_jsoc_time2data, t0_mpo_query, t1_mpo_query, mpo_arr, ds=ds_mpo, $
                          keywords=mpo_tag_set, _extra=_extra else $
      ssw_jsoc_time2data, t0_mpo_query, t1_mpo_query, mpo_arr, ds=ds_mpo, $
                          _extra=_extra            

; Add mpo series name tag to mpo structure:
   if ~tag_exist(mpo_arr, 'mpo_series_name') then $
      mpo_arr = add_tag(mpo_arr, ds_mpo, 'mpo_series_name')
   last_ds = ds_mpo

endif else begin

;  if keyword_set(verbose) then $
   print, ' Using previously read MPT records.'

endelse

; Find closest prior MPO record for all input times:
t_start_mpo = mpo_arr.t_start
t_start_mpo_ints = anytim(t_start_mpo, /ints)
ss_match_arr = tim2dset(t_start_mpo_ints, anytim(t_sec_index, /ints))

mpo_match_arr = mpo_arr[ss_match_arr]

return, mpo_match_arr

end
