
function aia2wcsmin, index, mpo_str=mpo_str_new, ds_mpo=ds_mpo, $
                     threeh=threeh, weekly=weekly, $
                     no_mpo_update=no_mpo_update, force_mpo_update=force_mpo_update, $
                     verbose=verbose, _extra=_extra

;+
; HISTORY:
;   2019-05-07 - GLS - Pretty much completely gutted and re-written.
;   2020-04-30 - GLS - Fixed ss_do_update filtering logic (hmi exclusion)
;
; TODO:
;   - If HMI image, return without processing (announce in verbose mode)
;   - Only do AIA pointing update if original header pointing tags are NOT FROM 3hour MPO
;   - Vectorize as many of the operations as possible
;   - Rename mpo_str_new
;-

common ssw_sdo_master_pointing_blk, mpo_arr, last_ds

; Define prognam, progver variables
prognam = 'AIA2WCSMIN.PRO'
progver = 'V6.00' ; 2019-05-07 (GLS)

; Define constants TODO - are these needed any longer?):
wave_str_arr = [ '094',  '131',  '171',  '193',  '211',  '304',  '335', '1600', '1700', '4500']
hmi_cam_st_arr = ['cam1', 'cam2']

if not exist(crpix_diff_max) then crpix_diff_max = 0.1

if keyword_set(verbose) then begin
   help, no_mpo_update, force_mpo_update, threeh, weekly
endif

; Save original index structure for use later:
oindex = index

n_img = n_elements(index)

; Add MPO data series tag to updated headers:
if ~tag_exist(oindex, 'ds_mpo') then oindex = add_tag(oindex, '', 'ds_mpo')

; Skip pointing update if keyword NO_MPO_UPDATE is set:
if ( ~keyword_set(no_mpo_update) or keyword_set(force_mpo_update) ) then begin
   
; Create instrument array from image headers (e.g., AIA, HMI, etc):
   instr_prefix = strupcase(strmid(index.instrume,0,3))

; Exclude all HMI images from MPO update (for HMI images, original pointing tags
; (crpix*, etc.) are as good as can be done.  Therefore, for HMI images,
; no MPO correction will be made).  Also, skip update for images which are
; level 1.5 unless header tag FORCE_MPO_UPDATE is set:
   ss_not_hmi = where(instr_prefix ne 'HMI', n_not_hmi)
   if n_not_hmi eq 0 then begin
      n_do_update = 0
   endif else begin
      ss_do_update = where( (instr_prefix ne 'HMI') and $
                            ( (index.lvl_num ne 1.5) or keyword_set(force_mpo_update) ), n_do_update )
   endelse

   if n_do_update gt 0 then begin
      index_do_update = index[ss_do_update]

; Define SAT_ROT ( TOCHECK: Why is finite check on sat_rot necessary? ):
      sat_rot = intarr(n_do_update)
      if tag_exist(index_do_update, 'sat_rot') then begin
         ss_sat_rot_finite = where(finite(index_do_update.sat_rot) eq 1, n_sat_rot_finite)
         if n_sat_rot_finite gt 0 then $
            sat_rot[ss_sat_rot_finite] = index_do_update[ss_sat_rot_finite].sat_rot
      endif

; Construct names for needed MPO tags for all index records:
      wave_string = strtrim(index_do_update.wavelnth,2)
      wave_string_len = strlen(wave_string)
      ss_short = where( wave_string_len lt 3, n_short)
      if n_short gt 0 then wave_string[ss_short] = '0' + wave_string[ss_short]
      wave_string = 'a_' + wave_string

      mpo_x0_tags = wave_string + '_x0'
      mpo_y0_tags = wave_string + '_y0'
      mpo_imscale_tags = wave_string + '_imscale'
      mpo_instrot_tags = wave_string + '_instrot'

; Get the proper MPO records for all non-HMI images:
      if keyword_set(use_sswmp) then begin
; Allow use of local SolarSoft copy of JSOC MPO series (geny format) - NOT YET IMPLEMENTED:
         if keyword_set(verbose) then print, 'Calling ssw_sdo_master_pointing directly:'
         mpo_str_new = get_sswdb_mpo(index_do_update.t_obs)
      endif else begin

         mpo_str_new = index2mpo(index_do_update, ds_mpo=ds_mpo, threeh=threeh, weekly=weekly, $
                                 last_ds_rec=last_ds_rec, refresh=refresh, $
                                 minutes_back=minutes_back, minutes_forward=minutes_forward, $
                                 hours_back=hours_back, hours_forward=hours_forward, $
                                 days_back=days_back, days_forward=days_forward, $
                                 forward_and_back=forward_and_back, $
                                 quiet=quiet, verbose=verbose, _extra=_extra)

      endelse

; DEBUG:
;if ( (index.lvl_num eq 1.5) and ( then begin
; TODO - PUT THIS CHECK BACK IN:
;if index.lvl_num eq 1.5 then begin
;   help, index.lvl_num, no_mpo_update, force_mpo_update, ds_initial, ds_final
;   STOP, 'AIA2WCSMIN: Stopping for level 1p5 check.'
;endif

; For each image header, from the associated MPO record, extract the appropriate
; IMSCALE, X0, Y0, and INSTROT tags and define intermediate variables from those tags:
      for i=0, n_do_update-1 do begin
         oindex[ss_do_update[i]].x0_mp = $
            mpo_str_new[ss_do_update[i]].(tag_index(mpo_str_new[ss_do_update[i]], $
                                                    mpo_x0_tags[ss_do_update[i]]))
         oindex[ss_do_update[i]].y0_mp = $
            mpo_str_new[ss_do_update[i]].(tag_index(mpo_str_new[ss_do_update[i]], $
                                                    mpo_y0_tags[ss_do_update[i]]))
         oindex[ss_do_update[i]].imscl_mp = $
            mpo_str_new[ss_do_update[i]].(tag_index(mpo_str_new[ss_do_update[i]], $
                                                    mpo_imscale_tags[ss_do_update[i]]))
         oindex[ss_do_update[i]].inst_rot = $
            mpo_str_new[ss_do_update[i]].(tag_index(mpo_str_new[ss_do_update[i]], $
                                                    mpo_instrot_tags[ss_do_update[i]]))
      endfor

      oindex[ss_do_update].crpix1 = $
         index[ss_do_update].crpix1 + (oindex[ss_do_update].x0_mp - index[ss_do_update].x0_mp)
      oindex[ss_do_update].crpix2 = $
         index[ss_do_update].crpix2 + (oindex[ss_do_update].y0_mp - index[ss_do_update].y0_mp)
      oindex[ss_do_update].cdelt1 = $
         index[ss_do_update].cdelt1 * (oindex[ss_do_update].imscl_mp / index[ss_do_update].imscl_mp)
      oindex[ss_do_update].cdelt2 = $
         index[ss_do_update].cdelt2 * (oindex[ss_do_update].imscl_mp / index[ss_do_update].imscl_mp)
      oindex[ss_do_update].crota2 = $
         index[ss_do_update].crota2 + (oindex[ss_do_update].inst_rot - index[ss_do_update].inst_rot)

; Add SOT_ROT offset to updated CROTA2:
      oindex[ss_do_update].crota2 = oindex[ss_do_update].crota2 + sat_rot

; Derive new XCEN, YCEN tags and update or add to updated headers:
      xcen = comp_fits_cen(oindex.crpix1, oindex.cdelt1, oindex.naxis1, oindex.crval1)
      if tag_exist(oindex, 'XCEN') then oindex.xcen = xcen else $
         oindex = add_tag(oindex, xcen, 'XCEN')
      ycen = comp_fits_cen(oindex.crpix2, oindex.cdelt2, oindex.naxis2, oindex.crval2)
      if tag_exist(oindex, 'YCEN') then oindex.ycen = ycen else $
         oindex = add_tag(oindex, ycen, 'YCEN')

; Update DS_MPO keyword:
      oindex[ss_do_update].ds_mpo = ds_mpo

      if keyword_set(verbose) then begin
         print, ''
         if exist(mpo_str) then begin
            print, 'mpo start: ' + strtrim(mpo_str_new.t_start,2)
            print, 'mpo stop:  ' + strtrim(mpo_str_new.t_stop,2)
            print, 'mpo date:  ' + strtrim(mpo_str_new.date,2)
            print, 'mpo ver:   ' + strtrim(mpo_str_new.version,2)
         endif

         print, 'crpix1 (orig): ' + strtrim( index.crpix1,2) + '  ' + $
                'crpix2 (orig): ' + strtrim( index.crpix2,2)
         print, 'crpix1 (new) : ' + strtrim(oindex.crpix1,2) + '  ' + $
                'crpix2 (new) : ' + strtrim(oindex.crpix2,2)

         print, 'cdelt1 (orig): ' + strtrim( index.cdelt1,2) + '  ' + $
                'cdelt2 (orig): ' + strtrim( index.cdelt2,2)
         print, 'cdelt1 (new):  ' + strtrim(oindex.cdelt1,2) + '  ' + $
                'cdelt2 (new):  ' + strtrim(oindex.cdelt2,2)

         print, 'crota2 (orig): ' + strtrim( index.crota2,2) + '  ' + $
                'crota2 (new):  ' + strtrim(oindex.crota2,2)
         print, ''
      endif


; Add MPO tags to oindex:
      if exist(mpo_str_new) then begin
         oindex = add_tag(oindex, mpo_str_new.date, 'mpo_date')
         oindex = add_tag(oindex, mpo_str_new.t_start, 'mpo_t_start')
         oindex = add_tag(oindex, mpo_str_new.t_stop, 'mpo_t_stop')
      endif else begin
         oindex = add_tag(oindex, mpo_str_new.date, 'unavailable')
         oindex = add_tag(oindex, mpo_str_new.t_start, 'unavailable')
         oindex = add_tag(oindex, mpo_str_new.t_stop, 'unavailable')
      endelse

; Update history record:
      if exist(mpo_str_new) then begin
         buff_history =                'MPO_date: ' + strtrim(mpo_str_new.date,2)
         buff_history = [buff_history, 'MPO_t_start: ' + strtrim(mpo_str_new.t_start,2)]
         buff_history = [buff_history, 'MPO_t_stop: ' + strtrim(mpo_str_new.t_stop,2)]
         buff_history = [buff_history, 'MPO_version: ' + strtrim(mpo_str_new.version,2)]
      endif
      update_history, oindex, version=progver, caller=prognam
      update_history, oindex, buff_history

   endif else begin

; Update history record for HMI images (for which no MPO update is done):
      buff_history = ['No MPO update for HMI']
      update_history, oindex, version=progver, caller=prognam
      update_history, oindex, buff_history
      print, " AIA2WCSMIN: HMI image. Using header values for pointing keywords."

   endelse

endif else begin

; Update history record for case where NO_MPO_UPDATE flag is set:
   if ~exist(buff_history) then $
      buff_history =                'NO_MPO_UPDATE flag set' else $
      buff_history = [buff_history, 'NO_MPO_UPDATE flag set']
   update_history, oindex, version=progver, caller=prognam
   update_history, oindex, buff_history
   print, " AIA2WCSMIN: 'NO_MPO_UPDATE' flag set. Using header values for pointing keywords."

endelse

return, oindex

end
