; file: sizefitscube.pro
; init: Apr  8 2017  Rob Rutten  Deil
; last: Apr  8 2017  Rob Rutten  Deil

function sizefitscube,filename

;+
 ; NAME:
 ;  sizefitscube
 ; PURPOSE:
 ;   return cube type and dimensions
 ; INPUTS:
 ;   cubename = string 'path/name' of fits file
 ; OUTPUT:
 ;   [bitpix,nx,ny,nt]
 ; HISTORY:
 ;   Apr  8 2017 RR: start
;-

; undo space flag in dir if there (bloody Mac?)
filename=strjoin(strsplit(filename,'\ ',/extract),' ')

; get header
fitshead=headfits(filename)

; get dimensions
nx=fxpar(fitshead,'naxis1')  
ny=fxpar(fitshead,'naxis2')
nt=fxpar(fitshead,'naxis3')
bitpix=fxpar(fitshead,'bitpix')

return,[bitpix,nx,ny,nt]
end

; ==================== test per Hyper-C ================

datadir='/home/rutten/data/SDO/2014-06-14-small/target/cubes/'
file=datadir+'aia171.fits'

print,sizefitscube(file)

end
