; file: multratfitscubes.pro = test for IRIS 1400 footpoint MC brightenings
; init: Dec 15 2020  Rob Rutten  Deil
; last: Dec 15 2020  Rob Rutten  Deil


pro multratfitsscubes,file1,file2,multfile,ratfile

cube1=readfits(file1)    
cube2=readfits(file2)

; check dimensions
sz1=size(cube1)
nx1=sz1[1]
ny1=sz1[2]
nt1=sz1[3]

sz2=size(cube2)
nx2=sz2[1]
ny2=sz2[2]
nt2=sz2[3]

; cehck nx, ny equality
if (nx1 ne nx2 or ny1 ne ny2) then begin
  print,' nx or ny unequal'
  STOP
endif

; cut unequal length
if (nt2 gt nt1) then cube2=cube2[*,*,0:nt1]
if (nt1 gt nt2) then cube1=cube1[*,*,0:nt2]

; product
mean1=avg(cube1)
mean2=avg(cube2)
print,mean1,mean2
multcube=float(cube1)/mean1*(float(cube2)/mean2)
multcube=fix(multcube*5000)
writefits,multfile,multcube

; ratio
ratcube=float(cube1/mean1)/(float(cube2)/mean2)
ratcube=fix(ratcube*5000)
writefits,ratfile,ratcube

end

; ======================================

; ## try in trialdir

cd,'/media/rutten/RRHOME/alldata/SST/2014-06-21-quiet'
file1='sst_iris_sdo/iris_SJI_1400_SST.fits'   ; nx=786 ny=816 nt=376 
file2='trialmultrat/ca_bw.fits'               ; nx=786 ny=816 nt=391
multfile='trialmultrat/iris_mult_cabw.fits'
ratfile='trialmultrat/iris_ratio_cabw.fits'

multratfitsscubes,file1,file2,multfile,ratfile

; check
showex,file1,file2,multfile,ratfile
end



