; movie2fitscube.pro = convert movie to bytecube in fitsfile using assoc
; init: Feb  2 2014  Rob Rutten  Deil
; last: Feb  3 2014  Rob Rutten  Deil
; note: script convertmovie2fitscubesall converts all movie files in dir

pro movie2fitscube,moviefile,outfits=outfits

;+
 ; NAME:
 ;   movie2fitscube.pro  
 ; PURPOSE:
 ;   convert a movie into a bytecube.fits file
 ; DESCRIPTION:
 ;   uses linux avconv (Ubuntu version of ffmpeg)
 ; CALL:
 ;    movie2fitscube,moviefile,outfits=outfits
 ; INPUTS:
 ;   moviefile = string path/filename, any avconv format
 ; KEYWORDS:
 ;   outfits = string path/filename to write cube into as .fits file
 ;   default: same as moviefile but with .fits extension
 ; OUTPUTS:
 ;   bytecube fitsfile
 ; HISTORY:
 ;   Feb  3 2014 RR: start 
;-

if (n_params() lt 1) then begin 
  print,'  usage: movie2fitscube,moviefile [,outfits=outfits]'
  return
endif

if (n_elements(outfits) eq 0) then begin 
  outfits=str_replace(moviefile,'.mov','.fits')
  outfits=str_replace(moviefile,'.mpg','.fits')
  outfits=str_replace(moviefile,'.mpeg','.fits')
  outfits=str_replace(moviefile,'.mp4','.fits')
  outfits=str_replace(moviefile,'.avi','.fits')
endif

; get unique file identifier for this movie (in case multiple use of program)
rannr=fix(abs(randomn(seed))*10000)
strrannr=strmid(string(rannr+1E5,format='(i6)'),2)

; convert movie to png images in subdir
;; spawn,'ffmpeg -i '+string(moviefile)+' -f image2 temppng/image-%04d.png'
;; gave complaint that ffmpeg will be deprecated, replaced by avconv
;; spawn,'avconv -i '+string(moviefile)+' -v quiet -f image2 ~/tmp/movim'+$
;;   strrannr+'%06d.png'
;; Mar 20 2019 back to ffmpeg
spawn,'ffmpeg -i '+string(moviefile)+' -f image2  ~/tmp/movim'+$
       strrannr+'%06d.png'

; get nr images and image size
filelist=file_search('~/tmp/movim'+strrannr+'*')
szfilelist=size(filelist)
nt=szfilelist[1]
read_png,filelist[0],image
szimage=size(image)
nx=szimage[2]
ny=szimage[3]

; define assoc parameters
bigendian=1   ;RR my Toshiba laptop
bitpix=8      ;RR bytes

; define header
mkhdr,outheader,abs(bitpix)/8,[nx,ny,nt]
sizeoutheader=size(outheader) 
outheadersize=(1+fix(sizeoutheader[1]/36.))*2880

; open output cube file for assoc, write header
get_lun, unit_out
if (bigendian) then openw,unit_out,outfits,/swap_if_little_endian else $
  openw,unit_out,outfits
outassoc=assoc(unit_out,bytarr(nx,ny),outheadersize)
rec=assoc(unit_out, bytarr(outheadersize))
rec[0]=byte(outheader)

; write movie frames into cubefile
for it=0,nt-1 do begin
  read_png,filelist[it],image
  outassoc[it]=byte(reform(image[0,*,*]))
endfor

; clean up
spawn,'rm -rf ~/tmp/movim'+strrannr+'*'

return
end

; ============== main for testing per IDLWAVE H-c ==========================

oldfits='~/rr/edu/manuals/idl-cubes/idl-cube/DOT-2005-10-14-gb.fits'
fitscube2mpeg,oldfits,'/tmp/test-gb.mpg',/sharpen
movie2fitscube,'/tmp/test-gb.mpg'
showex,'/tmp/test-gb.mpg',oldfits

end
