; file: headfits_rr.pro
; init: Sep 12 2015  Rob Rutten  Freiburg
; last: Sep 12 2015  Rob Rutten  Freiburg

function headfits_rr,filename,_extra=headfitskeywords

;+
 ; NAME:
 ;   headfits_rr
 ; PURPOSE:
 ;   wrapper to SSW headfits.pro to permit spaces in filename (paths)
 ; INPUTS:
 ;   cubename = string with 'path/name' of fits file
 ; KEYWORDS:
 ;   those of SSW headfits.pro
 ; OUTPUT:
 ;   the fits file header 
 ; HISTORY:
 ;   Sep 12 2015 RR: made for Catherine Fischer's Mac disk
;-

; undo space flag in dir if there are (bloody Mac?)
filename=strjoin(strsplit(filename,'\ ',/extract),' ')

; call original headfits
return,headfits(filename,_extra=headfitskeywords)

end
