; file: getfitstiming.pro
; init: Apr 10 2018  Rob Rutten  Deil
; last: Apr 10 2018  Rob Rutten  Deil

;+

pro getfitstiming,file,timearr

 ; PURPOSE:
 ;    RR special: return UT timing array from RR header info
 ; CALL:
 ;   see above
 ; METHOD: 
 ;   excerpts of imagelib/reformcubefile.pro  
 ; INPUTS:
 ;   file = string path/mame fits file 
 ; OUTPUTS:
 ;   timearr   
 ; HISTORY:
 ;   Apr 10 2018 RR: start  
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  sp,getfitstiming
  return       ;RR return,-1 when this is a function
endif

; get file params
header_in=headfits_rr(file)
nx_in=fxpar(header_in,'naxis1') 
ny_in=fxpar(header_in,'naxis2') 
nz_file=fxpar(header_in,'naxis3') 
nt_in=nz_file
nwavs=fxpar(header_in,'nrwavs')  ; becomes 0 if not present
if (nwavs eq 0) then nwavs=1 else nt_in=nz_file/nwavs
; check
if (nx_in eq 0 or ny_in eq 0 or nz_file eq 0) then begin
  print,' ##### getfitstiming abort: no nx, ny, nz in fits header '+infile
  return
endif

; get timing from header info in RR-format
starttime=fxpar(header_in,'starttim') ; start date-time string'
cadence=fxpar(header_in,'cadence')    ; cadence in seconds

; make UT timearr
starttai=anytim2tai(starttime)
timearrtai=starttai+indgen(nt_in)*cadence
timearr=anytim2utc(timearrtai,/ccsds)

end

; =============== main for testing per IDLWAVE H-c ======================

cd,'/media/rutten/SSTDATA/alldata/SST/2014-06-21-quiet/sst_iris_sdo'

file='aia131_rot.fits'
getfitstiming,file,timearr

; show 
print,timearr[0:10]

end
