; file: fitsimblink.pro = image blinker using ximovie for its options
; init: Feb 18 2016  Rob Rutten  Deil
; last: Feb 18 2016  Rob Rutten  Deil

;+

pro fitsimblink,file1,file2,_extra=imblinkkeywords

 ; NAME:
 ;   fitsimblink
 ;   
 ; PURPOSE:
 ;   blink two equal-size fitsfile images with ximovie widget
 ;   
 ; DESCRIPTION:
 ;   just a wrapper to imblink.pro > showex > ximovie_rr
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   file1, file2 = fits files with equal size images
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   all ximovie_rr keywords (type ximovie_rr for list) 
 ;
 ; HISTORY:
 ;   Feb 18 2016 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
    print,'fitsimblink,file1,file2 <ximovie_rr keywords>'
    return 
endif

; get images
im1=readfits(file1)
im2=readfits(file2)

; blink
imblink,im1,im2,_extra=imblinkkeywords

end


; =============== main for testing per IDLWAVE H-c ======================

file1='/home/rutten/rr/edu/manuals/idl-cubes/idl-cube/DOT-2005-10-14-ca.fits'
file2='/home/rutten/rr/edu/manuals/idl-cubes/idl-cube/DOT-2005-10-14-gb.fits'

fitsimblink,file1,file2,mag=2.5


end
