; file: fitsdims,pro
; init: Dec 12 2018  Rob Rutten  Deil
; last: Dec 12 2018  Rob Rutten  Deil

;+

pro fitsdims,file,nx,ny,nt

 ; PURPOSE:
 ;   get fits file dimensions from header naxis keywords
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   file = string defining fits file (path/name)  
 ;   
 ; OUTPUTS:
 ;   nx, ny, nt    
 ;   
 ; HISTORY:
 ;  Dec 12 2018 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 4) then begin
  sp,fitsdims
  return       ;RR return,-1 when this is a function
endif

; undo space flag in dir if there are (bloody Mac?)
thisfile=strjoin(strsplit(file,'\ ',/extract),' ')

; get the dimensions
header=headfits(thisfile)
nx=fxpar(header,'naxis1')      
ny=fxpar(header,'naxis2')      
nt=fxpar(header,'naxis3')      

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SST/2016-09-05-demo'
file='sst/ha_lc.fits'
fitsdims,file,nx,ny,nt
print,' ----- nx,ny,nt = ',nx,ny,nt

end
