; file: fits_openassoc.pro
; init: Jun 23 2017  Rob Rutten  Deil
; last: Jul 20 2017  Rob Rutten  Deil

;+

pro fits_openassoc,file,$
   lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian
 
 ; NAME:
 ;   fits_openassoc   
 ;   
 ; PURPOSE:
 ;   open a fits file for assoc
 ;   
 ; DESCRIPTION:
 ;   straightforward until SSTRED came along
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   file = string with path/filename
 ;   lun = the logical unit number to assoc into; must be specified
 ;         as 1-128 to avoid limitation to only 100-128 of /get_lun
 ;   
 ; OUTPUTS:
 ;   xszize,ysize,zsize = 3 dimensions
 ;   bitpix = word type (8=byte, 16=integer, -32=float)
 ;   headeroffset = size of the header needing to be offset in associng
 ;   swap_endian: need for endian swapping on this machine
 ;
 ; HISTORY:
 ;   Jun 23 2017 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 8) then begin
  print,'fits_openassoc,file,'
  print,'  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian'
  return  
endif

; check file extension
dummy=cgrootname(file,extension=ext)  ;RR needs coyotelib
if (ext ne 'fits') then begin
  print,' ##### fits_openassoc abort: file has no .fits extension'
  return
end

; get header
header=headfits_rr(file)

; check dimensions
ndim=sxpar(header,'NAXIS')
if (ndim ne 3 and ndim ne 5) then begin
  print,' ##### fits_openassoc abort: file '+file+' is not 3D of "5D" file'
endif

; get sizes
xsize=sxpar(header,'NAXIS1')
ysize=sxpar(header,'NAXIS2')
if (ndim eq 3) then zsize=sxpar(header,'NAXIS3')

; Jun 26 2022 SSTRED "5D" fits files
if (ndim eq 5) then zsize=$
  sxpar(header,'NAXIS3')*sxpar(header,'NAXIS4')*sxpar(header,'NAXIS5')

; check sizes
 if (xsize eq 0 or ysize eq 0 or zsize eq 0) then begin
  print,' ###### fits_openassoc abort: AXIS1, AXIS2, AXIS3 zero in '+file
  return
endif

; header = N x 36 "card images" = N x 2880 bytes
sizeheader=size(header)
headeroffset=(1+fix(sizeheader[1]/36.))*2880
bitpix=sxpar(header,'BITPIX')

; set swap_endian for this computer 
;RR l = little, b = big; fits = big; linux machines are little
if ((byte(1L, 0, 1))[0] eq 1) then endian = 'l' else endian='b'
if (abs(bitpix) gt 8) and (endian eq 'l') then $
  swap_endian=1 else swap_endian=0

; now open assoc
close_lun,lun,/force
openr,lun,file,swap_endian=swap_endian

end



; =============== main for testing per IDLWAVE H-c ======================

path='/media/rutten/SSTDATA/alldata/SST/2016-09-05-demo/'
file='sdo2sst/aia1600_alfor_px.fits'

lun=1
fits_openassoc,path+file,$
  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

print,lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

end
