; file: ssb3_trial.pro = try-out IDL pro for SSB3 = solar NaID1 in LTE
; init: Aug  2 2010 or well before
; last: Oct 19 2018  Rob Rutten  WeiHai
; site: https://robrutten.nl/rrweb/rjr-edu/exercises/ssb
; note: this is my own try-out for SSB3 
;       it has many experiments and it is NOT a ready file for others
;       it uses also my ltelib, my Neckel atlas data, etc., 
;       so it cannot be run directly by others, only used for inspiration


function parfunc_na,temp
  ; Gray 2nd edition appendic D polynomial specified in SSB instruction
pfc=[0.30955,-0.17778,1.10594,-2.42847,1.70721]
loguna=pfc[0]
for i=1,4 do loguna=loguna+pfc[i]*alog10(5040./temp)^i
return,10^loguna
end

;; pro noppes ; dummy, insert for IDLWAVE C+ALT q indentation

; common with atomic data in the Wittmann-Sanchez-Asensio  programs 
common common_atomdata_wsa,at_weight,at_abu,$
  at_ionerg1,at_ionerg2,at_ionerg3,at_sym
atomdata_wsa,1   ; initialize common variables with the common numbers

; ===========================================  START OF MAIN PROGRAM
stopwait=2  ; seconds per stop per plot shown 

; physics constants
ccgs=2.99792458D10          ; velocity of light (cm/s)
kcgs=1.38062D-16            ; Boltzmann constant in erg/deg
hcgs=6.62607D-27            ; Planck constant (erg s)
hckcgs=hcgs*ccgs/kcgs       ; hc/k in cgs

; NaD1 numbers
ionergna1=5.139
ionergna2=47.29
excergnad1=0.
glownad1=2
gupnad1=2
oscfnad1=0.3273 ; RH
airnad1=5895.92
vacnad1=5897.55

; put plot window besides emacs frame
window,xpos=0,ypos=380,xsi=630

; ============= NaD lines in FTS atlas

; SSB3 instruction task 3.1: read NaD atlas data
close,1
openr,1,'/home/rutten/rr/edu/exercises/ssb/idl/int_nad.dat'
nlines=5300
atlas=dblarr(4,nlines)
readf,1,atlas
wavnr=atlas[0,*]
obsint=reform(atlas[2,*]) ; 3rd column = intensity without telluric correction

; task 3.2: from wavenumber to vacuum wavelength
wav=1./wavnr*1D8      ; vacuum wavelengths in Angstrom and double precision

; plot atlas profiles at various dispersions
plot,wav,obsint,$
  xtitle='vacuum wavelength [Angstrom]',ytitle='relative intensity',$
  xrange=[5880,5910]

wait,stopwait   ; STOP

plot,wav,obsint,$
  xtitle='vacuum wavelength [Angstrom]',ytitle='relative intensity',$
  xrange=[5890,5893],xstyle=1

wait,stopwait   ; STOP 

; find line minima vacuum wavelengths
plot,obsint   ; shows index ranges of interest; select bands with lines
wav1=wav[array_indices(obsint,where(obsint eq min(obsint[3700:4000])))]
wav2=wav[array_indices(obsint,where(obsint eq min(obsint[2700:3200])))]
;; print,wav1,wav2  ; 5891.5781  5897.5548

wait,stopwait   ; STOP

; convert to air wavelengths
vactoair,wav          ; from astrolib
wav1=wav[array_indices(obsint,where(obsint eq min(obsint[3700:4000])))]
wav2=wav[array_indices(obsint,where(obsint eq min(obsint[2700:3200])))]
;; print,wav1,wav2  ; 5889.9438   5895.9188

; plot atlas spectrum against air wavelength
plot,wav,obsint,$
  xtitle='wavelength [Angstrom]',ytitle='relative intensity',$
  xrange=[5887,5892],xstyle=1

wait,stopwait   ; STOP

; ========================= read FALC

; read FALC
path='/home/rutten/rr/web/rjr-edu/exercises/ssb/'
readcol,path+'falc.dat',height,tau5,colmass,temp,vmicro,nhtot,nproton,$
  nelectron,ptot,pratio,dens,skipline=4
nhneutral=nhtot-nproton ; this includes H2 molecules
pgas=ptot*pratio  ; used in van der Waals = gas component only 
nh=80

; FALC plots as in SSB1
plot,height,temp<10000,/ynozero

wait,stopwait   ; STOP 

plot,height,ptot,/ylog   ; near-isothermal stratification 
oplot,height,pgas        ; microturb increases towards TR

wait,stopwait   ; STOP

plot,height,nhtot,/ylog  ; yes, this is total H density
oplot,height,nhneutral   ; nearly the same except at the top
oplot,height,nproton     ; this proves it
oplot,height,nelectron   ; usual T-min fill-in by electron donor ionization

wait,stopwait   ; STOP

; ============== test various partition functions (in my ltelib)

; older Gray polynomial in SSB3 instruction, at top of this file
plot,height,parfunc_na(temp)<5,/ylog

; Vitas newer Gray table implementation
parfun=partfunc_nv(temp,11,0)
oplot,height,parfun,linestyle=1

; WSA = Wittmann procedure
partfunc_wsa,temp,11,u1,u2,u3
oplot,height,u1,linestyle=2

wait,stopwait   ;  STOP

; conclusion: let's use my Vitas-WSA mixture
parfunnai=partfunc_rr(temp,11,0)
parfunnaii=partfunc_rr(temp,11,1)

; ========= test various Saha functions

;; temp=double(temp) ; gives no difference in difference below

; saha_wsa from WSA (Wittmann I guess)
saha1=saha_wsa(temp,nelectron*kcgs*temp,parfunnai,parfunnaii,ionergna1)
plot,height,saha1,/ylog  ; this is N_II/N_I

; saha_mc from Carlsson
saha_mc,temp,nelectron,ionergna1,parfunnai,parfunnaii,n1_ntot,n0_ntot
oplot,height,n1_ntot/n0_ntot,psym=4  ; OK, identical

wait,stopwait   ; STOP

; enlarge difference
plot,height,(n1_ntot/n0_ntot-saha1)/(n1_ntot/n0_ntot)
  ; largest diff 6E-4, why?

wait,stopwait   ; STOP

; my three-stage saha_rr
u0=partfunc_rr(temp,11,0)
u1=partfunc_rr(temp,11,1)
u2=partfunc_rr(temp,11,2)
saha_rr,temp,nelectron,ionergna1,ionergna2,u0,u1,u2,n0_ntot,n1_ntot,n2_ntot
oplot,height,n1_ntot/n0_ntot,psym=5

wait,stopwait   ; STOP

plot,height,n2_ntot,/ylog,yrange=[min(n2_ntot)/100.,100],ystyle=1
oplot,height,n1_ntot,linestyle=3
oplot,height,n0_ntot,linestyle=2

wait,stopwait   ; STOP

; enlarge difference
plot,height,(n1_ntot/n0_ntot-saha1)/(n1_ntot/n0_ntot),/ylog

  ; at top of TR NaIII dominates, elsewhere as above 6E-4 max
  ; NB: NaII has extraordinary high ionization energy of 40 eV

wait,stopwait   ; STOP

; ========= test line broadening

; radiation damping
nad1gamrad=6.18e+07  ; from RH NaI_fine.atom

aul=6.67E13*(glownad1/gupnad1)*oscfnad1/((vacnad1/10.)^2)
print,aul ; 6.27666e+07   ; why more than RH?  not vac-air difference

wait,stopwait   ; STOP

; van der Waals = Gray 3rd p245 ff, has N_H factored out already
; correction: RH has Mihalas II table 9-1 p.286 = 8.08
;   while Gray has prefactor 17 in his eq.11.28 on p.245
;   Mihalas value fits RH results (see cdrhidl testgammas.idl)
c6=0.3*1E-30*(1/(ionergna1-excergnad1-1.2398E4/vacnad1)^2 $
              - 1/(ionergna1-excergnad1)^2)
loggam6=20.+0.4*alog10(c6)+alog10(pgas)-0.7*alog10(temp)
gam6a=10^loggam6*8.08/17.
plot,height,gam6a,/ylog

wait,stopwait   ; STOP

; van der Waals following the SSB3 instruction
llownad1=0
lupnad1=1
nsqlow=13.6/(ionergna1-excergnad1)
nsqup=13.6/(ionergna1-excergnad1-1.2398E4/vacnad1)
rsqlow=nsqlow/2.*(5*nsqlow+1-3*llownad1*(llownad1+1))
rsqup=nsqup/2.*(5*nsqup+1-3*lupnad1*(lupnad1+1)) 
loggam6=6.33+0.4*alog10(rsqup-rsqlow)+alog10(pgas)-0.7*alog10(temp)
gam6b=10^loggam6
oplot,height,gam6b,linestyle=2 
; bit smaller than gam6a

wait,stopwait   ; STOP

; take gam6a
gamtot=gam6a+nad1gamrad
oplot,height,gamtot

wait,stopwait   ; STOP

; set wavelength grid for the line profile
nwav=300
delwav=indgen(nwav)*0.01-1.5
; one might be finicky and do only half profile since Voigt is
; symmetric around linecenter and the continuum slope is negligible

; get atomic parameters for this line (choice in read_line_params)
lines=[3933,  4554,  5173,  5896,  6563,   8542]
;;     CaIIK  BaII   MgIb2  NaID1  Halpha  CaIIIR

thisline=4-1  ; IDL counts from zero
read_line_params,$
  lines[thisline],linewav,elemnr,ionstage,excerg,$
  glow,gup,llow,lup,oscf,logc4

; get the monochromatic line extinction profile at all heights
extthisline=extline_wsa(temp,nelectron,nhtot,vmicro,$
                    delwav,linewav,elemnr,ionstage,$
                    oscf,excerg,gup,$
                    logstarkc4=logc4)

; inspect profiles at sample heights
plot,delwav,extthisline[*,nh-1],/ylog
oplot,delwav,extthisline[*,nh-10]
oplot,delwav,extthisline[*,nh-20]
oplot,delwav,extthisline[*,nh-30]

wait,stopwait   ; STOP

; inspect against height
plot,height,extthisline[nwav/2.,*]>1E-20,/ylog
oplot,height,extthisline[0,*],linestyle=2

wait,stopwait   ; STOP

; get continuum extinction at line center  for inspection
; NB the Gray recipes include correction for stimulated emission already
; Thomson and Rayleigh scattering don't get such correction ("Epsilon")
exthminbf=exthminbf_gray(linewav,temp,nelectron)
exthminff=exthminff_gray(linewav,temp,nelectron)
exthneubf=exthneubf_gray(linewav,temp)
exthneuff=exthneuff_gray(linewav,temp)
extthomson=0.664E-24
extrayleigh=1.13/2.*0.664E-24*(1216./linewav)^4
extcontH=(exthminbf+exthminff+exthneubf+exthneuff)*nhneutral
extcont=extcontH+extthomson*nelectron+extrayleigh*nhneutral

; compare to line extinction 
oplot,height,extcont,linestyle=3

wait,stopwait   ; STOP

; why the funny uptail towards the TR?  Decompose the ingredients;
plot,height,extcont<1.E-6,/ylog
oplot,height,extthomson*nelectron,linestyle=0
oplot,height,extrayleigh*nhneutral,linestyle=1
oplot,height,exthminbf*nhneutral,linestyle=2
oplot,height,exthminff*nhneutral,linestyle=2
oplot,height,exthneubf*nhneutral,linestyle=3
oplot,height,exthneuff*nhneutral,linestyle=3

; tail to TR = increase of N_e from H ionization increases H_neutral bf and ff

wait,stopwait   ; STOP

; Thomson scattering does NOT become the main ingredient in the
; chromosphere??  Does that fit with RTSA Bruls+Uitenbroek NaD source
; function problem?  It inspired my EB misconception...

; Oct 4 2013: at this stage I wondered (because the computed
;  continuum resulting below was too high) whether the old nhneuXX.pro
;  routines were OK, so I rewrote them into _gray versions and
;  laboriously reproduced the Gray and Vitense continuum extinction
;  figures with them, pro's in cdedulib.  I found mistakes in the
;  coolest figure of Gray and in the coolest figure of Vitense, but
;  these didn't help.  But Gray's exthneubf peaks remain slighly
;  higher than mine.

; LTE Boltzmann and Saha is assumed in the Gray extinction routines.
; Can I find and apply corrections?

; exthneubf_gray: the NLTE departure coefficients of FALC come in for
; all the H levels. Figure cdwrkrh cd /run_2013_FALC
; fig-betas-FALC-HI.eps has beta approx 2 in T-min so Gray's value
; underestimates the Paschen continuum which dominates at NaID1.  I
; can get beta_proton = ratio falc (nproton/nhtot) / LTE ratio with Saha.

saha_mc,temp,nelectron,13.6,partfunc_rr(temp,1,0),1,n1_ntot,n0_ntot
bproton=(nproton/nhtot)/n1_ntot
plot,height,bproton  ; OK, just as fig-betas-FALC-HI.eps 

; this is b_c; fig HI-betas FALC shows b3 has pattern at smaller amplitude
bn3=1.-0.6*(1.0-bproton)  ; rough correction estimate
oplot,height,bn3,linestyle=2
; sizable deviations from LTE, important correction, but only rough here
; Also the Brackett continuum etc contribute and should get their b's

wait,stopwait   ; STOP

; I also wrote extheubf_rr to try the Seaton Gaunt-factor polynomial
; that sits in RH but it gave 7-10% lower Gaunt values for n=3, so no
; way to increase the continuum opacity this way.

; exthneuff_gray: it is better not to use Gray III (8.10) on page 154
; as the Gray routine does, but the more general expression above it
; with the actual dependences on N_proton and N_electron.  Gray's
; (8.10) applied Saha, so assumed LTE.  The actual value differs by
; hydrogen b_c / b_Hneutral approx b_c/b_1.  On Oct 15 2013 I
; therefore wrote exthneuff_rr.pro which uses the actual values for
; the ratio N_e * N_p / N_Hneutral.  For FALC these include the
; hydrogen NLTE departures and electron-donor NLTE that affects N_e.

exthneuffrr=exthneuff_rr(linewav,temp,nhneutral,nproton,nelectron)
plot,height,(exthneuff-exthneuffrr)/exthneuffrr,yrange=[-0.5,2.0],ystyle=1
; again mostly the b_c pattern, sizable deviations above 200 km but
; there H_neutral^ff is unimportant for the continuum

wait,stopwait   ; STOP

; exthminbf_gray: Gray III (8.12) retains the factor P_e so Saha is
; only assumed for the N_Hmin > N_Hneutral ionization ratio which is
; likely correct.  This is the main extinction constituent so the most
; desirable to correct - but I see no error.  Of course hydrogen b_1
; approx unity.  I checked Gray Saha above (8.12) againt RTSA (8.3)
; p178: identical.

; exthminff_gray: encounter neutral H atom + free electron.  No need for
; Saha to find NHneutral and P_e sits properly in Gray III (8.13).


; redo the multicurve plot with these corrections
extcontH=(exthminbf+exthminff+exthneubf*bn3+exthneuffrr)*nhneutral
extcont=extcontH+extthomson*nelectron+extrayleigh*nhneutral

plot,height,extcont,/ylog,yrange=[1E-16,1E-5],ystyle=1
oplot,height,extthomson*nelectron,linestyle=0
oplot,height,extrayleigh*nhneutral,linestyle=1
oplot,height,exthminbf*nhneutral,linestyle=2
oplot,height,exthminff*nhneutral,linestyle=2
oplot,height,exthneubf*bn3*nhneutral,linestyle=3
oplot,height,exthneuffrr*nhneutral,linestyle=3

; now Thomson scattering dominates indeed in the chromosphere, thanks
; to the bn3 correction.  The latter is in the ball park but not exact.
; This restores my former understanding.  The chromosphere is NLTE!

wait,stopwait   ; STOP

; Now get the continuous extinction for every wavelength (a bit
; overkill).  Apply the above corrections.  Doesn't matter, they don't
; do much.  Therefore apply a continuum fudge factor....

extcont=extthisline  ; same double array
wav=linewav+delwav
; one parameter may be an array, step the wav, do full atmosphere arrays
for iwav=0,nwav-1 do begin
  extcont[iwav,*]=$
    exthminbf_gray(wav[iwav],temp,nelectron)*nhneutral $
    + exthminff_gray(wav[iwav],temp,nelectron) $
    + exthneubf_gray(wav[iwav],temp)*nhneutral*bn3 $
    + exthneuff_rr(wav[iwav],temp,nhneutral,nproton,nelectron)*nhneutral $
    + 0.664E-24*nelectron $
    + 1.13/2.*0.664E-24*(1216./float(wav[iwav]))^4*nhneutral
endfor

; ############################# here goes scientific integritry
fudgecontinuum=1.15 
fudgecontinuum=1.
extcont=fudgecontinuum*extcont

; copy and adapt SSB2 emergint.pro for emergent intensity
; I undid the outer iwav loop for speed
ext=fltarr(nwav,nh)
tau=fltarr(nwav,nh)
integrand=fltarr(nwav,nh)
profint=fltarr(nwav)
contint=fltarr(nwav)
wav=linewav+delwav
for ih=1,nh-1 do begin 
  ext[0,ih]=extcont[*,ih]+extthisline[*,ih]
  tau[0,ih]=tau[*,ih-1]+0.5*(ext[*,ih]+ext[*,ih-1])*$
    (height[ih-1]-height[ih])*1E5
  integrand[0,ih]=planck_micron(temp[ih],wav/1.E4)*exp(-tau[*,ih])
  profint=profint+0.5*(integrand[*,ih]+integrand[*,ih-1])*(tau[*,ih]-tau[*,ih-1])
endfor

; repeat for continuum only (it might be sloped)
; I use the ban-the-asterisk-axiom but I don't think it helps
tau=fltarr(nwav,nh)
for ih=1,nh-1 do begin 
  ext[0,ih]=extcont[*,ih]
  tau[0,ih]=tau[*,ih-1]+0.5*(ext[*,ih]+ext[*,ih-1])*$
    (height[ih-1]-height[ih])*1E5
  integrand[0,ih]=planck_micron(temp[ih],wav/1.E4)*exp(-tau[*,ih])
  contint=contint+0.5*(integrand[*,ih]+integrand[*,ih-1])*(tau[*,ih]-tau[*,ih-1])
endfor

; === inspect computed profile 

; convert units to J m_2 s-1 Hz-1 ster-1 (same as RH for comparison)
clightmum=2.99792458*1D14 ; mum/s
profint=((linewav*1.E-4)^2/clightmum)*profint
contint=((linewav*1.E-4)^2/clightmum)*contint
plot,wav,profint,linestyle=2, $
  xrange=[wav[0],wav[nwav-1]],xstyle=1, $
  yrange=[0,1.1*max(profint)],ystyle=1
oplot,wav,contint,linestyle=2

wait,stopwait   ; STOP

; get Neckel atlas (absolute intensities) 
neckelpath='/home/rutten/rr/wrk/atlases/neckel/'
neckelsave='neckel_intens_atlas.idlsave'
restore,neckelpath+neckelsave

; compare with Neckel disk-center atlas and its continuum
clightAA=299792458.*1D10 ; in AA/s  ; funny notation
neckelint=(neckelwav*neckelwav/clightAA)*neckelint*1E4
neckelcont=(neckelwav*neckelwav/clightAA)*neckelcont*1E4
oplot,neckelwav,neckelint
oplot,neckelwav,neckelcont

; the RH output for FALC also has too high continuum but there it
; sits just below 4x10^-8 so a lot lower than this value and only just
; above the Neckel continuum.  I need fudgecont=1.15!  What is the
; missing opacity?  Or what is my error?  Same discrepancy for
; BaII4554.  I tested the WSA MgI contribution in
; ltelib/test_extcont_falc.pro but it is less than 1 percent.  There I
; also compared the Gray functions with the WSA ones, differences at
; most half percent.  Something rotten in Lingezicht Castle?

; The damping seems pretty good for NaD1 but too small for other
; lines.

; Of course the cores show LTE reversals, the HOLMUL model would do
; better!

end


