; file: extcont_gray_figs.pro = reproduce Gray's continuous extinction figures
; init: Jul  9 2010 
; last: Nov 25 2016  Rob Rutten  Deil
; note: Gray 2005oasp.book.....G = 3rd edition, Figs 8.5_abcd 
;       He included correction stimulated emission
;       He included helium, I don't
;       He used analytic Boltzmann summation for H_bf, I add them up
;       His figure 8.5a is wrong regarding H^min_ff (he forgot the *E26)

;; pro,noppes ;RR insert to make IDLWAVE indentation work

; set plot to screen (for testing) or to ps
psplot=1

; if X then open plot window besides emacs frame 
if (psplot eq 0) then begin
  set_plot,'x'
  window,xpos=0,ypos=380,xsi=630
endif

; read physics constants (cgs)
@constants_cgs.idl

; wavelength grid
nwav=360
wav=indgen(nwav)*50.+3000 ; Angstrom

; Gray plot details
graytemp=[5143,6429,7715,11572]
graylogpe=[1.08,1.77,2.50,2.76]
grayranges=[[0,9],[0,5],[0,5.5],[0,700]]
grayplotnames=['grayfiga.ps','grayfigb.ps','grayfigc.ps','grayfigd.ps']

; start big loop over Gray plots
ngrayplots=size(graytemp,/n_elements)
for iplot=0,ngrayplots-1 do begin
; for iplot=2,2 do begin ;; the most crowded example, good for checking
  
; setup psplot
  axrat=1.618 
  psfilename=grayplotnames[iplot]
  if (psplot) then openpsplot,psfilename,$
    thick=2,fontsize=9,xsize=8.8,ysize=8.8/axrat

; neutral hydrogen extinction 
  temp=graytemp[iplot]
  logpe=graylogpe[iplot]
  pe=10^logpe
  eldens=pe/(kcgs*temp)
  logne=alog10(eldens)
  xrange=[min(wav),max(wav)]
  yrange=grayranges[*,iplot]
  exthneubf=exthneubf_gray(wav,temp)
  exthneuff=exthneuff_gray(wav,temp)
  norm=pe*1.E-26

; plot HI bf 
  plot,wav,exthneubf/norm,linestyle=3,$
       xrange=xrange,xstyle=1,yrange=yrange,ystyle=1,$
       xtickformat='(I5)',$
       xtitle=textoidl("\lambda  [")+cgsymbol("angstrom")+']',$
       ytitle=textoidl("\alpha_\lambda / P_e x 10^{26}  per HI atom")

; add HI ff 
  oplot,wav,exthneuff/norm,linestyle=3
;;  oplot,wav,(exthneubf+exthneuff)/norm,linestyle=3

; add Hmin ff, bf
  exthminbf=exthminbf_gray(wav,temp,eldens)
  exthminff=exthminff_gray(wav,temp,eldens)
  oplot,wav,exthminbf/norm,linestyle=1
  oplot,wav,exthminff/norm,linestyle=1
;;  oplot,wav,(exthminbf+exthminff)/norm,linestyle=1

; add sum curve all four
  oplot,wav,(exthneubf+exthneuff+exthminbf+exthminff)/norm

; add parameter labels
  xyouts,0.7,0.8,/norm,'T = '+ntostr(temp)
  xyouts,0.7,0.72,/norm,textoidl("log P_e = ")+ntostr(logpe,format='(F5.2)')
  xyouts,0.7,0.65,/norm,textoidl("log N_e = ")+ntostr(logne,format='(F5.1)')

; plot done  
  if (psplot) then closepsplot,psfilename,opengv=1

endfor ; end loop over Gray plots

end

; ============== run per Hyper c ============================
