PRO Show, pic, win, title=tit, free=free, scale=scale0, pos=pos, $
          center=center, opt=opt, use_exist=usex, gamma=gamma, true=true, $
          MAX=maximize, use_colortable=use_ct
;+
; NAME:
;       SHOW
; PURPOSE:
;       Show an image in an own window of apropriate size.
; CATEGORY:
;       Image display
; CALLING SEQUENCE:
;       SHOW, IMAGE [, WINDOW] [, KEYWORDS] 
; INPUTS:
;       IMAGE : 2-d array.
; OPTIONAL INPUT PARAMETER:
;       WINDOW: Window number to use for showing IMAGE. DEFAULT: 1
; KEYWORDS:
;       TITLE : (input) String. Title for the window.
;
;       FREE  : (Flag) Find a currently unused window number.
;
;       SCALE : (input) Scale factor. Image is rescaled by a factor
;               scale in each direction or (if scale is a vector) to
;               xsize*scale(0), ysize*scale(1).
;
;       POS   : (input) Position of the window on screen
;
;       CENTER: (Flag) Center window in screen
;
;       OPT   : (Flag) Perform histogram optimisation to display (using
;               routine histo_opt). Good for data with some extreme
;               bright or dark points.
;       USE_EX: (Flag) reuse an existing window, don't create a new one
;
;       GAMMA:  (Float) display gamma setting
;
;       TRUE:   (int) image is a true-color image, the value of true
;               tells which is the dimension (1-3) of the color planes
;       USE_COLORTABLE: (Flag) use an defined color table when in true color
;                       mode. 
;
; OUTPUTS:
;       none.
; SIDE EFFECTS:
;       A new window is creadted. If the window with the given number
;       already existed before, it is deleted.
; PROCEDURE:
;       Get size of IMAGE and eventually free window number. Create
;       Window. Rescale and TVSCL IMAGE.
; MODIFICATION HISTORY:
;       10-Dec-1989  P.Suetterlin, KIS
;       02-Feb-1994  Added Scale facility
;       27-Jun-2002  Remove stokes part.  Add gamma adjust
;       22-Jun-2003  Add MAXIMIZE function
;       07-Nov-2003  Add USE_COLORTABLE
;       28-Aug-2004  Clear window if using existing one
;-

n1 = 1
n2 = 2

IF n_params() LT 2 THEN win = 1
IF NOT keyword_set(free) THEN free = 0
IF NOT keyword_set(tit) THEN tit = 'Show Image '+strtrim(win, 2)
IF NOT keyword_set(scale0) THEN BEGIN
    scale = [1, 1]
    noscale = 1
ENDIF ELSE BEGIN
    IF n_elements(scale0) EQ 1 THEN $
      scale = [scale0, scale0] $
    ELSE $
      scale = scale0
    IF min(scale EQ [1, 1]) EQ 1 THEN noscale = 1 ELSE noscale = 0
ENDELSE 

IF n_elements(scale) EQ 1 THEN scale = [scale, scale]

s = size(reform(pic))                                     
IF (s(0) NE 2) THEN BEGIN
    IF s(0) EQ 3 THEN BEGIN
        IF NOT keyword_set(true) THEN BEGIN
            true = 0
              ;;; might be a true-color image - find a dim of three
            FOR i=1, 3 DO IF s(i) EQ 3 THEN true = i
        ENDIF
        IF true EQ 0 THEN BEGIN
            print, 'Wrong dimension, truecolor cube must have one dim of 3' 
            GOTO, aus
        ENDIF ELSE BEGIN
            CASE true OF
                1: BEGIN
                    n1 = 2
                    n2 = 3
                END
                2: BEGIN
                    n1 = 1
                    n2 = 3
                END
                Else:
            ENDCASE
        ENDELSE
    ENDIF ELSE BEGIN
        print, 'Wrong dimension, only 2D or true color cube'
        GOTO, aus
    ENDELSE
ENDIF ELSE true = 0

pic1 = reform(pic)

s = size(pic1)
IF keyword_set(maximize) THEN BEGIN
    device, get_screen_size=s_scr
    xmax = s_scr(0)-10
    ymax = s_scr(1)-30
    CASE true OF
        0: BEGIN & sx=s(1) & sy=s(2) & END
        1: BEGIN & sx=s(2) & sy=s(3) & END
        2: BEGIN & sx=s(1) & sy=s(3) & END
        3: BEGIN & sx=s(1) & sy=s(2) & END
    ENDCASE
    scale = (float(xmax)/sx) < (float(ymax)/sy)
    scale = [scale, scale]
    noscale = 0
ENDIF
  
IF keyword_set(usex) THEN BEGIN
    device, window_stat = stat
    IF stat(win) GT 0 THEN BEGIN
        wset, win
        erase
        wshow, icon = 0
        GOTO, have_win
    ENDIF
ENDIF

IF keyword_set(pos) THEN BEGIN
    window, win, xsize = s(n1)*scale(0), ysize = s(n2)*scale(1), tit = tit, $
      free = free, xpos = pos(0), ypos = pos(1)
ENDIF ELSE IF keyword_set(center) THEN BEGIN 
    device, get_screen_size=s_scr
    window, win, xsize=s(n1)*scale(0), ysize=s(n2)*scale(1), tit=tit, $
      free = free, xpos = (s_scr(0)-s(n1)*scale(0))/2, $ 
      ypos = (s_scr(1)-s(n2)*scale(1))/2 
ENDIF ELSE BEGIN
    window, win, xsi=s(n1)*scale(0), ysi=s(n2)*scale(1), $
      free=free, tit=tit
ENDELSE

Have_win:

IF noscale EQ 0 THEN BEGIN
    CASE true OF
        0: pic1 = congrid(temporary(pic1), s(n1)*scale(0), s(n2)*scale(1))
        1: pic1 = congrid(temporary(pic1), 3, s(n1)*scale(0), s(n2)*scale(1))
        2: pic1 = congrid(temporary(pic1), s(n1)*scale(0), 3, s(n2)*scale(1))
        3: pic1 = congrid(temporary(pic1), s(n1)*scale(0), s(n2)*scale(1), 3)
    ENDCASE
ENDIF

IF keyword_set(opt) THEN $
  pic1=histo_opt_rr(pic1)

IF keyword_set(gamma) THEN BEGIN
    pic1 = bytscl(pic1, top=255)
    g = byte(255*(findgen(256)/255)^(1./gamma))
    pic1 = g(pic1)
ENDIF

IF keyword_set(use_ct) THEN BEGIN
    pic1 = bytscl(temporary(pic1))
    tvlct, r, g, b, /get
    tv, r(pic1), 0, 0, 1
    tv, g(pic1), 0, 0, 2
    tv, b(pic1), 0, 0, 3
ENDIF ELSE $
  tvscl, pic1, true=true
Aus:

END
