function shift_sub, image, x0, y0, missing=missing, $
                    BlackBackground=BlackBackground
;+
; NAME: SHIFT_SUB
; PURPOSE:
;     Shift an image with subpixel accuracies
; CALLING SEQUENCE:
;      Result = shift_sub(image, x0, y0)
; uses INTERPOLATE : uses bilinear interpolation in 2D case
;-
; from Chae's IDL lib: 
;   http://www.bbso.njit.edu/~chae/IDL/shift_sub.pro
;
; /BlackBackground      missing pixels are set to 0
; missing=missing       missing pixels are set to <missing>

 
if n_params() eq 0 then begin
    message, /info, 'image = shift_sub(image, x0, y0, $'
    print, '       [/BlackBackground, missing=missing])'
    return, 0
endif

if keyword_set(BlackBackground) eq 0 then BlackBackground=0
if BlackBackground then missing=0
if keyword_set(missing) then BlackBackground=1

; check if integer shift
; if fix(x0)-x0 eq 0. and fix(y0)-y0 eq 0. then return, shift(image, x0, y0)
; NO! : I do not want wrapping around...

s =size(image)
x=findgen(s(1))#replicate(1., s(2))
y=replicate(1., s(1))#findgen(s(2))
x1= (x-x0)>0<(s(1)-1.)  ; keep indices within array limits
y1= (y-y0)>0<(s(2)-1.)  
if BlackBackground then begin
    return, interpolate(image, x1, y1, missing=missing)  
           ; bilinear interpolation
endif else return, interpolate(image, x1, y1) 
           ; missing pixels are nearest neighbor interpolated 
end 
