FUNCTION scale_array, data, top=ma, bottom=mi
;+
; NAME:
;       SCALE_ARRAY
; PURPOSE:
;       Bytescale an image sequence using the lowest maximum and
;       highest minimum intensity as thresholds.
; CALLING SEQUENCE:
;       Res = Scale_array(Movie, TOP=ma, BOTTOM=mi)
; INPUTS:
;       Movie:  3D array with images.
; KEYWORDS:
;       TOP   :
;       BOTTOM:  Use this values instead of looking for the lowest
;                min / highest max.
; MODIFICATION HISTORY:
;       23-Oct-1999  P.Suetterlin, SIU
;-

s = size(data)

IF NOT keyword_set(ma) THEN ma = max(data)
IF NOT keyword_set(mi) THEN mi = min(data)

FOR i=0, s(3)-1 DO BEGIN
    mi = mi > min(data(*, *, i), max=mx)
    ma = ma < mx
ENDFOR

  ;;; In cases of tight memory calling bytscl for the whole array
  ;;; exceeds the limits.  do it manually...

mm1 = bytarr(s(1), s(2), s(3))

FOR i=0, s(3)-1 DO mm1(*, *, i) = bytscl(data(*, *, i) > mi < ma)

return, mm1

END
