PRO Rubb_file, mov, num, AVERAGE=n_av, CELLSIZE=cs, STEP=sw, PLOT=plot, $
               SAME=same, RANGE=range, ALIGN=alig, SMOOTH=sm, WITHOUT_IMG=wi, $
               QUINTIC=quintic, MEDIAN=med
;+
; NAME:
;       RUBB_FILE
; PURPOSE:
;       Do `rubbersheeting' of a movie (stored on disk) to remove last jitter.
; CALLING SEQUENCE:
;       Rubb_file, Movie [, KEYWORDS ]
; INPUTS:
;       Movie  :  3D array with images.
; KEYWORDS:
;       ALIGN    : (flag) align images before computing displacements
;       AVERAGE  : (int) number of images to use for smoothing (Def: 3)
;       CELLSIZE : (int) cell size for correlation computation (Def: 32)
;       PLOT     : (flag/float) plot displacement vectors (multiplied
;                  by the value of PLOT).
;       RANGE    : (max. allowed range for displacements)
;       SAME     : (flag) use the currect window to plot.
;       STEP     : (int) step width for displacement computation (Def: 16)
; SIDE EFFECTS:
;       Input array gets overwritten by the result.
; PROCEDURE:
;       Compute average image as reference and call remap_image.
; MODIFICATION HISTORY:
;       28-Oct-1999  P.Suetterlin, SIU
;       03-Nov-2001  Change rubb to assoc arrays, rename to rubb_file
;       19-Feb-2002  map_image->remap_image
;       04-Mar-2002  SMOOTH option (pass-through to remap_image)
;       04-Feb-2003  Option WITHOUT_IMG to leave out the actual image
;                    from averaging
;       20-Nov-2003  QUINTIC password (pass through to remap_image/warp_tri)
;-
  ;;; do rubbersheeting of the movie to remove last jitter


IF NOT keyword_set(n_av) THEN n_av = 3
n_s = -(n_av-1)/2
n_e = n_s+n_av-1

IF NOT keyword_set(cs) THEN cs = 32
IF NOT keyword_set(sw) THEN sw = 18

s = size(mov)


  ;;; First the central part without summing problems:

FOR img=-n_s, num-1-n_e DO BEGIN
    ref = float(mov(img+n_s))
    FOR i=img+n_s+1, img+n_e DO ref = ref+mov(i)
    IF keyword_set(wi) THEN ref = ref-mov(img)
    mov(img)=remap_image(ref, mov(img), cs, sw, PLOT=plot, SAME=same, $
                         RANGE=range, ALIGN=alig, SMOOTH = sm, MEDIAN=med)
ENDFOR

  ;;; Now the rim:  low

FOR nn=-n_s-1, 1, -1 DO BEGIN
    img = nn
    ref = float(mov(0))
    FOR i=1, img+nn DO ref = ref+mov(i)
    IF keyword_set(wi) THEN ref = ref-mov(img)
    mov(img) = remap_image(ref, mov(img), cs, sw, PLOT=plot, SAME=same, $
                           RANGE=range, ALIGN=alig, SMOOTH = sm, MEDIAN=med)
    
ENDFOR
mov(0)=remap_image(mov(1), mov(0), cs, sw, PLOT=plot, SAME=same, $
                   RANGE=range, ALIGN=alig, SMOOTH=sm, MEDIAN=med)

  ;;; Now the rim:  high

FOR nn=n_e-1, 1, -1 DO BEGIN
    img = num-1-nn
    ref = float(mov(img-nn))
    FOR i=img-nn+1, num-1 DO ref = ref+mov(i)
    IF keyword_set(wi) THEN ref = ref-mov(*, *, img)
    mov(img) = remap_image(ref, mov(img), cs, sw, PLOT=plot, SAME=same, $
                           RANGE=range, ALIGN=alig, SMOOTH=sm, MEDIAN=med)
ENDFOR
mov(num-1) = remap_image(mov(num-2), mov(num-1), cs, sw, PLOT=plot, SAME=same,$
                         RANGE=range, ALIGN=alig, SMOOTH=sm, QUINTIC=quintic, MEDIAN=med)

END

