PRO Rubb, mov, AVERAGE=n_av, CELLSIZE=cs, STEP=sw, PLOT=plot, SAME=same, $
          RANGE=range, ALIGN=alig, SMOOTH=sm, WITHOUT_IMG=wi, QUINT=quint, $
          MEDIAN=med
;+
; NAME:
;       RUBB
; PURPOSE:
;       Do `rubbersheeting' of a movie to remove last jitter.
; CALLING SEQUENCE:
;       Rubb, Movie [, KEYWORDS ]
; INPUTS:
;       Movie  :  3D array with images.
; KEYWORDS:
;       ALIGN    : (flag) align images before computing displacements
;       AVERAGE  : (int) number of images to use for smoothing (Def: 3)
;       CELLSIZE : (int) cell size for correlation computation (Def: 32)
;       PLOT     : (flag/float) plot displaceent vectors (multiplied
;                  by  value PLOT).
;       RANGE    : (max. allowed range for displacements)
;       SAME     : (flag) use the currect window to plot.
;       STEP     : (int) step width for displacement computation (Def: 16)
; SIDE EFFECTS:
;       Input array gets overwritten by the result.
; PROCEDURE:
;       Compute average image as reference and call remap_image.
; MODIFICATION HISTORY:
;       28-Oct-1999  P.Suetterlin, SIU
;       19-Feb-2002  map_image->remap_image
;       04-Mar-2002  SMOOTH option (pass-through to remap_image)
;       04-Feb-2003  Option WITHOUT_IMG to leave out the actual image
;                    from averaging
;       20-Nov-2003  QUINT password (pass through to remap_image/warp_tri)
;-

IF NOT keyword_set(n_av) THEN n_av = 3
n_s = -(n_av-1)/2
n_e = n_s+n_av-1

IF NOT keyword_set(cs) THEN cs = 32
IF NOT keyword_set(sw) THEN sw = 16

s = size(mov)
num = s(3)

FOR img=num/2, num-1 DO BEGIN
    
    f = (img+n_s) > 0
    l = (img+n_e) < (num-1)
    IF (l-f) GT 0 THEN $
      ref = total(mov(*, *, f:l), 3) $
    ELSE $
      ref = mov(*, *, f)
    
    IF keyword_set(wi) THEN ref = ref-mov(*, *, img)
    
    mov(*, *, img) = remap_image(ref, mov(*, *, img), cs, sw, PLOT=plot, $
                                 SAME=same, RANGE=range, ALIGN=alig, $
                                 SMOOTH=sm, QUINT=quint, MEDIAN=med)
        
ENDFOR

FOR img=num/2-1, 0, -1 DO BEGIN
    
    f = (img+n_s) > 0
    l = (img+n_e) < (num-1)
    IF (l-f) GT 0 THEN $
      ref = total(mov(*, *, f:l), 3) $
    ELSE $
      ref = mov(*, *, f)
    
    IF keyword_set(wi) THEN ref = ref-mov(*, *, img)
    
    mov(*, *, img) = remap_image(ref, mov(*, *, img), cs, sw, PLOT=plot, $
                                 SAME=same, RANGE=range, ALIGN=alig, $
                                 SMOOTH=sm, QUINT=quint, MEDIAN=med)
        
ENDFOR

END
