FUNCTION polarint, array, centered=cen
;+
; NAME:
;       POLARINT
; PURPOSE:
;       Generate the phi-average of a 2D array (in FFT-wrap order)
; CALLING SEQUENCE:
;       Result = Polarint(Data)
; INPUTS:
;       Data  : A 2-dim array that is index-wrapped as from the
;               fft routines. 
;
; KEYWORDS:
;       CENTERED: (Flag) If set, the origin is assumed to be at 
;                 (NX/2, NY/2)
;
; OUTPUTS:
;       Result: 1-d vector of length S/2 where S is the minimum of the
;               size of the X and Y sizes of the input array.
;
; RESTRICTIONS:
;       
; PROCEDURE:
;       for each integer value N, compute the average of all data
;       having a distance between N-0.5 and N+0.5 to the origin
; MODIFICATION HISTORY:
;       05-Jul-1996  P.Suetterlin, USG
;       21-Aug-2003  Change integration method: don't use where
;-

  ;;; Get the array size.
s = size(array)
sx = s(1)
sx2 = sx/2
sy = s(2)
sy2 = sy/2
s2 = sx2 < sy2

  ;;; Compute distance array, but shift origin to center if keyword
  ;;; CENTERED is used!
  ;;; We get the needed 0.5-shift by adding it and then FIX-ing it.
  ;;; This is, e.g., d will be 5 at all points where the distance r is
  ;;; 4.5 <= r < 5.5
IF NOT keyword_set(cen) THEN $
  d = fix(dist(sx, sy)+0.5) $
ELSE $
  d = fix(shift(dist(sx, sy), sx2, sy2)+0.5)

  ;;; This will be the result.  Could be up to S2 * Sqrt(2), but we
  ;;; want only the central part.
  ;;; But it's faster just to do it for all and only return a
  ;;; part. 

dm = max(d)+1
integ = 0.*replicate(array(0), dm)
w = lonarr(dm)

FOR i=0l, s(s(0)+2)-1 DO BEGIN
    integ(d(i)) = integ(d(i))+array(i)
    w(d(i)) = w(d(i))+1
ENDFOR

integ = (integ/w)(0:s2-1)

return, integ

END
