; file: makesharpdotcubes.pro
; init: May 20 2012 Rob Rutten @ Hollum
; last: Nov 23 2013  Rob Rutten  Sac Peak
; note: sharpens all frames of specified cube(s) with convert via assoc
;       run from temporary subdir below the Cubes dir in datadir

; ##### specify the input and output directories
indir='../rrcubes'          ; @ adapt?   ; no slash at end
outdir=''
outdir=indir

; select speficic cubes
infilelist=file_search(indir+'/*had-700*part')

; sharpen how much?
sharpen='1.5x1.5'  

; ========== should be parameterfree from here on =============

; get number of files
sizeinlist=size(infilelist)
nfiles=sizeinlist(1)

; make outcubedir if not yet present
spawn,' mkdir -p '+outdir

; read, process, write cubes one by one
for icube=0, nfiles-1 do begin

  ; get cube geometry and file datatype 
  infile=infilelist(icube)
  outfile=infile+'-sha'
  getdotcubegeom,infile,nx,ny,nt,datatype

  ; open input file for assoc
  get_lun, inunit
  openr,inunit,infile
  if (datatype eq 'float') then inarr=fltarr(nx,ny)
  if (datatype eq 'integer') then inarr=intarr(nx,ny)
  if (datatype eq 'byte') then inarr=bytarr(nx,ny)
  inassoc = assoc(inunit,inarr)

  ; open output file for assoc 
  get_lun, outunit
  openw,outunit,outfile
  outarr=intarr(nx,ny)
  outassoc = assoc(outunit,outarr)

  for it=0,nt-1 do begin
    inim=inassoc[it]
    print,'==== sharpen icube, it = ',icube,it
    pnginfile='/tmp/raw.png'
    pngoutfile='/tmp/sharp.png'
    ; special for Doppler image
    doppim=0
    if (min(inim) lt 100) then begin
      doppim=1
      inim=inim+15000 ; defined in makedopsumcubes; half of int word length
    endif
    write_png,pnginfile,inim
    spawn,'convert -sharpen '+sharpen+' '+pnginfile+' '+pngoutfile
    imout=read_png(pngoutfile)
    imout=imout[0,*,*]
    imout=reform(imout)
    imout=fix(imout)
    if (doppim) then imout=imout-15000
    outassoc[it]=imout
  endfor

  ; done with sharpen
  free_lun,inunit
  free_lun,outunit
  print,'  wrote: ',outfile

endfor ; end loop over files
end
