; file: makepartcubes.pro = select part and optional rotate 
; init: May 21 2012 Hollum
; last: Jan 24 2013 
; site: cddotlib
; note: run from temporary dir rr-idl next to /Cubes and /rrcubes

; ----------- input parameters

; input and output directories
indir='../Cubes'    ; no slash at end
outdir='../rrcubes' ; no slash at end

; select part size (multiples of 16 and LE 512x384 = XGA display)
nx2=512
ny2=384

; select shift from (0,0) after rotation
xoff=200
yoff=300

; select part rotation (parameter IDL rotate)
rotpar=1

; ========== should be parameterfree from here =============

; get the cube file names
infilelist=file_search(indir+'/*-cube-*')

; get number of files
sizeinlist=size(infilelist)
nfiles=sizeinlist(1)

; make outcubedir if not yet present
spawn,' mkdir -p '+outdir

; read, process, write cubes one by one
for ifile=0, nfiles-1 do begin

; get cube geometry and file datatype 
  infilename=infilelist(ifile)
  getdotcubegeom,infilename,nx,ny,nt,datatype

; open input file for assoc
  get_lun, inunit
  openr,inunit,infilename
  if (datatype eq 'float') then inarr=fltarr(nx,ny)
  if (datatype eq 'integer') then inarr=intarr(nx,ny)
  if (datatype eq 'byte') then inarr=bytarr(nx,ny)
  inassoc = assoc(inunit,inarr)

; define output dir/file name (clumsy IDL)
  geomold=resstring([nx,ny,nt])
  geomnew=resstring([nx2,ny2,nt])
  parts=strsplit(infilename,'-',/extract)
  sizename=size(parts)
  for i=0,sizename[1]-1 do if (parts[i] eq geomold) then parts[i]=geomnew
  outfilename=strjoin(parts,'-')+'-part'
  dirfile=strsplit(outfilename,'/',/extract)
  size=size(dirfile)
  outfilename=outdir+'/'+dirfile[size[1]-1]

; open output file for assoc 
  get_lun, outunit
  openw,outunit,outfilename
  if (datatype eq 'float') then outarr=fltarr(nx2,ny2)
  if (datatype eq 'integer') then outarr=intarr(nx2,ny2)
  if (datatype eq 'byte') then outarr=bytarr(nx2,ny2)
  outassoc = assoc(outunit,outarr)

; now rebin all images in this cube
  for it=0,nt-1 do begin
    inim=inassoc[it]
    rotim=rotate(inim,rotpar)
    cutim=rotim(xoff:xoff+nx2-1,yoff:yoff+ny2-1)
    outassoc[it]=cutim
  endfor

  ; done
  free_lun,inunit
  free_lun,outunit
  print,'  wrote: ',outfilename

; STOP ; do only the first one for trials

endfor ; end loop over files
end
