; file: makehistoptcubes.pro
; init: May 20 2012 Rob Rutten @ Hollum
; last: Jan 24 2013 
; note: sharpens and histo-opts each specified cube, needs cube in memory
;       run from temporary subdir below the Cubes dir in datadir

; ##### specify the input and output directories
indir='../rrcubes'          ; @ adapt?   ; no slash at end
outdir=''
outdir=indir

; select speficic cubes
infilelist=file_search(indir+'/*had-700*sha')

; histo-opt tail cutoff value 
histpar=0.0005

; ========== should be parameterfree from here on =============

; get number of files
sizeinlist=size(infilelist)
nfiles=sizeinlist(1)

; make outcubedir if not yet present
spawn,' mkdir -p '+outdir

; read, process, write cubes one by one
for icube=0, nfiles-1 do begin

; get cube geometry and file datatype 
  infile=infilelist(icube)
  outfile=infile+'-his'
  getdotcubegeom,infile,nx,ny,nt,datatype

; read input file into cube
  if (datatype eq 'float') then cube=fltarr(nx,ny,nt)
  if (datatype eq 'integer') then cube=intarr(nx,ny,nt)
  if (datatype eq 'byte') then cube=bytarr(nx,ny,nt)
  get_lun, inunit
  openr,inunit,infile
  readu,inunit,cube
  free_lun,inunit

; do histo_opt
  cube=histo_opt_rr(cube,histpar)
  if (datatype eq 'float') then cube=float(cube)
  if (datatype eq 'integer') then cube=fix(cube)
  if (datatype eq 'byte') then cube=byte(cube)
  get_lun, outunit

; write output cube into output file
  openw,outunit,outfile
  writeu,outunit,cube
  free_lun,outunit
  print,' === wrote: ',outfile

endfor ; end loop over files
end

