; file: makeflowarrowcubefile.pro = cube arrow images from vx & vy flow cubes
; init: Jan 31 2013  Rob Rutten  LA Deil
; last: May  4 2013  Rob Rutten  LA Deil
; note: Uses assoc to read input cubes and write output cube as files.

; ============= start of main part; adapt the below ==================

; ##### specify input parameters
trial=1     ; 1 for arrow style trials (shows sample image)
ngrid=10    ; select how many points get arrows
nsmooth=0   ; smooth vector field, only > fwhm in makeflowcubes has effect
arrowscale=10  ; arrow lengths (##### choose by trial and error)
itstart=0   ; set time step of desired segment start (0 = from begin of cube)
itend=0     ; set desired segment end; if 0 then to end of cube

; =========== telescope-dependent parameters; comment other out =======

; ============ DOT =================
;; ; ##### specify output path and filenames
;; indir='/home/rutten/data/DOT/2005-07-13-spot/rrcubes/'
;; vxfile='AR0789-gb-flox-20050713-cube-1074x814x332-dt30-lo7'
;; vyfile='AR0789-gb-floy-20050713-cube-1074x814x332-dt30-lo7'

;; ; ##### specify output path and filenames; adapt nt if only segment
;; outdir='./'
;; outdir=indir
;; vecfile='AR0789-gb-vect-20050713-cube-1074x814x332-dt30-lo7'

;; ; get cube geometry and file datatype (telescope-dependent)
;; getdotcubegeom,indir+vxfile,nx,ny,nt,datatype
;; if (itend eq 0) then itend=nt-1
;; headersize=0   
;; header=0  
;; bigendian=0

; ============= SST ================
;; ; ##### specify input path and filename
;; indir='/home/rutten/data/SST/2011-05-07-EB2/cubes/'
;; vxfile='fe6302-20110507-flox.icube'
;; vyfile='fe6302-20110507-floy.icube'

;; ; ##### specify output path and filename
;; outdir='./'
;; outdir=indir
;; vecfile='fe6302-20110507-vect.icube'

;; ; get cube geometry and file datatype (telescope-dependent)
;; lp_readheader,indir+vxfile,header=header,datatype=datatype, $
;;   dims=dims,nx=nx,ny=ny,nt=nt,endian=endian_file
;; if (itend eq 0) then itend=nt-1
;; headersize=512
;; if (datatype eq 4) then datatype='float' else $
;; if (datatype eq 2) then datatype='integer' else $
;; if (datatype eq 1) then datatype='byte'
;; header=make_lp_header(intarr(nx,ny,itend-itstart+1))
;; bigendian=0

; ============= HMI on SST grid ===============
; ##### specify input path and filename
indir='/home/rutten/data/SST/2011-05-07-EB2/cubes/'
vxfile='hmib-2011-05-07-pixel-flox.icube'
vyfile='hmib-2011-05-07-pixel-floy.icube'

; ##### specify output path and filename
outdir='./'
outdir=indir
vecfile='hmii-2011-05-07-pixel-vect.icube'

; get cube geometry and file datatype (telescope-dependent)
lp_readheader,indir+vxfile,header=header,datatype=datatype, $
  dims=dims,nx=nx,ny=ny,nt=nt,endian=endian_file
if (itend eq 0) then itend=nt-1
headersize=512
if (datatype eq 4) then datatype='float' else $
if (datatype eq 2) then datatype='integer' else $
if (datatype eq 1) then datatype='byte'
header=make_lp_header(intarr(nx,ny,itend-itstart+1))
bigendian=0


;; ; ============= fits files (SDO) ======================
;; ; ##### specify input path and filename
;; indir='/home/rutten/data/SDO/2011-08-18-bello/cubes/'
;; vxfile='a1700-20110818-flox.fits'
;; vyfile='a1700-20110818-floy.fits'

;; ; ##### specify output path and filename
;; outdir='./'
;; outdir=indir
;; vecfile='a1700-20110818-pixel-vect.fits'

;; ; get cube geometry and file datatype (telescope-dependent)
;; inheader=headfits(indir+vxfile)
;; nx=fxpar(inheader,'naxis1') 
;; ny=fxpar(inheader,'naxis2') 
;; nt=fxpar(inheader,'naxis3') 
;; if (itend eq 0) then itend=nt-1
;; bitpix=fxpar(inheader,'bitpix')
;; if (bitpix eq 8) then datatype='byte'
;; if (bitpix eq 16) then datatype='integer'
;; if (bitpix eq -32) then datatype='float'
;; mkhdr,header,abs(bitpix)/8,[nx,ny,itend-itstart+1]
;; sizeheader=size(header)  ; fits header = Nx36 "card images" = Nx2880 bytes
;; headersize=(1+fix(sizeheader[1]/36.))*2880
;; bigendian=1

; ========== rest should be telescope/parameter-free ==============

; open input files for assoc
get_lun, unit_vx
if (bigendian) then openr,unit_vx,indir+vxfile,/swap_if_little_endian $
  else openr,unit_vx,indir+vxfile
if (datatype eq 'float') then vxarr=fltarr(nx,ny)
if (datatype eq 'integer') then vxarr=intarr(nx,ny)
if (datatype eq 'byte') then vxarr=bytarr(nx,ny)
vxassoc=assoc(unit_vx,vxarr,headersize)

get_lun, unit_vy
if (bigendian) then openr,unit_vy,indir+vyfile,/swap_if_little_endian $
  else  openr,unit_vy,indir+vyfile
if (datatype eq 'float') then vyarr=fltarr(nx,ny)
if (datatype eq 'integer') then vyarr=intarr(nx,ny) 
if (datatype eq 'byte') then vyarr=bytarr(nx,ny)
vyassoc=assoc(unit_vy,vyarr,headersize)

; open output file for assoc, write header 
get_lun, unit_vec
if (bigendian) then openw,unit_vec,outdir+vecfile,/swap_if_little_endian $
  else openw,unit_vec,outdir+vecfile
vecassoc=assoc(unit_vec,intarr(nx,ny),headersize)
if (headersize ne 0) then begin
  rec=assoc(unit_vec, bytarr(headersize))
  rec[0]=byte(header)
endif

; start big loop over timesteps it
vx=intarr(nx,ny)
vy=intarr(nx,ny)
for it=itstart,itend do begin 
print,' ==== time step ',it

; read vx and vy
vx=vxassoc[it]
vy=vyassoc[it]
  
; smooth and select grid values
if (nsmooth ne 0) then begin
  vx=smooth(vx,nsmooth,/edge_truncate)
  vy=smooth(vx,nsmooth,/edge_truncate)
endif
nxsample=nx/ngrid
nysample=ny/ngrid
xsample=fltarr(nxsample,nysample)
ysample=fltarr(nxsample,nysample)
for ix=0,nxsample-1 do xsample[ix,*]=float(ix*ngrid)
for iy=0,nysample-1 do ysample[*,iy]=float(iy*ngrid)

; define arrow anchor and tip coordinates
vxsample=fltarr(nxsample,nysample)
vysample=fltarr(nxsample,nysample)
for ix=0,nxsample-1 do begin
  for iy=0,nysample-1 do begin
     vxsample[ix,iy]=vx[ix*ngrid,iy*ngrid]
     vysample[ix,iy]=vy[ix*ngrid,iy*ngrid]
  endfor
endfor
vxsample=xsample+vxsample*arrowscale
vysample=ysample+vysample*arrowscale

; make vector arrow image (via tvrd since Tosh = 16-bit color)
window,xsize=nx,ysize=ny,/pixmap,retain=2
blank=bytarr(nx,ny)
tv,blank
arrow,xsample/nx,ysample/ny,vxsample/nx,vysample/ny,$
  /norm,hsize=-0.4,thick=0.1,color=255
arrowimage=tvrd()
 
;; ; show for check and arrow parameter selection
if (trial) then begin 
  window,xsize=nx,ysize=ny
  tvscl,arrowimage
  if (it eq itstart+4) then stop
end

; end big loop over timesteps it
vecassoc[it-itstart]=fix(arrowimage)
endfor 

; free the input and output files
free_lun,unit_vx,unit_vy,unit_vec

print,' === makeflowarrowcube properly completed'
end
