; file: makebytecubes.pro
; init: May 20 2012 Rob Rutten @ Hollum
; last: Jan 24 2013 
; note: bytescales each cube to max,min of cube per assoc
;       run from idl in temporary subdir next to rrcubes dir

; ##### specify the input and output directories
indir='../rrcubes'  ; no slash at end

; select specific cubes
infilelist=file_search(indir+'/*his')

; outdir 
outdir='../rrcubes' ; no slash at end

; ========== should be parameterfree from here on =============

; get number of files
sizeinlist=size(infilelist)
nfiles=sizeinlist(1)

; make outcubedir if not yet present
spawn,' mkdir -p '+outdir

; read, process, write cubes one by one
for icube=0, nfiles-1 do begin

; get cube geometry and file datatype 
  infilename=infilelist(icube)
  getdotcubegeom,infilename,nx,ny,nt,datatype

; open input file for assoc
  get_lun, inunit
  openr,inunit,infilename
  if (datatype eq 'float') then inarr=fltarr(nx,ny)
  if (datatype eq 'integer') then inarr=intarr(nx,ny)
  if (datatype eq 'byte') then inarr=bytarr(nx,ny)
  inassoc = assoc(inunit,inarr)

; define output dir/file name (clumsy IDL)
;  geomold=resstring([nx,ny,nt])
;  geomnew=resstring([nx2,ny2,nt2])
  parts=strsplit(infilename,'-',/extract)
  sizename=size(parts)
;  for i=0,sizename[1]-1 do if (parts[i] eq geomold) then parts[i]=geomnew
  outfilename=strjoin(parts,'-')+'-byt'
  dirfile=strsplit(outfilename,'/',/extract)
  size=size(dirfile)
  outfilename=outdir+'/'+dirfile[size[1]-1]

; open output file for assoc 
  get_lun, outunit
  openw,outunit,outfilename
  outarr=bytarr(nx,ny)
  outassoc = assoc(outunit,outarr)

; first pass to find extrema
  inim=fltarr(nx,ny)
  maxseq=-1.E10
  minseq=+1.E10
  for it=0,nt-1 do begin
    inim=float(inassoc(it))
    minim=min(inim)
    maxim=max(inim)
    if (minim lt minseq) then minseq=minim 
    if (maxim gt maxseq) then maxseq=maxim
  endfor

; special treatment for Doppler cubes with negative values
if (minim lt -100) then begin
  if (-minseq gt maxseq) then maxseq=-minseq else minseq=-maxseq
endif

print,' minseq, maxseq =',minseq,maxseq

; now handle all images in this cube
  for it=0,nt-1 do begin
    inim=inassoc[it]
    imout=byte(255.*(inim-minseq)/(maxseq-minseq))
    outassoc[it]=imout
  endfor

  ; done
  free_lun,inunit
  free_lun,outunit
  print,'  wrote: ',outfilename

endfor ; end loop over files
end
