; file: make4clockmovie.pro = make four-panel movie 
; last: May 21 2012 Rob Rutten @ Hollum 

; specify input and output directories
indir='../rrcubes'   ; no slash at end
outdir='../rr-idl'   ; no slash at end

; select the four panel cubes
incubes=strarr(4)
incubes[0]=file_search(indir+'/*gb*byt')
incubes[1]=file_search(indir+'/*ca*byt')
incubes[2]=file_search(indir+'/*ha-0000*byt')
incubes[3]=file_search(indir+'/*had-350*byt')

; define panel label names
label1='!17 G band'
label2='!17 Ca II H' 
label3='!17 H!7a!X line center'
label4='!17 H!7a!X Doppler'

; define movie file name
moviefile='2006-04-24-NW-gb+ca+hac+had-part.mpg'

; manual data settings
timestep=40  ; determined from FITS files
arcsecpx=0.071  ; arcsec/px without rebinning

; movie start and duration
toff=27   ; from FITS file names = part after big gap
tdur=81-toff  
  
; panel shift from (0,0)
xoff=0
yoff=0

; set clock params (### apply toff; from corresponding FITS file name)
starthr=09 ; data start 
startmin=26 ; data start 
startsec=58 ; data start
clocksizescale=0.5 ; half of Earth size

; ========== should be parameterfree from here =============

; panel size (multiples of 16 and LE 512x384 = XGA display)
nx2=512
ny2=384

; make label image (via tvrd since Tosh = 16-bit color)
window,xsize=2*nx2,ysize=2*ny2,/pixmap,retain=2
blank=bytarr(2*nx2,2*ny2)
tv,blank
xyouts,0.02,0.52,/norm,charsize=2.5,charthick=1.5,label1
xyouts,0.80,0.52,/norm,charsize=2.5,charthick=1.5,label2
xyouts,0.02,0.45,/norm,charsize=2.5,charthick=1.5,label3
xyouts,0.80,0.45,/norm,charsize=2.5,charthick=1.5,label4
imlabel=tvrd()

; check label locations (window will go away at clock production)
wdelete
window,xsize=2*nx2,ysize=2*ny2
tvscl,imlabel

; make movie cube
movie=bytarr(nx2*2,ny2*2,tdur)
for icube=1,4 do begin

; get cube geometry and file datatype 
  infile=incubes(icube-1)
  getdotcubegeom,infile,nx,ny,nt,datatype

  ; assoc into input cube
  close,1
  openr,1,indir+'/'+incubes(icube-1)
  p = assoc(1, bytarr(nx,ny))  ; for byte cubes only
  
  ; stick 4 cubes into single movie cube 
  for it=0,tdur-1 do begin
    image=p(toff+it)
    if (icube eq 1) then movie(0:nx2-1,ny2:2*ny2-1,it)=$
         image(xoff:xoff+nx2-1,yoff:yoff+ny2-1)
    if (icube eq 2) then movie(nx2:2*nx2-1,ny2:2*ny2-1,it)=$
         image(xoff:xoff+nx2-1,yoff:yoff+ny2-1)
    if (icube eq 3) then movie(0:nx2-1,0:ny2-1,it)=$
         image(xoff:xoff+nx2-1,yoff:yoff+ny2-1)
    if (icube eq 4) then movie(nx2:2*nx2-1,0:ny2-1,it)=$
         image(xoff:xoff+nx2-1,yoff:yoff+ny2-1)
  endfor
endfor

;STOP  ; inspect movie cube 

; clock timing params
s = size(movie, /dim)
Width = s(0)
Height = s(1)
N_Frames =  s(2)
tt = findgen(N_Frames)*TimeStep+starthr*3600.+startmin*60.+startsec
hr = fix(tt/3600.)
mn = fix((tt MOD 3600)/60)
sc = fix(tt MOD 60)
tt = nnumber(hr, 2)+":"+nnumber(mn, 2)+":"+nnumber(sc, 2)

; earth-size clock insertion  (via tvrd since Tosh = 16-bit color)
; mean earth diameter: 12742 km; sun: 725.3 km/arcsec; so earth = 17.5 arcsec
earthpx=fix(12742./(arcsecpx*725.3)+0.5)
sizeclock=earthpx*clocksizescale 
xclock=nx2-sizeclock/2
yclock=ny2-sizeclock/2
wdelete
window,xsize=2*nx2,ysize=2*ny2,/pixmap,retain=2
for it=0, N_Frames-1 do begin
    tv,blank
    siz=sizeclock
    xpos=xclock
    ypos=yclock
    clock,tt(it),/dev,siz=siz,pos=[xpos,ypos]
         ; === beware, pos values get changed in clock routine
    imclock = tvrd()

; get image, superimpose clock, labels, panel dividers
    image=movie(*,*,it)
    image(where(imclock gt 1))=255
    image(where(imlabel gt 1))=255
    image(*,ny2-1)=255  ; panel divider
    image(nx2-1,*)=255  ; panel divider
    movie(*,*,it)=image
endfor

; STOP ; inspect movie = labeled movie cube 

skipclock:

; write mpeg movie
mpegpathfile=outdir+'/'+moviefile
write_mpeg,mpegpathfile,movie,/high_qual,framerate=24
;; 24 = lowest permitted value
print,'  wrote ',mpegpathfile

end
