; file: make2x2cubes.pro
; init: Dec 29 2010 Rob Rutten @ Feusdorf
; last: Jan 24 2013 
; note: uses assoc to rebin all images in all cubes in indir

; ##### specify the input and output directories
indir='../Cubes'          ; @ adapt?   ; no slash at end
outdir='../rrcubes'       ; @ adapt?   ; no slash at end

; ========== should be parameterfree from here on =============

; get the cube file names
infilelist=file_search(indir+'/*-cube-*')

; get number of files
sizeinlist=size(infilelist)
nfiles=sizeinlist(1)

; make outcubedir if not yet present
spawn,' mkdir -p '+outdir

; read, process, write cubes one by one
for ifile=0, nfiles-1 do begin

; get cube geometry and file datatype 
  infilename=infilelist(ifile)
  getdotcubegeom,infilename,nx,ny,nt,datatype

; open input file for assoc
  get_lun, inunit
  openr,inunit,infilename
  if (datatype eq 'float') then inarr=fltarr(nx,ny)
  if (datatype eq 'integer') then inarr=intarr(nx,ny)
  if (datatype eq 'byte') then inarr=bytarr(nx,ny)
  inassoc = assoc(inunit,inarr)

; set new image dimensions
  nx2=nx/2
  ny2=ny/2
  nt2=nt

; define output dir/file name (clumsy IDL)
  geomold=resstring([nx,ny,nt])
  geomnew=resstring([nx2,ny2,nt2])
  parts=strsplit(infilename,'-',/extract)
  sizename=size(parts)
  for i=0,sizename[1]-1 do if (parts[i] eq geomold) then parts[i]=geomnew
  outfilename=strjoin(parts,'-')+'-2x2'
  dirfile=strsplit(outfilename,'/',/extract)
  size=size(dirfile)
  outfilename=outdir+'/'+dirfile[size[1]-1]

; open output file for assoc 
  get_lun, outunit
  openw,outunit,outfilename
  if (datatype eq 'float') then outarr=fltarr(nx2,ny2)
  if (datatype eq 'integer') then outarr=intarr(nx2,ny2)
  if (datatype eq 'byte') then outarr=bytarr(nx2,ny2)
  outassoc = assoc(outunit,outarr)

; now rebin all images in this cube
  for it=0,nt-1 do begin
    inimage=inassoc[it]
    outassoc[it]=rebin(inimage,nx2,ny2)
  endfor

  ; done
  free_lun,inunit
  free_lun,outunit
  print,'  wrote: ',outfilename

endfor ; end loop over files
end
