PRO Kreis, x, y, rx, ry, phase, normal=norm, device=dev, fill=fill, $
           thick=thick, linestyle=style, _extra=extra
;+
; NAME:
;       KREIS
; PURPOSE:
;       Draw a circle
; CATEGORY:
;       
; CALLING SEQUENCE:
;       Kreis, CX, CY, RX [, RY [, PHASE]]
; INPUTS:
;       CX, CY : Center of the circle, either in data (default),
;                device or normal coordinates.
;       RX, RY : Radius for circle in X and Y. If RY is omitted it is
;                computed to get a view-correct circle.
;       PHASE  : Pase angle. Makes the ellipsis rotate its
;                axis. Posotive values rotate counterclockwise. Values
;                between -PI and PI are ok.
; KEYWORDS:
;       THICK  : (input) Linethickness
;   LINESTYLE  : (input) Line shape (see PLOT)
;       FILL   : (input) Fill the circle using color FILL
;       NORMAL : (Flag) Values are in Normal coordinates ( 0. - 1. )
;       DEVICE : (Flag) Values are in Device coordinates.
; MODIFICATION HISTORY:
;       21-Jul-1994  P.Suetterlin, KIS
;-

IF n_params() LT 3 THEN BEGIN
    message, 'Use: Kreis, Xcent, Ycent, RadX [, RadY]'
ENDIF

IF NOT keyword_set(thick) THEN thick = 1
IF NOT keyword_set(style) THEN style = 0

IF n_params() LT 5 THEN phase = 0

IF n_params() LT 4 THEN BEGIN
    IF keyword_set(dev) THEN BEGIN
        ry = rx
    ENDIF ELSE IF keyword_set(norm) THEN BEGIN
        rd = convert_coord([0, rx], [0, 0], /norm, /to_dev)
        rd = rd(0, 1)-rd(0, 0)
        ry = convert_coord([0, 0], [0, rd], /dev, /to_norm)
        ry = abs(ry(1, 1)-ry(1, 0))
    ENDIF ELSE BEGIN
        rd = convert_coord([0, rx], [0, 0], /to_dev)
        rd = rd(0, 1)-rd(0, 0)
        ry = convert_coord([0, 0], [0, rd], /dev, /to_data)
        ry = abs(ry(1, 1)-ry(1, 0))
    ENDELSE 
ENDIF

ang = indgen(361)
cp = cos(phase)
sp = sin(phase)
sang = rx*sin(ang/180.*!Pi)
cang = ry*cos(ang/180.*!Pi)
tmp = cp*sang-sp*cang
cang = sp*sang+cp*cang
sang = tmp

IF (size(fill))(1) NE 0 THEN BEGIN
    polyfill, sang+x, cang+y, device=dev, norm=norm, $
      col=fill, _extra=extra
ENDIF ELSE BEGIN
    plots, sang+x, cang+y, device=dev, norm=norm, $
      thick=thick, linestyle=style, _extra=extra
ENDELSE

END

