; file: getdotcubegeom.pro = get DOT cube geometry and file type from filename
; init: Dec 28 2010 Rob Rutten Feusdorf
; note: IDL tricks from readdotcube by Tim van Werkhoven

pro getdotcubegeom,filename,nx,ny,nt,datatype

if (n_params() lt 1) then begin
  print,' getgeomcube,filename,nx.ny.nt,datatype
  return
endif

;------------------------ get the cube geometry 

; split the filename in segments between '-'
filespl = strtok(filename,'-',/extract)

; find size parameters from 2 x presences starting at end
found=-1
for i=n_elements(filespl)-1,0,-1 do begin
 
; split each filenamepart by 'x'
  xpart = STRTOK(filespl[i],'x',/EXTRACT)
 
; count the number of matches with x
  c = (SIZE(xpart))[1]
 
; geeometry = XXxYYxTT so double x occurrence
   if (c gt 2) then begin
     ;; print,'Probably found size, using this string:',filespl[i]
     found=c
     break
   endif
endfor

; get the geometry values
geom = FIX(xpart)
nx=geom[0]
ny=geom[1]
nt=geom[2]

; -------------------- determine the file data type

; get the filesize 
filesize = (file_info(filename)).size
if (filesize eq 0) then print,'  ==== error: zero size file ',filename

; divide filesize by geometry size
nrbytes = filesize/PRODUCT(geom)

if (nrbytes ne ROUND(nrbytes)) then $
  print,' ==== error: filesize / dimensions not a natural number'
if (fix(nrbytes) eq 4) then datatype='float'
if (fix(nrbytes) eq 2) then datatype='integer'
if (fix(nrbytes) eq 1) then datatype='byte'

end

