FUNCTION gen_timeaxis, x
;+
; NAME:
;       GEN_TIMEAXIS
; PURPOSE:
;       generate nice hour:minute marks from seconds-since-midnight array
; CALLING SEQUENCE:
;       LABELS = GEN_TIMEAXIS( X )
; INPUTS:
;       X: Vector (x-axis) with time as seconds since 00:00 UT
; OPTIONAL PARAMETERS:
;       
; KEYWORDS:
;       
; OUTPUTS:
;       LABELS: Structure with needed values to generate plot axis:
;                ticks, minor, tickv, name
; PROCEDURE:
;       Based on range set spacing between major tickmarks and number
;       of minor tickmarks.  Pack into a structure.  
;       Example of use:
;          Given a variable Y measured at times X
;          L = GEN_TIMEAXIS(X)
;          PLOT, X, Y, XTICKV=l.tickv, XTICKS=l.ticks, XMIN=l.minor, XTICKNAM=l.name
; MODIFICATION HISTORY:
;       23-Jan-2006  P.Suetterlin, SIU
;-

mi = min(x, max=ma)
range = ma-mi

IF range LE 1500 THEN BEGIN
    x0 = fix(mi/300)
    x0 += (x0 EQ mi/300. ? 0:1)
    x1 = fix(ma/300)
    ticks = x1-x0
    tickv = (lindgen(ticks+1)+x0)*300l
    minor = 5
    name = strtrim(tickv/3600, 2)+':'+nnumber((tickv-tickv/3600*3600)/60, 2)
    return, {ticks: ticks, $
             minor: minor, $
             tickv: tickv, $
             name:  name}
ENDIF
IF range LE 2700 THEN BEGIN
    x0 = fix(mi/600)
    x0 += (x0 EQ mi/600. ? 0:1)
    x1 = fix(ma/600)
    ticks = x1-x0
    tickv = (lindgen(ticks+1)+x0)*600l
    minor = 5
    name = strtrim(tickv/3600, 2)+':'+nnumber((tickv-tickv/3600*3600)/60, 2)
    return, {ticks: ticks, $
             minor: minor, $
             tickv: tickv, $
             name:  name}
ENDIF
IF range LE 5400 THEN BEGIN
    x0 = fix(mi/900)
    x0 += (x0 EQ mi/900. ? 0:1)
    x1 = fix(ma/900)
    ticks = x1-x0
    tickv = (lindgen(ticks+1)+x0)*900l
    minor = 3
    name = strtrim(tickv/3600, 2)+':'+nnumber((tickv-tickv/3600*3600)/60, 2)
    return, {ticks: ticks, $
             minor: minor, $
             tickv: tickv, $
             name:  name}
ENDIF 
IF range LE 10800 THEN BEGIN
    x0 = fix(mi/1200)
    x0 += (x0 EQ mi/1200. ? 0:1)
    x1 = fix(ma/1200)
    ticks = x1-x0
    tickv = (lindgen(ticks+1)+x0)*1200l
    minor = 4
    name = strtrim(tickv/3600, 2)+':'+nnumber((tickv-tickv/3600*3600)/60, 2)
    return, {ticks: ticks, $
             minor: minor, $
             tickv: tickv, $
             name:  name}
ENDIF ELSE BEGIN
    x0 = fix(mi/1800)
    x0 += (x0 EQ mi/1800. ? 0:1)
    x1 = fix(ma/1800)
    ticks = x1-x0
    tickv = (lindgen(ticks+1)+x0)*1800l
    minor = 3
    name = strtrim(tickv/3600, 2)+':'+nnumber((tickv-tickv/3600*3600)/60, 2)
    return, {ticks: ticks, $
             minor: minor, $
             tickv: tickv, $
             name:  name}
ENDELSE

END


 
        
