; file: find_points.pro
; last: Oct 14 2011 
; note: Rob Rutten annotation of Pit Suetterlin routine

; Manual (from Pit Suetterlin email 10 Oct 2011)

  ;; ref_pic=referenceimage
  ;; pic=imagetoalign
  ;; delvar, ref_points, f_points 
  ;; .run find_points 

;; This will open a window with the reference image (called 'G Band')
;; and two small ones (named 'Calcium' and 'G-Band').  The two show a
;; small part of the two images around the current cursor position in
;; the (big) reference image.

;; You now try to locate identical features in the two images.  Look
;; at the small images for that, and mark the feature first in the
;; reference image with the left mouse button, then in the 'Calcium'
;; image with the right button.  Small circles will be drawn in the
;; images to mark the points you already located.  Middle mouse button
;; will quit.

;; Now you have two arrays, ref_points and f_points.  Those you can
;; use to determine scaling and shift.  I use mpfit for this (a
;; routine from Craig Markwardt):

;;   fa={X:float(ref_points),Y:float(f_points)}
;;   p=[618., 482., 0., 1., 0., 0.]
;; ; the first two define the pivot point for rotation, say ref image center
;;   pi = replicate({fixed:0b, limited: [1b, 1b], limits: [1.,1.]},6)
;;   pi(0:1).fixed=1
;;   pi.limits(0)=[618.,482.,-.18,0.95,-30,-30]
;;   pi.limits(1)=[618.,482.,.18,1.05,30,30]
;; ; search area limits (10 deg rotation, 5% scale, 30 px shift
;;   p1=mpfit('rsf',p,functargs=fa,parinfo=pi,/quiet)
;;   print,p1

;; ; check your point+shift distribution:
;;   plot,f_points(0,*),f_points(1,*),psy=1
;;   plots,rsff(p1,ref_points),psy=4

;; ; apply the shift, scale and rotate to the image to be aligned:
;;   pic1 = shift(rot(pic,-p1[2]*!radeg, 1./p1[3],p1[0],p1[1],/pivot),$
;;      round(-p1[4]),round(-p1[5]))

;; ; check with flickrr:
;;   window,xsi=1000,ysi=800
;;   flickrr,ref_pic,pic1,1


PRO Markpoint, x, y, GOOD=g, BAD=b
kreis, x, y, 10, /dev, line=b
END 


; Bilder laden, find_points starten und die beiden positionen mit mpfit
; und rsf angleichen.  Ergebnis ist jeweils ein Vektor p:

; p = [ x0, y0, alpha, scale, dx, dy ]   (x0 und y0 sind fix)


; t='105116'
; f0='OK/AR10349_02may03_'
; rdfits,pic,f0+'c_'+t+'.fits'    & pic=pic(*,*,0)
; rdfits,refpic,f0+'g_'+t+'.fits' & refpic=refpic(*,*,0)
; delvar, ref_points, f_points
; .run find_points

; fa={X:float(ref_points),Y:float(f_points)}
; p=[618., 482., 0., 1., 0., 0.]
; pi={fixed:byte([1,1,0,0,0,0])}
; p1=mpfit('rsf',p,functargs=fa,parinfo=pi,/quiet)
; wset,0 & plot,f_points(0,*),f_points(1,*),psy=1
; plots,rsff(p1,ref_points),psy=4

; print,p1,format="(2i5,2f12.7,2f7.2)"

mag = 1
dx = 0
dy = 0
t1 = histo_opt_rr(rescale(ref_pic, scale=1./mag))
show, t1, tit='G Band'
window, 2, xsi=256, ysi=256, tit='Calcium'
window, 3, xsi=256, ysi=256, tit='G-Band'

s = size(t1, /dim)
s2 = size(pic, /dim) < size(ref_pic, /dim)
sl = string(27b)+'[D'
FOR i=1, 10 DO sl = sl+string(27b)+'[D'

Weiter:
wset, 1
n = n_elements(ref_points)
IF n EQ 0 THEN BEGIN
    ref_points=[0, 0]
    f_points=[0, 0]
ENDIF ELSE BEGIN
    FOR i=0, n/2-1 DO markpoint, ref_points(0, i), ref_points(1, i), /good
    FOR i=0, n/2-1 DO markpoint, f_points(0, i), f_points(1, i), /bad
ENDELSE

REPEAT BEGIN
    wset, 1
    cursor, x, y, /dev, /change
    maus = !err
    key = get_kbrd(0)
    CASE key OF
        'x': BEGIN
                sp = n_elements(ref_points)/2-1
                dx = ref_points(0, sp)-f_points(0, sp)
                dy = ref_points(1, sp)-f_points(1, sp)
             END
        ELSE: 
    ENDCASE
         
    IF maus EQ 1 THEN BEGIN
          ;;; this is a point in Ca
        markpoint, x, y, /good
        wait, 1   
        ref_points = [[ref_points], [x, y]]
    ENDIF
    
    IF maus EQ 4 THEN BEGIN
          ;;; this is a point in G band
        markpoint, x, y, /bad
        wait, 1   
        f_points = [[f_points], [x, y]]
    ENDIF
    
    X0 = (mag*x-128) > 0
    y0 = (mag*y-128) > 0
    x1 = x0+255
    IF x1 GE s2(0) THEN BEGIN
        x1 = s2(0)-1
        x0 = x1-255
    ENDIF
    y1 = y0+255
    IF y1 GE s2(1) THEN BEGIN
        y1 = s2(1)-1
        y0 = y1-255
    ENDIF
    
    wset, 2
    tvscl, pic(x0:x1, y0:y1)
    kreis, mag*x-x0, mag*y-y0, 10, /dev
    kreis, mag*(x-dx)-x0, mag*(y-dy)-y0, 10, /dev, /line
    
    wset, 3
    tvscl, ref_pic(x0:x1, y0:y1)
    kreis, mag*x-x0, mag*y-y0, 10, /dev
    kreis, mag*(x+dx)-x0, mag*(y+dy)-y0, 10, /dev, /line
    
ENDREP UNTIL maus EQ 2
print
IF n_elements(ref_points) GT 2 THEN $
  IF total(ref_points(*, 0)) EQ 0 THEN ref_points = ref_points(*, 1:*)
IF n_elements(f_points) GT 2 THEN $
  IF total(f_points(*, 0)) EQ 0 THEN f_points = f_points(*, 1:*)

END
    
