; file: filterallcubes.pro = main to filter all cubes in a cube dir
; init: Dec 14 2010 
; last: Dec 15 2010 

cubedirname='../Cubesfullrubb'     ; @ adapt?

; get the cube file names
filelist=file_search(cubedirname+'/*-cube-*')

; get list size
sizefilelist=size(filelist)
nfiles=sizefilelist(1)
 
; read, filter, and write cubes one by one
for ifile=0, nfiles-1 do begin
  incube=readdotcube(filelist(ifile))
     ; conefilt, cubearray, px in km, cadence in sec, filter slope in km/s
  conefilt,incube,51,30,7               ; @ adapt?
  get_lun, unit
  openw, unit,filelist(ifile)+'-lo7'
  writeu,unit,incube
  close,unit
endfor

end

