; file: dotximovie.pro
; init: Dec 29 2010 Rob Rutten Feusdorf
; last: Nov 15 2020  Rob Rutten  Deil

pro dotximovie,filename,_extra=xikeywords

;+
;  dotximovie.pro = start ssw ximovie.pro on a DOT data cube;
;  distills cube dimensions and filetype from the file name
;  all ximovie keywords allowed (including afile2)
;-

; no-parameter call info return
if n_params() eq 0 then begin
   message, /info, 'dotximovie, filename [,ximovie_keywords]'
   return
endif

; get cube dimensions and file datatype
getdotcubegeom,filename,nx,ny,nt,datatype

; call ximovie
if (datatype eq 'float') then $
  ximovie, filename,nx,ny,/float,_extra=xikeywords

if (datatype eq 'integer') then $
  ximovie, filename,nx,ny,/int,_extra=xikeywords

if (datatype eq 'byte') then $
  ximovie, filename,nx,ny,_extra=xikeywords

end

; ================================================ IDLWAVE run

cd,'/media/rutten/RRHOME/alldata/DOT/2005-07-13-spot/rrcubes'

dotximovie,'AR0789-bc-0000-20050713-cube-537x407x332-dt30-2x2'

end
