; file: dot_openassoc.pro
; init: Jun 24 2017  Rob Rutten  Deil
; last: Jul 20 2017  Rob Rutten  Deil

;+

pro dot_openassoc,file,$
   lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian
 
 ; NAME:
 ;   dot_openassoc   
 ;   
 ; PURPOSE:
 ;   open a DOT image-sequene cubefile file for assoc
 ;   
 ; DESCRIPTION:
 ;   straightforward
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   file = string with path/filename
 ;   lun = the logical unit number to assoc into; must be specified
 ;         1-128 to avoid limitation to only 100-128 of /get_lun
 ;   
 ; OUTPUTS:
 ;   xszize,ysize,zsize = 3 dimensions
 ;   bitpix = word type (8=byte, 16=integer, -32=float)
 ;   headeroffset = size of the header needing to be offset in associng
 ;   swap_endian: need for endian swapping on this machine
 ;
 ; HISTORY:
 ;   Jun 24 2017 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 8) then begin
  print,'dot_openassoc,file,'
  print,'  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian'
  return  
endif

; check file name
if  (strmatch(file,'*-cube-*') eq 0) then begin
  print,' ##### dot_openassoc abort: file '+file+' has no -cube- in name'
  return
end

; get info
  getdotcubegeom,file,xsize,ysize,zsize,datatype
  if (datatype eq 'byte') then bitpix=8
  if (datatype eq 'integer') then bitpix=16
  if (datatype eq 'float') then bitpix=-32
  headeroffset=0

; set swap_endian for this computer  ; DOT files are little
;RR l = little, b = big; fits = big; linux machines are little
if ((byte(1L, 0, 1))[0] eq 1) then endian = 'l' else endian='b'
if (abs(bitpix) gt 8) and (endian eq 'l') then $
  swap_endian=0 else swap_endian=1

; now open assoc
close,lun
openr,lun,file,swap_endian=swap_endian

end



; =============== main for testing per IDLWAVE H-c ======================

path='/home/rutten/data/DOT/2007-04-12-test/cubes/'
file='QuietSun-gb-0000-20070412-cube-1034x776x180-dt30'

lun=1
dot_openassoc,path+file,$
  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

print,lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

end
