FUNCTION Dos_name, name
;+
; NAME:
;       DOS_NAME
; PURPOSE:
;       Extract a valid filename from a MSDOS system filename, e.g. from
;       the FILENAME card from a FITS-header of the AT1-Software.
; CATEGORY:
;       
; CALLING SEQUENCE:
;       RESULT = DOS_NAME ( NAME )
; INPUTS:
;       NAME : String to convert (e.g. C:\FILES\FILE001.EXT)
; OUTPUTS:
;       RESULT : Trailing filename ( FILE001.EXT )
; MODIFICATION HISTORY:
;       10-Okt-1992  P.Suetterlin, KIS
;-

name = strtrim(name)
sl = strlen(name)
uname = ''
FOR i = sl-1, 0, -1 DO BEGIN
    ch = strmid(name, i, 1)
    CASE ch OF
        "'"  :
        '"'  :
        '\'  : GOTO, aus
        ':'  : GOTO, aus
        '/'  : GOTO, aus
        ELSE : uname = ch+uname
    ENDCASE
ENDFOR

Aus:
return, strtrim(uname, 2)
END

