FUNCTION bestarea, pic, alpha, margins=mar
;+
; NAME:
;       BESTAREA
; PURPOSE:
;       Return the optimum (=unaffected) subpart of an image rotated
;       by the ROT routine
; CALLING SEQUENCE:
;       Result = Bestarea( Image, angle [, MARGINS=mar] )
; INPUTS:
;       Image:  2-D array
;       Angle:  rotation angle in degrees
; KEYWORDS:
;       MARGINS: optionally returns the determined margins as a
;                4-element vector
; OUTPUTS:
;       Result: clipped image
; PROCEDURE:
;       compute the area as a funtion of startpoint, find maximum
; MODIFICATION HISTORY:
;       22-Aug-2000  P.Suetterlin, SIU
;-

IF alpha EQ 0 THEN return, pic

s = size(pic)
sx = s(1)
sy = s(2)

alpha = alpha MOD 45

ta = abs(tan(alpha*!dtor))
sx2 = sx/2
sy2 = sy/2

x0 = 0
ar1 = 0
;;ars = ar1

REPEAT BEGIN
    x0 = x0+1
    ar = ar1
    y0a = sy2-x0/ta
    y0b = ta*(sx2-x0)
    y0 = fix(max([y0a, y0b]))
    ar1 = float(sx2-x0)*(sy2-y0)
;;    ars = [ars, ar1]
ENDREP UNTIL ar1 LE ar

x0 = x0-1
y0a = sy2-x0/ta
y0b = ta*(sx2-x0)
y0 = fix(max([y0a, y0b]))
mar = [x0, sx-x0-1, y0, sy-y0-1]

return, pic(x0:sx-x0-1, y0:sy-y0-1)

END
