pro align_ha

d_id = '1246871116'    ;;; DARK
f_id = '1246871071'    ;;; FLAT
r_id = '1246871035'    ;;; Data

p = assoc(1, intarr(1024, 1024), 2880)

openr, 1, 'Al*'+d_id+'*park*'
dr = float(p(0))
FOR i=1, 49 DO dr = dr + p(i)
close, 1
dr = dr/50.
openr, 1, 'Al*'+d_id+'*tin*'
dh = float(p(0))
FOR i=1, 49 DO dh = dh + p(i)
close, 1
dh = dh/50.

openr, 1, 'Al*'+f_id+'*park*'
fr = float(p(0))
FOR i=1, 49 DO fr = fr + p(i)
close, 1
fr = fr/50.
fr = fr - dr
fr = fr/float(avg(fr))
openr, 1, 'Al*'+f_id+'*tin*'
fh = float(p(0))
FOR i=1, 49 DO fh = fh + p(i)
close, 1
fh = fh/50.
fh = fh-dh
fh = fh/float(avg(fh))

rms = fltarr(50)
openr, 1, 'Al*'+r_id+'*park*'
FOR i=0, 49 DO rms(i) = stdev(p(i))
ix = reverse(sort(rms))
pr = (float(p(ix(0)))-dr)/fr
FOR i=1, 9 DO pr = pr+(float(p(ix(i)))-dr)/fr
close, 1

openr, 1, 'Al*'+r_id+'*tin*'
FOR i=0, 49 DO rms(i) = stdev(p(i))
ix = reverse(sort(rms))
ph = (float(p(ix(0)))-dh)/fh
FOR i=1, 9 DO ph = ph+(float(p(ix(i)))-dh)/fh
close, 1

;stop

pr = rotate(pr, 2)
ph = rotate(ph, 2)

!Y.Style = 1

print, 'RC-HA:', (par_rh = rotscalenew(pic1=pr, pic2=ph, /verb, ini=[-0.4, 1.007]))

print, 'shift shc', shc(pr, rot(ph, par_rh(0), par_rh(1), cub=-.5), /filt)

end
