IF NOT keyword_set(verbose) THEN verbose = 0
print, "Verbosity is ", (verbose EQ 0 ? "off":"on")
;; average of so far measured values (Alignments)

par_ca = [ 0.070, 0.9950]
par_bc = [-0.004, 1.0013]
par_rc = [-0.107, 0.9973]
par_ha = [-0.072, 0.9818]
par_rh = [ 0.034, 0.9848]

;; Grid measurement 2007-05-20
;; Ca:     0.0995000     0.996800
;; Bc:    -0.0480000     1.00140
;; Rc:     0.0191000     0.985200
;; Ha:     0.260300      0.980400
;; RC-HA:  0.241100      0.995100
;; shift shc          -3         -10


p = assoc(1, uintarr(1296, 1030), 2880)
r = [5, 2, 5, 2, 2]
tmpdata = fltarr(1280, 1024, 49)
rms = fltarr(49)
data = fltarr(1280, 1024, 10, 5)

 ;;; read & flat G band, get quality

files = findfile('Alig*virgil.out')
openr, 1, files(2)
d = float(ishft(p(16:*, 2:1025, 1), -6))
FOR i=2, 49 DO d = d+float(ishft(p(16:*, 2:1025, i), -6))
d = d/49.
close, 1

openr, 1, files(1)
f = float(ishft(p(16:*, 2:1025, 1), -6))
FOR i=2, 49 DO f = f+float(ishft(p(16:*, 2:1025, i), -6))
f = f/49. - d
close, 1

openr, 1, files(0)
FOR i=1, 49 DO tmpdata(*, *, i-1) = $
  (float(ishft(p(16:*, 2:1025, i), -6))-d)/f
FOR i=0, 48 DO rms(i) = stdev(tmpdata(*, *, i))
ix = (reverse(sort(rms)))(0:9)
FOR i=0, 9 DO data(*, *, i, 1) = rotate(tmpdata(*, *, ix(i)), 2)
close, 1

weiter:

FOR j=0, 4 DO BEGIN
    IF j EQ 1 THEN CONTINUE
    files = findfile('Alig*GRAB'+strtrim(j+1, 2)+'*')
    openr, 1, files(2)
    d = float(ishft(p(16:*, 2:1025, 1), -6))
    FOR i=2, 49 DO d = d+float(ishft(p(16:*, 2:1025, i), -6))
    d = d/49.
    close, 1

    openr, 1, files(1)
    f = float(ishft(p(16:*, 2:1025, 1), -6))
    FOR i=2, 49 DO f = f+float(ishft(p(16:*, 2:1025, i), -6))
    f = f/49. - d
    close, 1
    
    openr, 1, files(0)
    FOR i=0, 9 DO data(*, *, i, j) = $
      rotate((float(ishft(p(16:*, 2:1025, ix(i)), -6))-d)/f, r(j))
    close, 1
ENDFOR

td = reform(total(data, 3))    
redo = 'n'
REPEAT BEGIN
    print, 'Ca: ', (par_ca = rotscalenew(pic1=td(*, *, 1), pic2=td(*, *, 0), $
                                         ini=par_ca, verb=verbose))
    read, 'Redo with this value? (y/Enter)', redo
ENDREP UNTIL redo NE 'y'

REPEAT BEGIN
    print, 'Bc: ', (par_bc = rotscalenew(pic1=td(*, *, 1), pic2=td(*, *, 2), $
                               ini=par_bc, verb=verbose))
    read, 'Redo with this value? (y/Enter)', redo
ENDREP UNTIL redo NE 'y'

REPEAT BEGIN
    print, 'Rc: ', (par_rc = rotscalenew(pic1=td(*, *, 1), pic2=td(*, *, 3), $
                               ini=par_rc, verb=verbose))
    read, 'Redo with this value? (y/Enter)', redo
ENDREP UNTIL redo NE 'y'

REPEAT BEGIN
    print, 'Ha: ', (par_ha = rotscalenew(pic1=td(*, *, 1), pic2=td(*, *, 4), $
                               ini=par_ha, verb=verbose))
    read, 'Redo with this value? (y/Enter)', redo
ENDREP UNTIL redo NE 'y'

REPEAT BEGIN
    print, 'RC-HA:', (par_rh = rotscalenew(pic1=td(*, *, 3), pic2=td(*, *, 4), $
                                           ini=par_rh, verb=verbose))
    read, 'Redo with this value? (y/Enter)', redo
ENDREP UNTIL redo NE 'y'

print, 'shift shc', shc(td(*, *, 3), $
                        rot(td(*, *, 4), par_rh(0), par_rh(1), cub=-.5), /filt)

END
