; file: cubeslicer.pro
; last: Oct 13 2005 
; note: written by Christiaan A. Balke 1992
;       adapted Thijs Krijger (JMK) 2000
;       adapted Rob Rutten (;RR) Oct 2005: yt slice off, fixed pos on screen
; use: cubeslicer,data
;      cubeslicer,data1,data2,data3
; menu: type space in idl window (or use shortcuts); hit cancel
; mouse: xy = cursor position in cube a
;        button 2, 3 =  step time
;        1+2 = 1 step in x left; 1+3 = x right
;        2+3 = swap stepping in x with stepping in y

;kubisme.PRO (RJR: Balke name)
;Program to show slices of a 3-D data array.

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Variations to make :
;			decouple time move from xy move
;			done -> finish FFT option
;			nuts : use crosshairs with sine intensity profile
;			done _> split Init_window in two procedures
;			doing => Make structure and flow diagrams of program
;			Make explanatory list of variables
;			done -> Relocate windows on screen
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	problem: het opvangen van het inlezen van een cube met een
;andere grootte dan de genen die al zijn geladen werkt nog niet lekker.
;Bedachte oplossing: eerst in file de cubesizes lezen, dan controleren of
;sizes overeenkomen met al ingelezen data, zoj a nieuwe data inlezen, zo
;nee dan of een deel van nieuwe dataset inlezen of oude situatie
;herstellen.
;ppp=================================================================| COMMON
; Here are defined the commonblocks which contain those global variables 
; which can better be passed through a common block. Nearly all of these 
; are parameters. things like the cube coordinates are passed as variables. 
; In the block DATACUBES the cubes themselves are reserved, so that when you 
; quit 'cubeshow' all the cubes you loaded are available at the MAIN level.

; LAST 28 FEB 2000 - JMK

common COLORS,r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
common DATACUBES,cube_a,cube_b,cube_c
common MY_COLOR,red,gre,blu,cci,bgc
common CURSORLINES,cuXYx,cuXYy,cuXTx,cuXTt,cuYTy,cuYTt
common CUBESIZE,scube,same_size
common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common DIMENSION,xdim,ydim,tdim
common FLAGS,zoom_flag,hide_flag,delay_flag
common MOVIEDEFAULTS,c_tog,sl_tog,d_tog,sp_tog,sk_tog,ra_tog, $
		     dirfac,speedfac,skipfac,r_hi,r_lo, $
		     c_ac,sl_ac,d_ac,sp_ac,sk_ac,ra_ac
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common STORED_COORDS,cpx_p,cpy_p,xco_p,yco_p,tco_p
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title


;================================================================= FFB

function ffb,ts,fil,han=han,bw=bw,fw=fw,gauss=gauss
; Forward transform, filtering, backward transform.
 
 s = size(ts)
 dim1 = s(1)	; spatial x dimension
 dim2 = s(2)	; time dimension
 
 if keyword_set(han) and keyword_set(fw) then begin
   tmp = hanning(dim1,dim2)*ts
 endif else  tmp = ts
 if n_params() eq 1 then fil = intarr(dim1,dim2)+1
 if keyword_set(gauss) then begin
   gauss_f = gaussfilt(dim1,dim2,sigma=gauss,/corner)
   fil = fil*gauss_f
 endif
 kfw = keyword_set(fw)
 kbw = keyword_set(bw)
 han = keyword_set(han)

 case 1 of
   kfw and not kbw : begin
 		       print,'* Forward transform *'
		 		       fdts = fft(tmp-mean(tmp),-1)
 		       print,'* Filtering *'
         	       ffdts = fdts*fil
		       tsf = ffdts
		     end
   kbw and not kfw : begin
		       fdts = ts
 		       print,'* Filtering *'
         	       ffdts = fdts*fil
		       print,'* Reverse transform *'
 	   	       tsf = float(fft(ffdts,1))
		     end
   kfw and kbw : begin
 		       print,'* Forward transform *'
 		       fdts = fft(tmp-mean(tmp),-1)
 		       print,'* Filtering *'
         	       ffdts = fdts*fil
		       print,'* Reverse transform *'
 	   	       tsf = float(fft(ffdts,1))
		     end
   else : begin
	    print,'You forgot to set at least one '
	    print,'of the keywords "bw" and "fw".'
          end
 endcase
 print,'** Total power original:',total(abs(fdts))
 print,'** Total power filtered image:',total(abs(ffdts))
 print,'* Ready *'
 return,tsf
end


;ppp=================================================================| CTR

function CTR,slice,c=c,t=t,r=r

;combines a congrid, a transform and a reform expression
; slice : a slice from a datacube
; c,t,r : Keywords which if set activate respectively the congrid, the 
;	  transform and the reform.
;	The reform is needed when a subarray is taken from the cube which 
;	extends in in the 3th dimension, e.g. an XT slice or a linearray in the
;	time direction.
;	The tranform is needed when a linearray in the Yor T dimension must be 
;	displayed horizontally.
;	The congrid is needed in the 'enlagement mode'.

 ctr = slice
 if keyword_set(r) then ctr = reform(ctr)
 if keyword_set(t) then ctr = transpose(ctr)
 if keyword_set(c) then begin
   s = size(ctr)
   if s(0) lt 2 then begin
     ctr = [[ctr],[ctr]] 
     ctr = congrid(ctr,c*s(1),1)
   endif else ctr = congrid(ctr,c*s(1),c*s(2))
 endif 
 return,ctr
end

;ppp=================================================================| UPDATE2

pro UPDATE2,windx,cube,movemode,xco_old,yco_old,tco_old,xco,yco,tco
;procedure for plotting cross_hairs.

common CURSORLINES,cuXYx,cuXYy,cuXTx,cuXTt,cuYTy,cuYTt
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ;cuXYx, XY slice, vertical crosshair
 ;cuXYy, XY slice, horizontal crosshair
 ;cuXTx, XT slice, vertical crosshair
 ;cuXTt, XT slice, horizontal crosshair
 ;cuYTy, YT slice, vertical crosshair
 ;cuYTt, YT slice, horizontal crosshair

;print,xco_old,yco_old,tco_old,xco,yco,tco

 wset,windx
 xcow = xco		;These coordinates are in the window system
 ycow = yco
 tcow = tco*enl
 xcow_old = xco_old
 ycow_old = yco_old
 tcow_old = tco_old*enl
 xco = fix(xco/float(enl)+0.5) 		;These coordinates are rescaled 
 yco = fix(yco/float(enl)+0.5)		; to cube indices.
 xco_old = fix(xco_old/float(enl)+0.5)
 yco_old = fix(yco_old/float(enl)+0.5)

 case movemode of
   0: ;no update needed
   1: begin	;T stap
       ;--- tv new image and update crosshairs in xy frame
        tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	
        tv,cuXYx,p5(0)+xcow,p5(1),/dev		
        tv,cuXYy,p5(0),p5(1)+ycow,/dev 		
        tv,cuXTt,p1(0),p1(1)+tcow,/dev 		
        tv,cuYTt,p3(0),p3(1)+tcow,/dev 		
        tv,ctr(cube(*,yco,tco_old),c=enl),p1(0),p1(1)+tcow_old,/dev 	   
        tv,ctr(cube(xco,*,tco_old),c=enl,/t),p3(0),p3(1)+tcow_old,/dev 
      end   
  2: begin	;Y stap 
      ;tv new image and update crosshairs in xt frame
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 			
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 			
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 			
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 			
       tv,ctr(cube(*,yco_old,tco),c=enl),p5(0),p5(1)+ycow_old,/dev
       tv,ctr(cube(xco,yco_old,*),c=enl,/t,/r),p3(0)+ycow_old,p3(1),/dev 
     end
  3: begin	;Y,T stap
      ;tv new images and update crosshairs in xy and xt frame
       tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	 	
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,cuXYx,p5(0)+xcow,p5(1),/dev			
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 			
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 			
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 			
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 			
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 			
       tv,ctr(cube(xco,*,tco_old),c=enl,/t),p3(0),p3(1)+tcow_old,/dev 	
       tv,ctr(cube(xco,yco_old,*),c=enl,/t,/r),p3(0)+ycow_old,p3(1),/dev 
     end
  4: begin	;X stap
      ;tv new image and update crosshairs in yt frame
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 	
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 		
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 		
       tv,cuXYx,p5(0)+xcow,p5(1),/dev		
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 		
       tv,ctr(cube(xco_old,*,tco),c=enl),p5(0)+xcow_old,p5(1),/dev		
       tv,ctr(cube(xco_old,yco,*),c=enl,/t,/r),p1(0)+xcow_old,p1(1),/dev 
     end
  5: begin	;X,T stap
      ;tv new images and update crosshairs in xy and yt frame 
       tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	 	
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev
       tv,cuXYx,p5(0)+xcow,p5(1),/dev		
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 		
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 		
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 		
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 		
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 		
       tv,ctr(cube(*,yco,tco_old),c=enl),p1(0),p1(1)+tcow_old,/dev		
       tv,ctr(cube(xco_old,yco,*),c=enl,/t,/r),p1(0)+xcow_old,p1(1),/dev 
     end
  6: begin	;X,Y stap
      ;tv new image and update crosshairs in xy and xt frame
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 	 	
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 		
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 		
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 	 	
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 		
       tv,cuXYx,p5(0)+xcow,p5(1),/dev		
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 		
       tv,ctr(cube(*,yco_old,tco),c=enl),p5(0),p5(1)+ycow_old,/dev	 
       tv,ctr(cube(xco_old,*,tco),c=enl),p5(0)+xcow_old,p5(1),/dev
     end
  7: begin	;X,Y,T stap
      ;tv new image and update crosshairs in xy,xt and yt frame
       tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	 	
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev
      ;update crosshairs in xy, xt and yt frame.
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 		
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 		
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 		
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 	      	
       tv,cuXYx,p5(0)+xcow,p5(1),/dev		
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 	   	
     end
  8: begin	; complete update stap
      ;tv new image and update crosshairs in xy and xt frame
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 	 	
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	 	
       tv,cuXTx,p1(0)+xcow,p1(1),/dev 					  
       tv,cuYTy,p3(0)+ycow,p3(1),/dev 					  
       tv,cuYTt,p3(0),p3(1)+tcow,/dev 	 			
       tv,cuXTt,p1(0),p1(1)+tcow,/dev 		 		
       tv,cuXYx,p5(0)+xcow,p5(1),/dev		 		
       tv,cuXYy,p5(0),p5(1)+ycow,/dev 		 		
     ; tv,transpose(reform(cube(xco_old,yco,*))),p1(0)+xcow_old,p1(1),/dev 
     ; tv,transpose(reform(cube(xco,yco_old,*))),p3(0)+ycow_old,p3(1),/dev 
     ; tv,transpose(cube(xco,*,tco_old)),p3(0),p3(1)+tcow_old,/dev     	  
     ; tv,cube(*,yco,tco_old),p1(0),p1(1)+tcow_old,/dev 		
     ; tv,cube(xco_old,*,tco),p5(0)+xcow_old,p5(1),/dev		
     ; tv,cube(*,yco_old,tco),p5(0),p5(1)+ycow_old,/dev 		
     end
  9: begin	; hide cursor stap
      ;tv new image and do not update crosshairs 
       tv,ctr(cube(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 	 	
       tv,ctr(cube(*,yco,*),c=enl,/r),p1(0),p1(1),/dev
       tv,ctr(cube(*,*,tco),c=enl),p5(0),p5(1),/dev 	 
     end
 endcase
 b1 = 50
 if xco ne xco_old then begin
   xyouts,p1(0)+b1,p2(1)+15,string(format='(i3)',xco_old+xlo), $
	  /dev,color=0,charsize=1.2
   xyouts,p1(0)+b1,p2(1)+15,string(format='(i3)',xco+xlo), $
	  /dev,color=255,charsize=1.2
 end
 if yco ne yco_old then begin
   xyouts,p1(0)+b1+30,p2(1)+15,string(format='(i3)',yco_old+ylo), $
	  /dev,color=0,charsize=1.2
   xyouts,p1(0)+b1+30,p2(1)+15,string(format='(i3)',yco+ylo), $
	  /dev,color=255,charsize=1.2
 end
 if tco ne tco_old then begin
   xyouts,p1(0)+b1+60,p2(1)+15,string(format='(i3)',tco_old+tlo), $
	  /dev,color=0,charsize=1.2
   xyouts,p1(0)+b1+60,p2(1)+15,string(format='(i3)',tco+tlo), $ 
	  /dev,color=255,charsize=1.2
 end
end

;ppp==========================================================| REGION_ACTION

pro REGION_ACTION,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco,cpx_old,cpy_old, $
                  tco_old,movemode,n_arg	

common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common DIMENSION,xdim,ydim,tdim
common FLAGS,zoom_flag,hide_flag,delay_flag
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 in_XY_slice = cpx ge p5(0) and cpx lt p6(0) and $
	       cpy ge p5(1) and cpy lt p6(1) 
 p = p5(0) 
 q = p5(1) 

 ;--- CHECK IN WHICH REGION THE CURSOR IS ---
 case 1 of
   ;--- WITH ONE CUBE ---
   in_XY_slice and noc eq 1 : begin 	
     update2,win_a,cube_a,movemode,cpx_old-p,cpy_old-q,tco_old, $
      	     cpx-p,cpy-q,tco
     wset,0
     cpx_old = cpx &cpy_old = cpy &tco_old = tco &
   end

   ;--- WITH TWO CUBES AND NO CURSOR DELAY ---
   in_XY_slice and noc eq 2 and not(delay_flag) : begin 	
     update2,win_a,cube_a,movemode,cpx_old-p,cpy_old-q,tco_old,$
     	     cpx-p,cpy-q,tco
     update2,win_b,cube_b,movemode,cpx_old-p,cpy_old-q,tco_old,$
             cpx-p,cpy-q,tco
     wset,0
     cpx_old = cpx &cpy_old = cpy &tco_old = tco 
   end

   ;--- WITH THREE CUBES AND NO CURSOR DELAY ---
   in_XY_slice and noc eq 3 and not(delay_flag) : begin 	
     update2,win_a,cube_a,movemode,cpx_old-p,cpy_old-q,tco_old,$
             cpx-p,cpy-q,tco
     update2,win_b,cube_b,movemode,cpx_old-p,cpy_old-q,tco_old,$
             cpx-p,cpy-q,tco
     update2,win_c,cube_c,movemode,cpx_old-p,cpy_old-q,tco_old,$
             cpx-p,cpy-q,tco
     wset,0
     cpx_old = cpx &cpy_old = cpy &tco_old = tco 
   end

   ;--- WITH TWO CUBES AND CURSOR DELAY ---
   in_XY_slice and noc eq 2 and delay_flag : begin 	
     xe = xdim*enl-2
     ye = ydim*enl-2
     c1 = cpx_old-p5(0)+xad*enl		;These parameters are trans- 
     c2 = cpy_old-p5(1)+yad*enl 	; formed to windowsystem
     c3 = tco_old+tad			; coords.
     c4 = cpx-p5(0)+xad*enl     	 
     c5 = cpy-p5(1)+yad*enl     	 
     c6 = tco+tad
     if c1 lt 0 then c1 = 0 else if c1 gt xe then c1 = xe
     if c2 lt 0 then c2 = 0 else if c2 gt ye then c2 = ye
     if c3 lt 0 then c3 = c3+tdim else c3 = c3 mod tdim
     if c4 lt 0 then c4 = 0 else if c4 gt xe then c4 = xe
     if c5 lt 0 then c5 = 0 else if c5 gt ye then c5 = ye
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     UPDATE2,win_a,cube_a,movemode,c1,c2,c3,c4,c5,c6
     c1 = cpx_old-p5(0)+xbd*enl 
     c2 = cpy_old-p5(1)+ybd*enl
     c3 = tco_old+tbd
     c4 = cpx-p5(0)+xbd*enl     
     c5 = cpy-p5(1)+ybd*enl     
     c6 = tco+tbd
     if c1 lt 0 then c1 = 0 else if c1 gt xe then c1 = xe
     if c2 lt 0 then c2 = 0 else if c2 gt ye then c2 = ye
     if c3 lt 0 then c3 = c3+tdim else c3 = c3 mod tdim
     if c4 lt 0 then c4 = 0 else if c4 gt xe then c4 = xe
     if c5 lt 0 then c5 = 0 else if c5 gt ye then c5 = ye
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     UPDATE2,win_b,cube_b,movemode,c1,c2,c3,c4,c5,c6
     wset,0
     cpx_old = cpx &cpy_old = cpy &tco_old = tco 
   end

   ;--- WITH THREE CUBES AND CURSOR DELAY ---
   in_XY_slice and noc eq 3 and delay_flag : begin 	
     xe = xdim*enl-2
     ye = ydim*enl-2
     c1 = cpx_old-p5(0)+xad*enl	
     c2 = cpy_old-p5(1)+yad*enl 
     c3 = tco_old+tad		
     c4 = cpx-p5(0)+xad*enl     	 
     c5 = cpy-p5(1)+yad*enl     	 
     c6 = tco+tad
     if c1 lt 0 then c1 = 0 else if c1 gt xe then c1 = xe
     if c2 lt 0 then c2 = 0 else if c2 gt ye then c2 = ye
     if c3 lt 0 then c3 = c3+tdim else c3 = c3 mod tdim
     if c4 lt 0 then c4 = 0 else if c4 gt xe then c4 = xe
     if c5 lt 0 then c5 = 0 else if c5 gt ye then c5 = ye
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     UPDATE2,win_a,cube_a,movemode,c1,c2,c3,c4,c5,c6
     c1 = cpx_old-p5(0)+xbd*enl 
     c2 = cpy_old-p5(1)+ybd*enl
     c3 = tco_old+tbd
     c4 = cpx-p5(0)+xbd*enl     
     c5 = cpy-p5(1)+ybd*enl     
     c6 = tco+tbd
     if c1 lt 0 then c1 = 0 else if c1 gt xe then c1 = xe
     if c2 lt 0 then c2 = 0 else if c2 gt ye then c2 = ye
     if c3 lt 0 then c3 = c3+tdim else c3 = c3 mod tdim
     if c4 lt 0 then c4 = 0 else if c4 gt xe then c4 = xe
     if c5 lt 0 then c5 = 0 else if c5 gt ye then c5 = ye
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     UPDATE2,win_b,cube_b,movemode,c1,c2,c3,c4,c5,c6
     c1 = cpx_old-p5(0)+xcd*enl 
     c2 = cpy_old-p5(1)+ycd*enl
     c3 = tco_old+tcd
     c4 = cpx-p5(0)+xcd*enl     
     c5 = cpy-p5(1)+ycd*enl     
     c6 = tco+tcd
     if c1 lt 0 then c1 = 0 else if c1 gt xe then c1 = xe
     if c2 lt 0 then c2 = 0 else if c2 gt ye then c2 = ye
     if c3 lt 0 then c3 = c3+tdim else c3 = c3 mod tdim
     if c4 lt 0 then c4 = 0 else if c4 gt xe then c4 = xe
     if c5 lt 0 then c5 = 0 else if c5 gt ye then c5 = ye
     if c6 lt 0 then c6 = c6+tdim else c6 = c6 mod tdim
     UPDATE2,win_c,cube_c,movemode,c1,c2,c3,c4,c5,c6
     wset,0
     cpx_old = cpx  & cpy_old = cpy  & tco_old = tco 
   end
   else : ;print,'no match in region case'
 endcase      

END 	;REGION_ACTION

;ppp===========================================================| INIT_GENERAL

pro INIT_GENERAL,cube
;Procedure to initialize parameters dimensions,crosshairs,colors.

common MY_COLOR,red,gre,blu,cci,bgc
common colors,r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
common DIMENSION,xdim,ydim,tdim
common CURSORLINES,cuXYx,cuXYy,cuXTx,cuXTt,cuYTy,cuYTt
common FLAGS,zoom_flag,hide_flag,delay_flag
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 hide_flag = 1
 zoom_flag = 0
 delay_flag = 0
 crs_wait_mode = 0	;0=no_wait:2=wait_for_movement:3=wait_for_click
 enl = 1.0		; the enlarge factor for slices
 device,get_screen_size=gss 


 ;--- DETERMINE THE DIMENSIONS OF THE DATACUBES
 cube_dim = size(cube)
 xdim = cube_dim(1)
 ydim = cube_dim(2)
 tdim = cube_dim(3)
;  xstep = 123.0			; pixelsize in km for .... run
;  ystep = 123.0 			; idem
;  tstep = 10.0			; Time between frames in seconds
; replaced by RJR-JMK standards 
 xstep = 1e3     	  	; is divided by 1000.
 ystep = 1e3                 ; is divided by 1000.
 tstep = 1.0*60.			; is divided by 60.

 ;--- SET TITLES FOR AXES ---
;  f_title = 'X (Mm)'
;  s_title = 'Y (Mm)'
;  t_title = 'Time (minutes)'
;  replaced by JMK standard
;RR f_title = 'X (px)'
;RR s_title = 'Y (px)'
;RR t_title = 'time step'
;RR below to gain window space 
f_title = ''
s_title = ''
t_title = ''



 ;--- CURSOR LINES ---
 cci = 249 				;cursor color index, 
 cuXYx = transpose(bytarr(enl*ydim))+cci 	;XY slice, vertical crosshair
 cuXYy = bytarr(enl*xdim)+cci 			;XY slice, horizontal crosshair
 cuXTx = transpose(bytarr(enl*tdim))+cci 	;XT slice, vertical crosshair
 cuXTt = cuXYy					;XT slice, horizontal crosshair
 cuYTy = cuXTx					;YT slice, vertical crosshair
 cuYTt = bytarr(enl*ydim)+cci	 		;YT slice, horizontal crosshair

 ; Close all windows
 ;wdelete,1,2,3,4,5,6,7,8; delete all windows to make next command
 ;			      ; effective
 ; Replaced with by JMK (effect the same, no error) :
 device,window=windows
 open=where(windows eq 1,count)
 for i=0,count-1 do wdelete,open(i)


 ; -- first Save old color table -- JMK
 tvlct,r_orig,g_orig,b_orig,/get
 
 ;--- SET COLOR TABLE ---
 
 device,pseudo_color=8	;define visual type and depth
			;pseudocolor, writable, undecomposed, 8 bitplanes
 bgc = 80
 red = indgen(256)  	;standard black/white color table
 gre = red	 
 blu = red	 
 gre(0) = bgc 		;background color
 blu(0) = bgc/2		
 red(249) = 255		;color of axis/cursor
 gre(249) = 255 
 blu(249) = 0		
 tvlct,red,gre,blu

END; INIT_DCC

;ppp============================================================| INIT_WINDOW

pro INIT_WINDOW,cube,windx,wtitle,cname, $
		xco_old,yco_old,tco_old,xco,yco,tco
;Procedure to initialize parameters of axis,plots,tv positions,etc..

common MY_COLOR,red,gre,blu,cci,bgc
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common DIMENSION,xdim,ydim,tdim
common CURSORLINES,cuXYx,cuXYy,cuXTx,cuXTt,cuYTy,cuYTt
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ;--- DETERMINE THE DIMENSIONS OF THE DATACUBES
 cube_dim = size(cube)
 xdim = cube_dim(1)
 ydim = cube_dim(2)
 tdim = cube_dim(3)

 ;--- CURSOR LINES ---
 cuXYx = transpose(bytarr(enl*ydim))+cci 	;XY slice, vertical crosshair
 cuXYy = bytarr(enl*xdim)+cci 			;XY slice, horizontal crosshair
 cuXTx = transpose(bytarr(enl*tdim))+cci 	;XT slice, vertical crosshair
 cuXTt = cuXYy					;XT slice, horizontal crosshair
 cuYTy = cuXTx					;YT slice, vertical crosshair
 cuYTt = bytarr(enl*ydim)+cci 			;YT slice, horizontal crosshair

 ;--- SET SOME FIXED PLOT POSITION CONSTANTS.
 legendspacex = 120
 legendspacey = 100
;RR bor = 10 &  bf = [2,6,8] & bor = bf*bor
;RR borderframe trial-error hack:
 bor = 10 &  bf = [3,3,5] & bor = bf*bor  
 
 ;--- CALCULATE WINDOWSIZE
;RR Wx = ( bor(0)+2*bor(1)+enl*(xdim+ydim) ) > $
;RR				( bor(0)/2+bor(1)+enl*xdim+legendspacex )
  Wx = ( bor(0)+2*bor(1)+enl*(xdim+0) ) > $
				( bor(0)/2+bor(1)+enl*xdim+legendspacex )
;RR window xlength reset below
Wx= wx-legendspacex-10
 Wy = ( 2*bor(1)+bor(2)+enl*(ydim+tdim) ) > $
				( bor(1)+bor(2)+enl*ydim+legendspacey )
;RR window ylength reset below
Wy= wy-25
 w_title = 'Window '+strtrim(string(windx))+'  ;  '+wtitle
 window,windx,title=wtitle,xsize=Wx,ysize=Wy,retain=2, $
;RR	xpos=gss(0)-(Wx+10)*(windx+1),ypos=gss(1)-Wy-50
	xpos=gss(0)/(0.9*noc)*windx,ypos=50 

;RR above: windows on screen whatever the size
;RR   noc = number of cubes
;RR   gss get-screen-size 
	

 ;--- CALCULATE PLOTPOSITION PARAMETERS IN DEVICE COORD. 
 p1 = [bor(1),bor(1)]
 p2 = p1+enl*[xdim,tdim] 
 p3 = [bor(0)+bor(1)+enl*xdim,bor(1)]
 p4 = p3+enl*[ydim,tdim]
 p5 = [bor(1),bor(1)+bor(2)+enl*tdim]
 p6 = p5+enl*[xdim,ydim]
 p7 = [p3(0),p5(1)+10*enl] 
 p8 = p7+enl*[85,25]

 ;--- PLOT AXIS (SET BUNGLE OF KEYWORDS)

 !p.multi = [0,2,2]
 !x.minor = 5
 !y.minor = 5
 !p.charsize = 1.1
 tickpower = 1.15

 ;---- XT slice -----
 !x.ticklen = -9.0/tdim^tickpower		
 !y.ticklen = -9.0/xdim^tickpower	
 !x.title = f_title & !y.title = t_title &!color = 255
 plot,[0,0],[xdim*xstep,tdim*tstep],/dev,pos=[p1-[1,1],p2],xsty=4,ysty=4
 axis,/dev,xaxis=0,xsty=1,xrange=[0,xdim*xstep/1000.]
 axis,/dev,yaxis=0,ysty=1,yrange=[0,tdim*tstep/60.]

;RR ;---- YT slice -----
;RR !x.ticklen = -9.0/tdim^tickpower
;RR !y.ticklen = -9.0/ydim^tickpower
;RR !x.title = s_title & !y.title = t_title & !color = 255
;RR plot,[0,0],[ydim*ystep,tdim*tstep],/dev,pos=[p3-[1,1],p4],xsty=4,ysty=4
;RR axis,/dev,xaxis=0,xsty=1,xrange=[0,ydim*ystep/1000.]
;RR axis,/dev,yaxis=1,ysty=1,yrange=[0,tdim*tstep/60.]

 ;---- XY slice -----
 !x.ticklen = -9.0/ydim^tickpower    
 !y.ticklen = -9.0/xdim^tickpower
 !x.title = f_title & !y.title = s_title & !color = 255
 plot,[0,0],[xdim*xstep,ydim*ystep],/dev,pos=[p5-[1,1],p6],xsty=4,ysty=4
 axis,/dev,xaxis=0,xsty=1,xrange=[0,xdim*xstep/1000.]
 axis,/dev,yaxis=0,ysty=1,yrange=[0,ydim*ystep/1000.]

 ;--- OPTIONS 'BUTTON' ---
;RR  xyouts,p7(0)+5*enl,p7(1)+5,'Hit space',/dev,color=249,charsize=1.5
;RR  xyouts,p7(0)+5*enl,p7(1)-15,'for options',/dev,color=249,charsize=1.5
;RR  xyouts,p1(0)-15,p2(1)+15,' X Y T : ',/dev,color=255,charsize=1.3

 ;--- DRAW LEGENDA. ---
 case wtitle of 
;    'Cube A ' : xyouts,10,p6(1)+30,cname_a,/dev,color=249,charsize=1.5
;    'Cube B ' : xyouts,10,p6(1)+30,cname_b,/dev,color=249,charsize=1.5
;    'Cube C ' : xyouts,10,p6(1)+30,cname_c,/dev,color=249,charsize=1.5
   'Cube A ' : xyouts,p7(0),p8(1)+5*enl,cname_a,/dev,color=249,charsize=1.5
   'Cube B ' : xyouts,p7(0),p8(1)+5*enl,cname_b,/dev,color=249,charsize=1.5
   'Cube C ' : xyouts,p7(0),p8(1)+5*enl,cname_c,/dev,color=249,charsize=1.5
   else : ;do nothing
 endcase

 ;---TV CUBESLICES ---
 tv,ctr(cube(*,0,*),c=enl,/r),p1(0),p1(1)
 tv,ctr(cube(0,*,*),c=enl,/r),p3(0),p3(1)
 tv,ctr(cube(*,*,0),c=enl),p5(0),p5(1)

 ;--- DRAW INITIAL CROSSHAIRS AND SET CURSOR ---
 curpatt = [0,0,256,256,256,0,0,14392,0,0,256,256,256,0,0,0]
 device,cursor_image=curpatt,cursor_xy=[7,7]
 update2,windx,cube,7,xco_old,yco_old,tco_old,xco,yco,tco

end ;INIT_WINDOW

;ppp===================================================================| BLINK

pro BLINK,a,b,rate,pos1,pos2

common SETTINGS,crs_wait_mode,enl

 repeat begin 
   k = get_kbrd(0)
   tv,ctr(a,c=enl,/r),pos1,pos2
   wait,rate
   tv,ctr(b,c=enl,/r),pos1,pos2
   wait,rate 
 endrep until k eq 'q'
end

;ppp============================================================| BLINK_SLICES

pro BLINK_SLICES,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco, $
	    	 n_arg

common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ;--- BLINK ---
 choise = intarr(3)
 if noc ge 2 then begin
   choise(0) = wmenu(['Which cubes ?','A versus B','A versus C', $
                      'B versus C', 'Exit'],title=0,init=1)
   if (choise(0) ne 4) or $
      (choise(0) eq 2 and noc eq 3) or $
      (choise(0) eq 3 and noc eq 3) then begin
     choise(1) = wmenu(['Which slice ?',' XY slice',' XT slice', $
                        ' YT slice'],title=0,init=1)
     choise(2) = wmenu(['Blink rate (in second/frames)',' 0',' 0.1',' 0.3', $
                        ' 0.5',' 1',' 2','user defined'],title=0,init=3)
     case choise(2) of
       1 : rate = 0
       2 : rate = 0.1
       3 : rate = 0.3
       4 : rate = 0.5
       5 : rate = 1
       6 : rate = 2
       7 : read,'Give blink rate :',rate
       else : ;do nothing
     endcase
     ;--- STORE SLICES IN WINDOW 0 ---		
     case 1 of 
       win_a eq 0 : begin
     		      xytmp = cube_a(*,*,tco+tad) 
		      xttmp = cube_a(*,yco+yad,*)
		      yttmp = cube_a(xco+xad,*,*)
		    end
       win_b eq 0 : begin
     		      xytmp = cube_b(*,*,tco+tad) 
		      xttmp = cube_b(*,yco+yad,*)
		      yttmp = cube_b(xco+xad,*,*)
		    end
       win_c eq 0 : begin
     		      xytmp = cube_c(*,*,tco+tad) 
		      xttmp = cube_c(*,yco+yad,*)
		      yttmp = cube_c(xco+xad,*,*)
		    end
       else : ;do nothing
     endcase
     case 1 of
       (choise(0) eq 1 and choise(1) eq 1) : $
          blink,cube_a(*,*,tco+tad),cube_b(*,*,tco+tbd),rate,p5(0),p5(1)
       (choise(0) eq 1 and choise(1) eq 2) : $
          blink,cube_a(*,yco+yad,*),cube_b(*,yco+ybd,*),rate,p1(0),p1(1)
       (choise(0) eq 1 and choise(1) eq 3) : $
          blink,cube_a(xco+xad,*,*),cube_b(xco+xbd,*,*),rate,p3(0),p3(1)
       (choise(0) eq 2 and choise(1) eq 1) : $
          blink,cube_a(*,*,tco+tad),cube_c(*,*,tco+tcd),rate,p5(0),p5(1)
       (choise(0) eq 2 and choise(1) eq 2) : $
          blink,cube_a(*,yco+yad,*),cube_c(*,yco+ycd,*),rate,p1(0),p1(1)
       (choise(0) eq 2 and choise(1) eq 3) : $
          blink,cube_a(xco+xad,*,*),cube_c(xco+xcd,*,*),rate,p3(0),p3(1)
       (choise(0) eq 3 and choise(1) eq 1) : $
          blink,cube_b(*,*,tco+tbd),cube_c(*,*,tco+tcd),rate,p5(0),p5(1)
       (choise(0) eq 3 and choise(1) eq 2) : $
          blink,cube_b(*,yco+ybd,*),cube_c(*,yco+ycd,*),rate,p1(0),p1(1)
       (choise(0) eq 3 and choise(1) eq 3) : $
          blink,cube_b(xco+xbd,*,*),cube_c(xco+xcd,*,*),rate,p3(0),p3(1)
       else : ;Do nothing
     endcase
   endif else print,'Cube C does not exist' 

   ;--- RESTORE ORIGINAL SITUATION ---	
   case 1 of
     choise(0) eq 1 : tv,ctr(xytmp,c=enl),p5(0),p5(1)
     choise(0) eq 2 : tv,ctr(xttmp,c=enl),p1(0),p1(1)
     choise(0) eq 3 : tv,ctr(yttmp,c=enl),p3(0),p3(1)
     else : ;Exit
   endcase
 endif else print,' !!! No blinking possible with one cube !!! '

END	;BLINK_SLICE

;ppp============================================================| DELAY_SLICES

pro DELAY_SLICES,cpx,cpy,n_arg	

common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common FLAGS,zoom_flag,hide_flag,delay_flag
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ;--- DELAY ---
 choise = intarr(3)

 if noc ge 2 then begin
   delay_flag = 1
   choise(0) = wmenu(['Selext cube for delay ?','A','B','C', $
	              'Set al delays to zero','Exit this option'], $
 	              title=0,init=1)
   if choise(0) ne 5 then begin
     repeat begin
       choise(1) = wmenu(['Choose the dimension','X space','Y space', $
  	                  'Time','Cancel'],title=0,init=1)  
       if choise(1) ne 4 then $
         print,'>> Give offset in physical units (Km or seconds) :
       case 1 of
         (choise(0) eq 1 and choise(1) eq 1) : begin 
						 read,xad & xad = xad/xstep	
					       end	
         (choise(0) eq 1 and choise(1) eq 2) : begin 
						 read,yad & yad = yad/ystep	
					       end	
         (choise(0) eq 1 and choise(1) eq 3) : begin 
						 read,tad & tad = tad/tstep	
					       end	
         (choise(0) eq 2 and choise(1) eq 1) : begin 
						 read,xbd & xbd = xbd/xstep	
					       end	
         (choise(0) eq 2 and choise(1) eq 2) : begin 
						 read,ybd & ybd = ybd/ystep	
					        end	
         (choise(0) eq 2 and choise(1) eq 3) : begin 
						 read,tbd & tbd = tbd/tstep	
					       end	
         (choise(0) eq 3 and choise(1) eq 1) : begin 
						 read,xcd & xcd = xcd/xstep	
					       end	
         (choise(0) eq 3 and choise(1) eq 2) : begin 
						 read,ycd & ycd = ycd/ystep	
					       end	
         (choise(0) eq 3 and choise(1) eq 3) : begin 
						 read,tcd & tcd = tcd/tstep	
					        end	
          choise(0) eq 4 : begin
		             xad = 0 &yad = 0 &tad = 0
			     xbd = 0 &ybd = 0 &tbd = 0
			     xcd = 0 &ycd = 0 &tcd = 0 & delay_flag = 0
			   end
	  else : ;do nothing
       endcase
     endrep until choise(1) eq 4
   endif 
   ;--- SET THE UNDEFINED VARIABLES TO ZERO ---
   s = size(xad) & if s(n_elements(s)-2) eq 0 then xad = 0
   s = size(yad) & if s(n_elements(s)-2) eq 0 then yad = 0
   s = size(tad) & if s(n_elements(s)-2) eq 0 then tad = 0
   s = size(xbd) & if s(n_elements(s)-2) eq 0 then xbd = 0
   s = size(ybd) & if s(n_elements(s)-2) eq 0 then ybd = 0
   s = size(tbd) & if s(n_elements(s)-2) eq 0 then tbd = 0
   s = size(xcd) & if s(n_elements(s)-2) eq 0 then xcd = 0
   s = size(ycd) & if s(n_elements(s)-2) eq 0 then ycd = 0
   s = size(tcd) & if s(n_elements(s)-2) eq 0 then tcd = 0
 endif else print,' !!! Not possible with only one cube!!! '

END;DELAY_SLICES

;ppp======================================================| SPEED_AND_DISTANCE

pro SPEED_AND_DISTANCE,cpx,cpy,n_arg

;--- calculate speeds or periods in timeslices or distances in space slices 
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 choise = intarr(3)
 no_cube = 0

 repeat begin
   ;-- HANDLE MENU ---
   ms1 = 'Speed in timeslice'
   ms2 = 'Time interval in timeslice'
   ms3 = 'Distance in space slice'
   ms4 = 'Cancel           '
   choise(0) = wmenu(['Calculate',ms1,ms2,ms3,ms4],title=0,init=1)
   if choise(0) ne 4 then begin
     ms0 = 'Take measurements in'
     ms1 = '    Cube A          '
     ms2 = '    Cube B          '
     ms3 = '    Cube C          ' 
     choise(1) = wmenu([ms0,ms1,ms2,ms3,ms4],title=0,init=1)
     str1 = '* This cube is not loaded !'
     case choise(1) of
       1: wset,win_a
       2: begin 
	    if noc ge 2 then begin wset,win_b 
	    endif else begin print,str1 & no_cube = 1 & endelse
	  end
       3: begin 
	    if noc ge 3 then begin wset,win_c 
	    endif else begin print,str1  & no_cube = 1 & endelse
	  end
       else : ;do nothing
     endcase

    if not no_cube then begin
     case choise(0) of
       ;--- IF CURSOR IS IN XT OR YT SLICE THEN CALCULATE SPEED ---
       1: begin		
 	    tvcrs,p1(0)+1,p1(1)+1
            cursor,cpx,cpy,/dev,/nowait
            if ((cpx ge p1(0)) and (cpx lt p2(0)) and $
	        (cpy ge p1(1)) and (cpy lt p2(1))) or $
      	       ((cpx ge p3(0)) and (cpx lt p4(0)) and $
                (cpy ge p3(1)) and (cpy lt p4(1))) then begin
              print,'>> Click for first point.'
              cursor,s1,t1,/dev,/down
              print,'>> I got the first point, now click on the second.'
              cursor,s2,t2,/dev,/down
              if t2-t1 ne 0 then begin
                print,'* The speed between these points is :', $
  	              abs(xstep*(s2-s1)/(tstep*(t2-t1))),' Km/s'
	      endif else begin
	        ss1 = '* You silly! Unless you were pointing at a tachion'
                ss2 = '* you did something very unphysical. Nothing can move'
                ss3 = '* with infinite speed'
	        print,ss1 & print,ss2 & print,ss3
              endelse
            endif else print,'>> Place cursor in timeslices please.'
          end
       ;--- IF CURSOR IS IN XT OR YT SLICE THEN CALCULATE TIME
       2: begin		
 	    tvcrs,p1(0)+1,p1(1)+1
            cursor,cpx,cpy,/dev,/nowait
            if ((cpx ge p1(0)) and (cpx lt p2(0)) and $
	        (cpy ge p1(1)) and (cpy lt p2(1))) or $
      	       ((cpx ge p3(0)) and (cpx lt p4(0)) and $
                (cpy ge p3(1)) and (cpy lt p4(1))) then begin
              print,'* Click for first point.'
              cursor,s1,t1,/dev,/down
              print,'* I got the first point, now click on the second.'
              cursor,s2,t2,/dev,/down
              print,'* The time interval between these points is :', $
 	             abs(tstep*(t2-t1)/enl),' seconds'
            endif else print,'>> Place cursor in a timeslice please.'
          end
       ;--- IF CURSOR IS IN XY SLICE THEN CALCULATE DISTANCE 
       3: begin		
	    tvcrs,p5(0)+1,p5(1)+1
            cursor,cpx,cpy,/dev,/nowait
            if (cpx ge p5(0) and cpx lt p6(0) and $
                cpy ge p5(1) and cpy lt p6(1)) then begin
              print,'>>  Click for first point.'
              cursor,x1,y1,/dev,/down
              print,'>>  I got the first point, now click on the second.'
              cursor,x2,y2,/dev,/down
              print,'*  The distance between these points is :', $
              sqrt((xstep*(x2-x1))^2+(ystep*(y2-y1))^2)/enl,' Km'
           endif else print,'>> Place cursor in the spaceslice please.'
         end
       else : ;do nothing
     endcase
    endif
   endif
 endrep until choise(0) eq 4

END 	;SPEED_AND_DISTANCE

;ppp===================================================================| ZOOM
 
pro ZOOM,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco,n_arg	
	 
common FLAGS,zoom_flag,hide_flag,delay_flag
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $ 
	          first_start,f_title,s_title,t_title

 ;--- SET SOME LAYOUT CONSTANTS ---
 siz = 25*enl	& sh = fix(siz/2)	& sq = fix(siz/4)
 m1 = 15	& m2 = 20	
 m3 = 30	& m4 = 70 	& r = 10
 ww = [win_a,win_b,win_c]
 abc = ['A','B','C'] 

 tvcrs,p5(0),p5(1),/dev		; set cursor in xy slice to enable hide crosshair
 zoom_flag = zoom_flag xor 1

 if zoom_flag eq 1 then begin

   ;--- HIDE CROSSHAIRS AND CURSOR ---
   cpx_old = cpx 	& cpy_old = cpy 	& tco_old = tco 
   REGION_ACTION,cube_a,cube_b,cube_c,p5(0),p5(1),xco,yco,tco, $
                 cpx_old,cpy_old,tco_old,9,n_arg	
   print,'* Click, in window 0, on the position you want to zoom.' 
   cursor,cpx,cpy,/dev,/down
   if (cpx lt 0 or cpy lt 0) then $	;if cursor not in slice window
     tvcrs,p5(0),p5(1),/dev		; set it in xy slice,

   ;--- GET ZOOM FACTOR ---
   fac = wmenu([' Give zoom factor',' 1.5',' 2',' 2.5',' 3',' 3.5', $
	      ' user defined',' Cancel'],title=0,init=1)
   if fac ne 7 then begin
     if fac eq 6 then read,'>> Give zoom factor : ',fac
     fac = 0.5*fac+1

     ;--- MAKE ZOOM WINDOW ---
     wx = m4+3*(fac*siz+r)+r
     wy = m4+noc*(fac*siz+r)+r
     u = fac*siz+r
     window,4,xpos=10,ypos=gss(1)-wy-30,xsize=wx,ysize=wy,retain=2, $ 
	  title='Zoom,    factor = '+strtrim(string(fac),2)
     xyouts,m1,wy-m3,'Slice',/dev,color=249,charsize=1.5
     xyouts,m4+0.45*u,wy-m3,'XY',/dev,color=249,charsize=1.5
     xyouts,m4+1.45*u,wy-m3,'XT',/dev,color=249,charsize=1.5
     xyouts,m4+2.45*u,wy-m3,'YT',/dev,color=249,charsize=1.5
     xyouts,m1,wy-2.5*m3,'Cube',/dev,color=249,charsize=1.5

     ;--- READ AND TV IMAGES ---
     for i=0,noc-1 do begin
        xyouts,m2,wy-(m4+(i+0.5)*u+r),abc(i),/dev,color=249,charsize=1.5
        wset,ww(i) 	& z = tvrd(cpx-sh,cpy-sh,siz,siz) 
        wset,4 	  	& tv,ctr(z,c=fac),m4+0*u+r,wy-(m4+(i+1)*u)

        wset,ww(i)	& z = tvrd(cpx-sh,p1(1)+tco-sh,siz,siz) 
        wset,4 	  	& tv,ctr(z,c=fac),m4+1*u+r,wy-(m4+(i+1)*u)

        wset,ww(i) 	& z = tvrd(p3(0)+yco-sh,p3(1)+tco-sh,siz,siz) 
        wset,4 	  	& tv,ctr(z,c=fac),m4+2*u+r,wy-(m4+(i+1)*u)
     endfor
   endif else  zoom_flag = zoom_flag xor 1 
 endif else wdelete,4

END	;ZOOM

;ppp=============================================================| MOVIE_INIT

pro MOVIE_INIT

common DIMENSION,xdim,ydim,tdim
common MOVIEDEFAULTS,c_tog,sl_tog,d_tog,sp_tog,sk_tog,ra_tog, $
		     dirfac,speedfac,skipfac,r_hi,r_lo, $
		     c_ac,sl_ac,d_ac,sp_ac,sk_ac,ra_ac

 c_tog  = [' >','  ','  '] 	& c_ac = 0
 sl_tog = [' >','  ','  '] 	& sl_ac = 0
 D_tog  = [' >','  ']		& d_ac = 0	
 sp_tog = [' >','  ','  ','  ']	& sp_ac = 0	
 sk_tog = [' >','  ','  ','  ']	& sk_ac = 0	
 ra_tog = [' >','  ','  ']	& ra_ac = 0	
 dirfac = 1
 speedfac = 0
 skipfac = 1
 r_hi = tdim-1 & r_lo = 0
end

;ppp============================================================| M_SET_TOGGLE

pro M_SET_TOGGLE,tog_ac,tog_str,val,noc

 case 1 of
   n_params() eq 4 : begin 
		       if val gt noc-1 then begin
   		         print,'This cube does not exist'
 		       endif else begin
   		         if tog_ac ne val then begin			
     			   tog_str(tog_ac) = '  ' 
			   tog_str(val) = ' >' 
			   tog_ac = val
   			 endif
 		       endelse
                     end
   n_params() le 3 : if tog_ac ne val then begin
                         tog_str(tog_ac) = '  '
                         tog_str(val) = ' >'
                         tog_ac = val
                       endif
   else : ;do nothing
 endcase
 return
end  

;ppp=============================================================| M_NEW_COORD

pro M_NEW_COORD,co,dirfac,d_ac,skipfac,r_hi,r_lo
          
 co = co+dirfac*skipfac
 if co gt r_hi then begin
   if d_ac eq 1 then begin
     dirfac = -dirfac	 & co = r_hi 
   endif else co = r_lo 
 endif
 if co lt r_lo then begin
   if d_ac eq 1 then begin
     dirfac = -dirfac	 & co = r_lo 
   endif else co = r_hi
 endif
 return 
end

;ppp==============================================================| UPDATE_MOV

pro UPDATE_MOV,cube_a,cube_b,cube_c,c_ac,sl_ac,xco,yco,tco

common SETTINGS,crs_wait_mode,enl
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8

 case c_ac of
   0 : case sl_ac of						;cube_a
	 0 : tv,ctr(cube_a(*,*,tco),c=enl),p5(0),p5(1),/dev  	;XY
	 1 : tv,ctr(cube_a(*,yco,*),c=enl,/r),p1(0),p1(1),/dev  ;XT
	 2 : tv,ctr(cube_a(xco,*,*),c=enl,/r),p3(0),p3(1),/dev  ;YT
   	 else : ;do nothing
       endcase
   1 : case sl_ac of						;cube_b
	 0 : tv,ctr(cube_b(*,*,tco),c=enl),p5(0),p5(1),/dev 
	 1 : tv,ctr(cube_b(*,yco,*),c=enl,/r),p1(0),p1(1),/dev 
	 2 : tv,ctr(cube_b(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 
   	 else : ;do nothing
       endcase
   2 : case sl_ac of						;cube_c
	 0 : tv,ctr(cube_c(*,*,tco),c=enl),p5(0),p5(1),/dev 
	 1 : tv,ctr(cube_c(*,yco,*),c=enl,/r),p1(0),p1(1),/dev 
	 2 : tv,ctr(cube_c(xco,*,*),c=enl,/r),p3(0),p3(1),/dev 
         else : ;do nothing
      endcase
   else : ;do nothing
 endcase
end

;ppp===================================================================| MOVIE

pro MOVIE,cube_a,cube_b,cube_c,xco,yco,tco

common MOVIEDEFAULTS,c_tog,sl_tog,d_tog,sp_tog,sk_tog,ra_tog, $
		     dirfac,speedfac,skipfac,r_hi,r_lo, $
		     c_ac,sl_ac,d_ac,sp_ac,sk_ac,ra_ac
common DIMENSION,xdim,ydim,tdim
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c, $
	 	  noc,first_start,f_title,s_title,t_title

 ww = [win_a,win_b,win_c]
 choise = intarr(3)
 oke = 0 
 cancel1 = 0
	 
 ;--- STRING DEFINITIONS FOR MENU'S ---
 dash = '- - - - - - - - - - - -'
 sep = '/\/\/\/\/\/\/\/\/\/\/\/'
 ud = ' user defined'
 pr = ' previous'

 ;--- OPTIONS MENU ---
 dirs = [' forward',' forward/backward'] 	
 speeds = [' full',' N frames/sec',ud]	
 skips = [' no skip',' N frames',ud]		
 ranges = [' full',ud]			
 optionsmenustr = ['DIRECTION',dash,d_tog+dirs,sep, $
		   'SPEED',dash,sp_tog+speeds,sep, $
		   'SKIP',dash,sk_tog+skips,sep, $
		   'RANGE',dash,ra_tog+ranges,sep,'DONE']

 ;--- MAIN MENU ---
 cubes = [' A',' B',' C']	
 slices = [' XY',' XT',' YT']	

 repeat begin
   choise(0) = wmenu([' WHICH CUBE',dash,c_tog+cubes,sep, $
	     	      ' WHICH SLICE',dash,sl_tog+slices,sep, $ 
		      ' OPTIONS',SEP,' OK, GO',sep,' CANCEL'],title=0,init=15)

 case choise(0) of
   0 or 1 or 5 or 6 or 7 or 11 or 13 or 15 : no_action = 1
   2 : m_set_toggle,c_ac,c_tog,0,noc			;activate A
   3 : m_set_toggle,c_ac,c_tog,1,noc			;activate B
   4 : m_set_toggle,c_ac,c_tog,2,noc			;activate C
   8 : begin
	 m_set_toggle,sl_ac,sl_tog,0			;activate XY
	 if r_hi gt tdim-1 then r_hi = tdim-1
       end
   9 : begin
	 m_set_toggle,sl_ac,sl_tog,1			;activate XT
	 if r_hi gt ydim-1 then r_hi = ydim-1
       end
  10 : begin
	 m_set_toggle,sl_ac,sl_tog,2			;activate YT
	 if r_hi gt xdim-1 then r_hi = xdim-1
       end
  12 : begin
	 cancel2 = 0
	 repeat begin
	   optionsmenustr = ['DIRECTION',dash,d_tog+dirs,sep, $
		  	     'SPEED',dash,sp_tog+speeds,sep, $
		  	     'SKIP',dash,sk_tog+skips,sep, $
		 	     'RANGE',dash,ra_tog+ranges,sep,'DONE']
	   choise(1) = wmenu(optionsmenustr,title=0,init=11)
	   case choise(1) of
	     0 or 1 or 4 or 5 or 6 or 10 or 11 or $
	    12 or 16 or 17 or 18 or 21: no_action = 1
	     2 : m_set_toggle,d_ac,d_tog,0
 	     3 : m_set_toggle,d_ac,d_tog,1
	     7 : begin	& m_set_toggle,sp_ac,sp_tog,0
		   	  speedfac = 0			& end
	     8 : begin
		   m_set_toggle,sp_ac,sp_tog,1
		   choise(2) = wmenu(['N FRAMES/SEC','32','16','8', $
				      '4','2','1'],title=0,init=1)
		   speedfac = float(2^(6-choise(2))) 		
		 end
	     9 : begin
		   m_set_toggle,sp_ac,sp_tog,2
		   read,'>> Give number of frames/sec : ',ch
		   speedfac = float(ch) 		
                 end
	    13 : begin
		   m_set_toggle,sk_ac,sk_tog,0
		   skipfac = 1
                 end
	    14 : begin
		   m_set_toggle,sk_ac,sk_tog,1
		   choise(2) = wmenu(['SKIP N FRAMES','2','3','4', $
				      '5','10','20'],title=0,init=1)
		   if choise(2) eq 5 then begin skipfac = 10
		   endif else if choise(2) eq 6 then begin skipfac = 20
		              endif else skipfac = 1+choise(2) 		
                 end
	    15 : begin
		   m_set_toggle,sk_ac,sk_tog,2
		   read,'>> Give number of frames to skip : ',ch
		   skipfac = fix(ch) 		
                 end
	    19 : begin
		   m_set_toggle,ra_ac,ra_tog,0
		   r_lo = 0
		   case sl_ac of
		     0 : r_hi = tdim-1 
		     1 : r_hi = ydim-1
		     2 : r_hi = xdim-1
		     else : ;do nothing
		   endcase
                 end
	    20 : begin
		   m_set_toggle,ra_ac,ra_tog,1
		   sr1 = 'Maximum range for '
		   sr3 = 'T : '	& sx = strtrim(string(xdim-1),2)	
		   sr4 = 'Y : '	& sy = strtrim(string(ydim-1),2)	
		   sr5 = 'X : '	& st = strtrim(string(tdim-1),2)	
		   case sl_ac of
       		     0 : print,'** Current slice : '+sr3
       		     1 : print,'** Current slice : '+sr3
       		     2 : print,'** Current slice : '+sr5
		     else : ;do nothing
	           endcase
	   	   print,sr1+sr3+' [0:'+st+']'
	   	   print,sr1+sr4+' [0:'+sy+']'
	   	   print,sr1+sr5+' [0:'+sx+']'
		   read,'>> Give upper range limit: ',r_hi
		   read,'>> Give lower range limit: ',r_lo
                 end
	    22 : cancel2 = 1
	    else : ;do nothing
	   endcase
	 endrep until cancel2
       end ; option menu
  14 : oke = 1
  16 : cancel1 = 1
   else : ;do nothing
 endcase 
endrep until oke or cancel1

 case sl_ac of
   0 : if r_hi gt tdim-1 then r_hi = tdim-1 
   1 : if r_hi gt ydim-1 then r_hi = ydim-1
   2 : if r_hi gt xdim-1 then r_hi = xdim-1
   else : ;do nothing
 endcase
 if r_lo gt r_hi then r_lo = rhi-10
 if r_lo lt 0 then r_lo = 0
 if skipfac lt 2 then skipfac = 2
 if speedfac lt 0 then speedfac =0 

 ;--- DISPLAY MOVIE ---
 if not cancel1 then begin
   wset,ww(c_ac)	;activate right window
   repeat begin

     ;--- CALCULATE NEW COORDINATES ---
     case sl_ac of
       0 : begin
             m_new_coord,tco,dirfac,d_ac,skipfac,r_hi,r_lo
           end
       1 : begin
             m_new_coord,yco,dirfac,d_ac,skipfac,r_hi,r_lo
           end
       2 : begin
             m_new_coord,xco,dirfac,d_ac,skipfac,r_hi,r_lo
           end
       else : ;do nothing
     endcase
     mkey = get_kbrd(0)

     ;--- TV NEW SLICE ---
     update_mov,cube_a,cube_b,cube_c,c_ac,sl_ac,xco,yco,tco
     if not speedfac eq 0 then 	wait,2/speedfac

   endrep until strupcase(mkey) eq 'Q'
 endif

END 	;MOVIE

;ppp=================================================================| COLOR

pro COLOR

common COLORS,r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
common MY_COLOR,red,gre,blu,cci,bgc

 choise = intarr(3)
 choise(0) = wmenu([' COLOR TABLES ',' Standard (grey)',' FFT (16 level', $
		    ' Predefined tables',' Cancel'],title=0,init=1)

 if choise(0) ne 4 then begin
   case choise(0) of 
     1 : begin
	   loadct,0
 	   red = r_curr & gre = g_curr	& blu = b_curr
         end
     2 : begin
	   loadct,12
 	   red = r_curr & gre = g_curr	& blu = b_curr
         end
     3 : begin
	   Xloadct
 	   red = r_curr & gre = g_curr	& blu = b_curr
         end
     else : ;do nothing
   endcase
   s=size(r_curr)
   gre(0) = bgc 	& blu(0) = bgc		;background color
   red(s(1)-1) = 255	& gre(s(1)-1) = 255 
   blu(s(1)-1) = 0				;color of axis/cursor
   tvlct,red,gre,blu 	  	    
 endif
END ; Color

;ppp==========================================================| FFT_SLICES

pro FFT_SLICES,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco

;to calculate and display FFT of current slices.
;NB : 'efac' is a local enlment ment factor, not to be confused with 'enl'

common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common DIMENSION,xdim,ydim,tdim
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
		  first_start,f_title,s_title,t_title
 efac = 2

 ;--- SET SOME FIXED PLOT POSITION CONSTANTS.
 legendspacex = 120
 legendspacey = 20
 bor = 10 &  bf = [2,6,8] & bor = bf*bor
 legend = 'XYT = '+strtrim(string(xco),2)+', '+ $
	   strtrim(string(yco),2)+', '+strtrim(string(tco),2)
 
 ;--- DO MENU'S ---
 cubes = ['   A','   B','   C']	
 slices = ['   XY','   XT','   YT']	
 choise = intarr(3)
 choise(0) = wmenu([' WHICH CUBE',cubes,' Cancel'],title=0,init=2)
 
 if choise(0) ne 4 then begin
   choise(1) = wmenu([' WHICH SLICE',slices,' Cancel'],title=0,init=2) 
   case choise(0) of
     1 : begin
 	   wtitle = 'Cube A'
           case choise(1) of
 	     1 : fs = ffb(cube_a(*,*,tco+tad),/fw,/han)
             2 : fs = ffb(reform(cube_a(*,yco+yad,*)),/fw,/han)
             3 : fs = ffb(reform(cube_a(xco+xad,*,*)),/fw,/han)
	     else : ;do nothing
           endcase
         end
     2 : begin
           if noc ge 2 then begin
 	     wtitle = 'Cube B'
             case choise(1) of
  	       1 : fs = ffb(cube_b(*,*,tco+tbd),/fw,/han)
               2 : fs = ffb(reform(cube_b(*,yco+ybd,*)),/fw,/han)
               3 : fs = ffb(reform(cube_b(xco+xbd,*,*)),/fw,/han)
	       else : ;do nothing
             endcase
           endif else print,'!! Cube not loaded.'
         end
     3 : begin
	   if noc eq 3 then begin
 	     wtitle = 'Cube C'
             case choise(1) of
	       1 : fs = ffb(cube_c(*,*,tco+tcd),/fw,/han)
               2 : fs = reform(ffb(cube_c(*,yco+ycd,*)),/fw,/han)
               3 : fs = reform(ffb(cube_c(xco+xcd,*,*)),/fw,/han)
	       else : ;do nothing
             endcase
           endif else print,'!! Cube not loaded.'
        end
     else : ;do nothing
   endcase

   if choise(1) ne 4 then begin

     ;--- RESTRUCTURE FS ---
     fs = reform(fs)
     s = size(fs) & dim1 = s(1) & dim2 = s(2)
     fs = congrid(fs,efac*dim1,efac*dim2,/interp)
     s = size(fs) & dim1 = s(1) & dim2 = s(2)
     fs = alog10(abs(fs)+1)
     fs = shift(fs,dim1/2,dim2/2)

     ;--- CALCULATE WINDOWSIZE ---
     Wx = ( bor(0)+dim1 ) > ( bor(0)+dim1+legendspacex )
     Wy = ( 2*bor(1)+dim2 ) > ( 2*bor(1)+dim2+legendspacey )
     window,5,title=wtitle,xsize=wx,ysize=wy,retain=2
     pp1 = p1+[10,10]		;pp1 and pp2 have same funtion as p1 and p2
     pp2 = pp1+[dim1,dim2]
     !x.ticklen = -5.0/dim2 
     !y.ticklen = -5.0/dim1
 
     ;--- AXIS RANGE ---
     kx_max = efac*1000*!pi/(xstep)
     ky_max = efac*1000*!pi/(ystep)
     om_max = efac*!pi/(tstep)

     ;--- INITIALIZE PLOTREGIONS, AXIS, TITLES, ETC... ---
     case choise(1) of 
       1 : begin  ;XY slice
     	     !x.title = 'k!Dx!N (Mm!U-1!N)' & !y.title = 'k!Dy!N (Mm!U-1!N)' 
     	     plot,[0,0],[dim1/xstep,dim2/ystep],/dev,pos=[pp1,pp2], $
	          xsty=4,ysty=4
     	     axis,/dev,xaxis=0,xsty=1,xrange=[-kx_max,kx_max]
    	     axis,/dev,yaxis=0,ysty=1,yrange=[-ky_max,ky_max]
	     xyouts,pp1(0)/2,pp2(1)+40,'XY slice',/dev,charsize=1.5
	     xyouts,pp1(0),pp2(1)+20,legend,/dev,charsize=1.2
           end
       2 : begin  ;XT slice
     	     !x.title = 'k!Dx!N (Mm!U-1!N)' & !y.title = '!4x!3 (Hz)' 
     	     plot,[0,0],efac*[dim1/xstep,dim2/ystep],/dev,pos=[pp1,pp2], $
	          xsty=4,ysty=4
     	     axis,/dev,xaxis=0,xsty=1,xrange=[-kx_max,kx_max]
    	     axis,/dev,yaxis=0,ysty=1,yrange=[-om_max,om_max]
	     xyouts,pp1(0)/2,pp2(1)+40,'XT slice',/dev,charsize=1.5
	     xyouts,pp1(0),pp2(1)+20,legend,/dev,charsize=1.2
           end
       3 : begin  ;YT slice
     	     !x.title = 'k!Dx!N (Mm!U-1!N)' & !y.title = '!4x!3 (Hz)' 
     	     plot,[0,0],efac*[dim1/xstep,dim2/ystep],/dev,pos=[pp1,pp2], $
	          xsty=4,ysty=4
     	     axis,/dev,xaxis=0,xsty=1,xrange=[-kx_max,kx_max]
    	     axis,/dev,yaxis=0,ysty=1,yrange=[-om_max,om_max]
	     xyouts,pp1(0)/2,pp2(1)+40,'YT slice',/dev,charsize=1.5
	     xyouts,pp1(0),pp2(1)+20,legend,/dev,charsize=1.2
           end
       else : ; do nothing
     endcase

     ;--- TV FOURIERTRANSFORM ---
     tvscl,fs,pp1(0)+1,pp1(1)+1
   endif ; choise(1)
   COLOR
 endif ; choise(0)
END 	;FOURIER.

;ppp=============================================================| TRIM
 
pro TRIM,kubus

;--- HANDLE TRIM MENU ---
 su = ' User defined      '
 ch2 = wmenu(['Grey scale trimming needed',' 0.9',' 1.0',' 1.1',' 1.2',su, $
	      ' None'],title=0,init=2)
; if datatype eq 'word' then  kubus = intarr(xhi-xlo+1,yhi-ylo+1,thi-tlo+1)

 su = 'Give trim factor ( Advice : 0.5 - 1.5 ) :'
 if ch2 ne 6 then begin
   case ch2 of 
     1 : trimfac = 0.9
     2 : trimfac = 1.0
     3 : trimfac = 1.1
     4 : trimfac = 1.2
     5 : read,su,trimfac
     else : ; do nothing
   endcase
   print,'Trimming space slices'
   for i=0,fix(thi-tlo) do begin
	kubus(*,*,i) = trim(kubus(*,*,i),0.01,.99,trimfac,247)+1
   endfor			      ;avoid bckgnd color  ^   ^ 
 endif

end;TRIM

;ppp=============================================================| LOAD_DACUBE

pro LOAD_DACUBE,fname,kubus,datatype,cubename

common CUBESIZE,scube,same_size
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ;--- DEFINE STANDARD RANGE FOR CUBE COORDS ---
 sxlo = 0 & sxhi = 31 
 sylo = 0 & syhi = 31 
 stlo = 0 & sthi = 31
 
 header=''
; openr,lin,fname,/get_lun
; r = assoc(lin,bytarr(242,210))
; aa = bytarr(242,210)

 ;--- HANDLE COORDINATE MENU ---
 ms0 = 'Give coordinates of subcube to load'
 ms1 = 'Standard values'
 ms2 = 'User defined values'
 ms3 = 'Previous values'
 ms4 = 'Cancel'
 if (first_start eq 'true') then initval = 1 else initval = 3
 ch1 = wmenu([ms0,ms1,ms2,ms3,ms4],title=0,init=initval)

 case ch1 of 
   1 : begin xlo = sxlo &xhi = sxhi &ylo = sylo 
	     yhi = syhi &tlo = stlo &thi = sthi 
       end
   2 : begin
         read,'x low  = ',xlo
         read,'x high = ',xhi
         read,'y low  = ',ylo
         read,'y high = ',yhi
         read,'t low  = ',tlo
         read,'t high = ',thi
       end
   3 : if first_start eq 'true' then begin
         xlo = sxlo &xhi = sxhi &ylo = sylo &yhi = syhi 
	 tlo = stlo &thi = sthi 
	 print,'The standard values are used'
       endif
   4 : begin return & end
   else: ;do nothing
 endcase
 
 print,'* Loading : '+fname
 bfr,kubus,fname,header,/header_only
 s = header.sa
 if (noc ge 1) and ( (s(0) ne 3) or $
    (total(s(1:3)/float(scube(1:3)))/3. ne 1)) then begin 
   print,'>>> Cubes have different sizes. This sucks... <<<'
   same_size = 0	;cubes are not comparable 
 endif else begin
   bfr,kubus,fname,header,tlo,thi
   cubename = fname 
   while strpos(cubename,'/') ne -1 do $
     cubename = strmid(cubename,strpos(cubename,'/')+1,strlen(cubename)-1)
 endelse
 
 if s(1) eq 121 and s(2) eq 105 then begin
   kubus = kubus(xlo:xhi,ylo:yhi,*) 
   print,'* Expanding...'
   kubus = compressxy(kubus,0.5)
   kubus = bytscl(kubus,top=248)
 end
; print,'DONE !!','\007'

return
END	;LOAD_DACUBE
 
	; kubus=byte(kubus)
	; for i=tlo,thi do begin 
	;    aa(*,*) = r(i) 
	;    kubus(*,*,i-tlo) = aa(xlo:xhi,ylo:yhi) 
	; end
	; free_lun,lin

;ppp============================================================| MENU_LOADING
 
pro MENU_LOADING,cube_a,cube_b,cube_c,xco_old,yco_old,tco_old,xco,yco,tco

common CUBESIZE,scube,same_size
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 ms0 = 'See more cubes'
 ms1 = 'Load another cube'
 ms2 = 'Replace cube A'
 ms3 = 'Replace cube B'
 ms4 = 'Replace cube C'
 ms5 = 'CANCEL'
 repwarn = '*** Cube cannot be replaced because it doesn''t exist'
 existent = 1		;means that fname is a not empty string. 
 same_size = 1		;means that cubes are of equal dimensions and sizes.
 tel = noc 
 ch3 = 0
 
 repeat begin
   if first_start eq 'false' then begin
     ch3 = wmenu([ms0,ms1,ms2,ms3,ms4,ms5],title=0,init=1)
     case ch3 of
       1 : if noc eq 3 then begin
	     print,'Woops, didn''t I tell you that '+ $
	 	   '3 cubes is the maximum in this version ?'
	     existent = 0
           end
       2 : ; no copying of variables is needed
       3 : begin
 	     if noc lt 2 then begin 
	       print,repwarn & existent = 0  
	     endif
           end
       4 : begin
 	     if noc lt 3 then begin 
	       print,repwarn & existent = 0
	     endif
	   end
       5 : return
     endcase
   endif

;--- DISPLAY FILESELECTOR ---
   if existent then begin
;     fname = pickfile(title = 'Select A Dataset', $
;				     filter = ['*.c3d*','*.3d*'])
     noexit = fname ne ''	;'' means 'cancel' is selected => noexit=0
     exit   = fname eq ''	; and exit=1
   endif else begin		;if existent is false, exit and noexit
     noexit = 0			; are set as if cancel was selected,
     exit   = 1			; to prevent problems.
   endelse

   if noexit and existent then begin
     case ch3 of 
       1 : begin
             if noc eq 1 then begin
               load_dacube,fname,cube_b,same_size,cname_b	             
             endif
             if noc eq 2 then begin
               load_dacube,fname,cube_c,same_size,cname_c
	       
             endif
           end
       2 : load_dacube,fname,cube_a,same_size,cname_a
       3 : load_dacube,fname,cube_b,same_size,cname_b
       4 : load_dacube,fname,cube_c,same_size,cname_c
    else : begin
             if noc eq 0 then begin
               load_dacube,fname,cube_a,same_size,cname_a
	       scube = size(cube_a)
             endif
             if noc eq 1 then begin
               load_dacube,fname,cube_b,same_size,cname_b            
             endif
             if noc eq 2 then begin
               load_dacube,fname,cube_c,same_size,cname_c
             endif
           end
     endcase
   endif

   if first_start eq 'true' and noexit and same_size then noc = noc+1

   if first_start eq 'false' and noexit and same_size then begin
     case ch3 of 
       1 : begin 
	     if noc eq 1 then init_window,cube_b,win_b,'Cube B ',cname_b, $
		                          xco_old,yco_old,tco_old,xco,yco,tco
             if noc eq 2 then init_window,cube_c,win_c,'Cube C ',cname_c, $
			                  xco_old,yco_old,tco_old,xco,yco,tco
             noc = noc+1
           end
       2 : init_window,cube_a,win_a,'Cube A ',cname_a, $
			                xco_old,yco_old,tco_old,xco,yco,tco
       3 : if noc eq 2 then init_window,cube_b,win_b,'Cube B ',cname_b, $
		 	                xco_old,yco_old,tco_old,xco,yco,tco
       4 : if noc eq 3 then init_window,cube_c,win_c,'Cube C ',cname_c, $
		 	                xco_old,yco_old,tco_old,xco,yco,tco
       else : ;do nothing
     endcase
   endif
 
   tel = tel+1
   ;--- REPEAT LOOP 3 TIMES OR UNTIL Exit IS CHOSEN ---
 endrep until exit or tel ge 3   
 first_start = 'false'

END 	;MENU_LOADING
;   choise = wmenu([sm0,sm1,sm2,sm3,sm4,sm5,sm6,sm7,sm8, $
; 	           sm9,sm10,sm11,sm12,sm13,sm14,sm15,sm16, $
;		   sm17,sm18,sm19,sm20,sm21,sm22,ms5], $
;		   title=0,init=4)

;ppp========================================================| READ_TITLES

pro READ_STEPS

common STEPSIZES,xstep,ystep,tstep

 print,format='("Step first dimension  {",e10.4,"} ",$)',xstep
 read,xstep
 print,format='("Step second dimension {",e10.4,"} ",$)',ystep
 read,ystep
 print,format='("Step third dimension  {",e10.4,"} ",$)',tstep
 read,tstep
end

;ppp========================================================| READ_TITLES

pro READ_TITLES,f_title,s_title,t_title

 cc=''
 print,format='("Title first dimension  {",A10,"} ",$)',f_title
 read,cc
 if cc ne '' then f_title = cc
 print,format='("Title second dimension {",A10,"} ",$)',s_title
 read,cc
 if cc ne '' then s_title = cc
 print,format='("Title third dimension  {",A10,"} ",$)',t_title
 read,cc
 if cc ne '' then t_title = cc
end

;ppp========================================================| CHANGE_SETTINGS

pro CHANGE_SETTINGS,cube_a,cube_b,cube_c,xco_old,yco_old,tco_old,xco,yco,tco, $
		    cpx_old,cpy_old,cpx,cpy

common CURSORLINES,cuXYx,cuXYy,cuXTx,cuXTt,cuYTy,cuYTt
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common STEPSIZES,xstep,ystep,tstep
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 choise=intarr(3)
 dash = '- - - - - - - - - - -'
 sep = '/\/\/\/\/\/\/\/\/\/\/'
 curstatus = [' Cursor wait status',dash,' No Wait',' Wait for movement', $
	      ' Wait for click']
 enlarstr = [' Enlarge factor','1.0','1.1','1.25','1.5','2.0','2.5','3.0']
 choise(0) = wmenu(['Settings',curstatus,sep,enlarstr,sep, $
		    'Physical stepsizes','Axis titles',sep,' Cancel'], $
		    title=0,init=6)

 if choise(0) ne 19 then begin
   case choise(0) of 
     1 or 2 or 6 or 7: ;do nothing
     3 : crs_wait_mode = 0	;the '/nowait' mode
     4 : crs_wait_mode = 2	;the '/change' mode
     5 : crs_wait_mode = 3	;the '/down' mode
     8 : enl = 1.0
     9 : enl = 1.1
     10 : enl = 1.25
     11 : enl = 1.5
     12 : enl = 2.0
     13 : enl = 2.5
     14 : enl = 3.0
     16 : read_steps
     17 : read_titles,f_title,s_title,t_title
      else : ;do nothing
   endcase
print,f_title

   ;--- REINITIALIZE WINDOWS ---
   c = choise(0)
   case 1 of
     c eq 8 or c eq 9 or c eq 10 or c eq 11 or c eq 12 or $
     c eq 13 or c eq 14 : begin
	case noc of
	  1 : begin 
		win_a = 0 
		init_window,cube_a,win_a,'Cube A ',cname_a, $
			    xco_old,yco_old,tco_old,xco*enl,yco*enl,tco
                REGION_ACTION,cube_a,cube_b,cube_c,p5(0)+xco*enl,p5(1)+yco*enl,$
			      xco,yco,tco,cpx_old,cpy_old,tco_old,7,n_arg	
	      end
	  2 : begin 
	   	win_a = 0 
		init_window,cube_a,win_a,'Cube A ',cname_b , $
		     	    xco_old,yco_old,tco_old,xco,yco,tco
		win_b = 1  
	        init_window,cube_b,win_b,'Cube B ',cname_c, $
		            xco_old,yco_old,tco_old,xco,yco,tco
                REGION_ACTION,cube_a,cube_b,cube_c,p5(0)+xco*enl,p5(1)+yco*enl,$
			      xco,yco,tco,cpx_old,cpy_old,tco_old,7,n_arg	
	      end
	  3 : begin
	   	win_a = 0 
	        init_window,cube_a,win_a,'Cube A ',cname_a, $
			    xco_old,yco_old,tco_old,xco,yco,tco
		win_b = 1 
		init_window,cube_b,win_b,'Cube B ',cname_b, $
		            xco_old,yco_old,tco_old,xco,yco,tco
		win_c = 2 
		init_window,cube_c,win_c,'Cube C ',cname_c, $
			    xco_old,yco_old,tco_old,xco,yco,tco
                REGION_ACTION,cube_a,cube_b,cube_c,p5(0)+xco*enl,p5(1)+yco*enl,$
			      xco,yco,tco,cpx_old,cpy_old,tco_old,7,n_arg	
	      end
	 else : print,' Sorry, to many arguments in call'
       endcase
     end    ;(of c eq ..)
     else : ;do nothing
   endcase  ;(1 of ..)
   cpx = p5(0)+xco*enl
   cpy = p5(1)+yco*enl
 endif
END	;CHANGE_SETTINGS

;ppp============================================================| MAIN_OPTIONS

pro MAIN_OPTIONS,mainkey,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco, $
                 cpx_old,cpy_old,xco_old,yco_old,tco_old, $
		 movemode,n_arg,tfac  

common colors,r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
common MY_COLOR,red,gre,blu,cci,bgc
common FLAGS,zoom_flag,hide_flag,delay_flag
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common DIMENSION,xdim,ydim,tdim
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common STORED_COORDS,cpx_p,cpy_p,xco_p,yco_p,tco_p
common MOVIEDEFAULTS,c_tog,sl_tog,d_tog,sp_tog,sk_tog,ra_tog, $
		     dirfac,speedfac,skipfac,r_hi,r_lo, $
		     c_ac,sl_ac,d_ac,sp_ac,sk_ac,ra_ac
common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 cursor,cpx_tmp,cpy_tmp,/dev,/nowait
 current_window = !D.window

 choise = [1,1,1] & ch = ''
 menustr=['Options menu',' Change settings (S)',' Color palette (c)', $
	  ' Hide cursor (h)',' Hide cursor and crosshairs (H)',	      $ 
	  ' Load data (l)',' Store cursor position (p)', $
	  ' Restore cursor position (P)',' Toggle timestep 1 <-> 10 (t)', $
	  ' Blink slices (b)',' FFT slices (f)',' Movie (m)', $
	  ' Offset slices (o)',' Measurements (s)',' Zoom area (z)', $
	  ' Cancel',' Quit cubeshow (q)']

 if mainkey eq ' ' then begin
   choise = wmenu(menustr,title=0,init=7)
   letter = ['S','c','h','H','l','p','P','t','b','f','m','o','s','z','k','q']
   mainkey = letter(choise-1)		        
 endif

 ;--- HANDLE DIFFEREND OPTIONS ---
 case  mainkey of
   '' : ;do nothing
   'b': BLINK_SLICES,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco,n_arg
   'c': COLOR
   'f': FFT_slices,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco
   'h': begin         ;--- HIDE CURSOR ---
          tvcrs,1-hide_flag,hide=hide_flag
          hide_flag = 1 xor hide_flag
        end
   'H': begin 	;--- HIDE CROSSHAIRS AND CURSOR ---
          cpx_old = cpx &cpy_old = cpy &tco_old = tco 
          REGION_ACTION,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco, $
                        cpx_old,cpy_old,tco_old,9,n_arg	
	  tvcrs,1-hide_flag,hide=hide_flag
          hide_flag = 1 xor hide_flag
	end
   'l': begin		;--- LOAD NEW DATA ---
	  cursor,cpx,cpy,/dev,/nowait
	  MENU_LOADING,cube_a,cube_b,cube_c,xco_old,yco_old,tco_old, $
		       xco,yco,tco
	  wset,0
	  tvcrs,cpx,cpy,/dev
          REGION_ACTION,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco, $
                        cpx_old,cpy_old,tco_old,8,n_arg	
        end
   'm': begin		;--- MOVIE IN TIME DIMENSION ---
	  MOVIE,cube_a,cube_b,cube_c,xco,yco,tco
	end
   'o': DELAY_SLICES,cpx,cpy,n_arg	
   'p': begin		;--- PUT CURRENT COORDINATES IN STORE ---
 	  wset,current_window	; set cursor in window to get a proper
	  tvcrs,cpx_tmp,cpy_tmp ; readout after selection from Menu
          cursor,cpx_p,cpy_p,/dev,/nowait
          xco_p = fix((cpx_p+p5(0))/float(enl)+0.5)  
          yco_p = fix((cpy_p+p5(0))/float(enl)+0.5)  
	  tco_p = tco 
	end
   'P': begin		;--- SET CURSOR AT STORED COORDINATES ---
          cpx_old = cpx  & cpy_old = cpy  & tco_old = tco 
          REGION_ACTION,cube_a,cube_b,cube_c,cpx_p,cpy_p,xco_p,yco_p,tco_p, $
                       cpx_old,cpy_old,tco_old,8,n_arg	
	  cpx_tmp = cpx_p
	  cpy_tmp = cpy_p
	  cpx = cpx_p
	  cpy = cpy_p
	  xco = xco_p
	  yco = yco_p
        end   
   's': SPEED_AND_DISTANCE,cpx,cpy,n_arg
   't': begin  	;--- TOGGLE TIME_MOVER BETWEEN 1 AND 10 ---
          tfac = 11 xor tfac	
	end
   'z': ZOOM,cube_a,cube_b,cube_c,cpx_tmp,cpy_tmp,xco,yco,tco,n_arg	
   'S': begin		;--- CHANGE CURSOR READOUT AND ENLARGEMENT ---
	  CHANGE_SETTINGS,cube_a,cube_b,cube_c,xco_old,yco_old,tco_old, $
		      	  xco,yco,tco,cpx_old,cpy_old,cpx,cpy
	  cpx_tmp = cpx
	  cpy_tmp = cpy
	end
   'k': ;do nothing
   'q': begin
	  read,'!! ARE YOU SURE YOU WANNA QUIT ? (y/n) ',ch
	  if strupcase(ch) eq 'N' then mainkey = ' '
  	end 
   else : print,'No Action connected with this key'
 endcase
 wset,current_window
 tvcrs,cpx_tmp,cpy_tmp
 return
END	;MAIN_OPTIONS

;ppp==============================================================| CUBESLICER

pro CUBESLICER,cube_a,cube_b,cube_c,run_show=run_show

common colors,r_orig,g_orig,b_orig,r_curr,g_curr,b_curr 
common CUBESIZE,scube,same_size
common DELAY_COORD,xad,yad,tad,xbd,ybd,tbd,xcd,ycd,tcd
common DIMENSION,xdim,ydim,tdim
common FLAGS,zoom_flag,hide_flag,delay_flag
common MOVIEDEFAULTS,c_tog,sl_tog,d_tog,sp_tog,sk_tog,ra_tog, $
		     dirfac,speedfac,skipfac,r_hi,r_lo, $
		     c_ac,sl_ac,d_ac,sp_ac,sk_ac,ra_ac
common POSITION,p1,p2,p3,p4,p5,p6,p7,p8
common SETTINGS,crs_wait_mode,enl
common STEPSIZES,xstep,ystep,tstep
common SUBCUBE,xlo,xhi,ylo,yhi,tlo,thi
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

 same_size = 1	;flag for control of cubes are of same dimensions.

   ; JMK - must define xsteps, ysteps for movement cursors
   xmod=1.
   ymod=0.


 ;--- SOME INITS WHEN CUBESLICER IS RUN INDEPENDENT FROM CUBESHOW ---
  print,'  C.A. Balke cubeslicer: q=quit, space=options'
 if not keyword_set(run_show) then begin
   cname_a = ''
   cname_b = ''
   cname_c = ''
   first_start = 'false'
   noc = n_params()
   if noc ge 1 then begin 
     scube = size(cube_a) 
     xlo = 0 & xhi = scube(1)-1  
     ylo = 0 & yhi = scube(2)-1
     tlo = 0 & thi = scube(3)-1
   endif else print,' *** There isn''t much to slice with no cubes.'
   if noc ge 1 then begin
     win_a = 0
   endif
   if noc ge 2 then begin
;RR     read,'Descriptor cube A : ',cname_a
     sb = size(cube_b)
     if (sb(0) ne 3) or (total(sb(1:3)/float(scube(1:3)))/3. ne 1) then begin 
       print,'>>> Cubes have different sizes. This sucks... <<<'
       same_size = 0	;cubes are not comparable 
     endif else begin
;RR       read,'Descriptor cube B : ',cname_b           
       win_b = 1
     endelse
   endif 
   if noc ge 3 then begin
     sc = size(cube_c)
     if sc(0) ne 3 or total(sc(1:3)/float(scube(1:3)))/3. ne 1 then begin 
       print,'>>> Cubes have different sizes. This sucks... <<<'
       same_size = 0	;cubes are not comparable 
     endif else begin
;RR       read,'Descriptor cube C : ',cname_c           
       win_c = 2
     endelse
   endif  
   if noc le 1 then begin
     cube_b = bytarr(1,1,1)    & cname_b = 'empty' & win_b = 1
     cube_c = bytarr(1,1,1)    & cname_c = 'empty' & win_c = 2
   endif $
   else begin
     if noc le 2 then begin
       cube_c = bytarr(1,1,1)    & cname_c = 'empty' & win_c = 2
     endif
   endelse
 endif;run_show

if same_size then begin
 ch = ''	
 p_reserve = !p
 x_reserve = !x
 y_reserve = !y
 z_reserve = !z
 INIT_GENERAL,cube_a		
 MOVIE_INIT		; initialize settings for the movie option	  
 ;- on_error,2		; on error go up one level

 ;--- SET INITIAL CUBE COORDINATES ---
 xco_old = 0        	 & yco_old = 0      	   & tco_old = tdim/2
 xco = xdim/2            & yco = ydim/2            & tco = tdim/2


 ;--- INITIALIZE NECESSARY WINDOWS ---
 n_arg = n_params()
 case n_arg of
   1 : begin
         win_a = 0 
	 init_window,cube_a,win_a,'Cube A ',cname_a, $
		     xco_old,yco_old,tco_old,xco,yco,tco
       end
   2 : begin 
         win_a = 0 
	 init_window,cube_a,win_a,'Cube A ',cname_b , $
		     xco_old,yco_old,tco_old,xco,yco,tco
         win_b = 1 
	 init_window,cube_b,win_b,'Cube B ',cname_c, $
	             xco_old,yco_old,tco_old,xco,yco,tco
       end
   3 : begin
         win_a = 0 
	 init_window,cube_a,win_a,'Cube A ',cname_a, $
		     xco_old,yco_old,tco_old,xco,yco,tco
         win_b = 1 
	 init_window,cube_b,win_b,'Cube B ',cname_b, $
		     xco_old,yco_old,tco_old,xco,yco,tco
         win_c = 2 
 	 init_window,cube_c,win_c,'Cube C ',cname_c, $
		     xco_old,yco_old,tco_old,xco,yco,tco
       end
   else : print,' Sorry, to many arguments in call'
 endcase
 wset,0
 tvcrs,0,hide=1 & tvcrs,p5(0)+xco,p5(1)+yco,hide=1


 ;--- SET INITIAL COORDINATES ---
 cpx_old = xco_old+p5(0) & cpy_old = yco_old+p5(1)
 cpx_p = xco		 & cpy_p = yco		& tco_p = tco
 tfac = 1
 xad = 0 &yad = 0 &tad = 0 &xbd = 0 &ybd = 0 
 tbd = 0 &xcd = 0 &ycd = 0 &tcd = 0

; - - - - - - - - - - - - - - START MAIN LOOP ! - - - - - - - - - - - - - - 
 repeat begin
  
   ;--- GET CURSOR COORDINATES ---
   if hide_flag ne 0  then cursor,cpx,cpy,/dev,crs_wait_mode
   ;--- READ KEYBOARD AND HANDLE DIFFEREND OPTIONS ---
   mainkey = get_kbrd(0)
   assigned_keys = mainkey eq ' ' or mainkey eq 'b' or $
		   mainkey eq 'c' or mainkey eq 'f' or $
		   mainkey eq 'h' or mainkey eq 'H' or $ 
		   mainkey eq 'l' or mainkey eq 'm' or $
		   mainkey eq 'p' or mainkey eq 'P' or $
   		   mainkey eq 's' or mainkey eq 'S' or $
		   mainkey eq 't' or mainkey eq 'z'
   case 1 of
     assigned_keys : MAIN_OPTIONS,mainkey,cube_a,cube_b,cube_c, $
				  cpx,cpy,xco,yco,tco,cpx_old,cpy_old, $
				  xco_old,yco_old,tco_old, $
		 		  movemode,n_arg,tfac  
     mainkey eq 'q': begin
	    	       read,'!! ARE YOU SURE YOU WANNA QUIT ? (y/n) ',ch
	               if strupcase(ch) eq 'N' then mainkey = ' '
  	  	     end 
     else : ;do nothing		 print,'* This key has no function' 
   endcase

   ;--- TOGGLE TIME_MOVER BETWEEN 1 AND 10 AND CHECK FOR INDEX OVERFLOW ---
   ;-if !err eq 2 then tfac = 11 xor tfac
   
   
   case 1 of
      ; Note JMK
	; ! err is outdate, better use !button.mouse
	; L betton = 1 (not 0!!)
     ;(!err eq 0) : tco = tco_old		      ;left mouse button
     (!err eq 1) : tco = tco_old		      ;left mouse button JMK
     (!err eq 2) : tco = tco_old-tfac		;middle mouse button
     (!err eq 4) : tco = tco_old+tfac		;right mouse button
     ; JMK addition left+middle is step left, left+right is step right.
     ; by moving cursor 
     ; Note keyboard+mouse combo not possible..
     (!err eq 3) : tvcrs,round(cpx-xmod),round(cpy-ymod)
                   	  	    	  	;left+middle mouse button
     (!err eq 5) : tvcrs,round(cpx+xmod),round(cpy+ymod)
        	   	  	    	  	;left+right mouse button
     
     (!err eq 6) : begin
	  th_txt='mstep x:'+string(format='(i3)',xmod)+ $
	   ' y:'+string(format='(i3)',ymod)
        xyouts,p7(0)+5*enl,p7(1)+25,th_txt,/dev,color=0,charsize=1

            xmod_tmp=xmod     
		xmod=ymod
		ymod=xmod_tmp
	  th_txt='mstep x:'+string(format='(i3)',xmod)+ $
	   ' y:'+string(format='(i3)',ymod)
        xyouts,p7(0)+5*enl,p7(1)+25,th_txt,/dev,color=249,charsize=1

                   end
     else : ;No Match in tco case
   endcase
   if tco lt 0 then tco = tco+tdim else tco = tco mod tdim

   ;--- CONSTRUCT MOVEMODE ---
   case 1 of   
     ((cpx eq cpx_old) and (cpy eq cpy_old) $
                       and (tco eq tco_old)) : movemode = 0
     ((cpx eq cpx_old) and (cpy eq cpy_old) $
		       and (tco ne tco_old)) : movemode = 1
     ((cpx eq cpx_old) and (cpy ne cpy_old) $
		       and (tco eq tco_old)) : movemode = 2
     ((cpx eq cpx_old) and (cpy ne cpy_old) $
		       and (tco ne tco_old)) : movemode = 3
     ((cpx ne cpx_old) and (cpy eq cpy_old) $
		       and (tco eq tco_old)) : movemode = 4
     ((cpx ne cpx_old) and (cpy eq cpy_old) $
		       and (tco ne tco_old)) : movemode = 5
     ((cpx ne cpx_old) and (cpy ne cpy_old) $
		       and (tco eq tco_old)) : movemode = 6
     ((cpx ne cpx_old) and (cpy ne cpy_old) $
		       and (tco ne tco_old)) : movemode = 7
     else : movemode=8
   endcase

   ;--- CHECK IN WHICH REGION THE CURSOR IS AND UPDATE CROSSHAIRS ---
   REGION_ACTION,cube_a,cube_b,cube_c,cpx,cpy,xco,yco,tco,cpx_old,cpy_old, $
                 tco_old,movemode,n_arg	
 
 endrep until mainkey eq 'q'
; - - - - - - - - - - - - - - END OF MAIN LOOP  - - - - - - - - - - - - - - 

 ; Restore old system variables
 !p = p_reserve 
 !x = x_reserve 
 !y = y_reserve 
 !z = z_reserve 
 
 ; -- Restore old Colortables -JMK
 tvlct,r_orig,g_orig,b_orig
 ; -- restore cursor - JMK
 device,/cursor_crosshair 
 ;  wdelete,0,1,2,3,4,5
 ; -- Close all windows - JMK
 device,window=windows
 open=where(windows eq 1,count)
 for i=0,count-1 do wdelete,open(i)

endif	;same_size


END ;CUBESLICER

;ppp================================================================| CUBESHOW

pro CUBESHOW

common CUBESIZE,scube,same_size
common DATACUBES,cube_a,cube_b,cube_c
common WINDOWVARS,win_a,win_b,win_c,cname_a,cname_b,cname_c,noc,gss, $
	          first_start,f_title,s_title,t_title

  first_start = 'true'
  noc = 0
  cube_a = bytarr(1,1,1) & cname_a = 'empty' & win_a = 0
  cube_b = cube_a 	 & cname_b = 'empty' & win_b = 1
  cube_c = cube_a	 & cname_c = 'empty' & win_c = 2
  scube = size(cube_a)	;to initialize scube
  MENU_LOADING,cube_a,cube_b,cube_c,xco_old,yco_old,tco_old,xco,yco,tco

  case 1 of 
    (n_elements(cube_c) gt 1) : begin
	                          cubeslicer,cube_a,cube_b,cube_c,/run_show
				end
   ((n_elements(cube_c) le 1) and (n_elements(cube_b) gt 1)) : begin
                                cubeslicer,cube_a,cube_b,/run_show
				end  
   ((n_elements(cube_b) le 1) and (n_elements(cube_a) gt 1)) : begin
                                  cubeslicer,cube_a,/run_show
    			 	end                         
    (n_elements(cube_a) le 1) : print,'!! Cubes not found' 
    else : print,'!! Something strange is happening but I don''t know what'
  endcase

end
;ppp/\/\/\/\/\/\/\/\/\/\/\/\| END OF PROGRAM |/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
