; file: trapezint.pro
; init: Jan 17 2012
; last: Oct  1 2013  Rob Rutten
; note from ~/rr/idl/otherlibs/carlsson/util/trapez.pro

function trapezint,x0,y0

;+
;   int=trapezint(x,y)
;   performs trapezoidal integration
;   from Mats Carlsson   
;-

; answer no-parameter query
if(n_params(0) lt 2) then begin
  print,'int=trapezint(x,y)'
  return,0
endif

nx=n_elements(x0)
ny=n_elements(y0)
if(nx ne ny) then begin
  print,'trapezint: different number of elements in x and y array'
  return,-1
endif
x=reform(x0)
y=reform(y0)
integrand=(y(0:ny-2)+y(1:ny-1))*(x(1:nx-1)-x(0:nx-2))*0.5

return,total(integrand)

end
