pro scatter_tk,x,y,nouter=nouter,nxbin=nxbin,nybin=nybin,$
    	  levels=levels,nevels=nlevels,loglevels=loglevels,_extra=_extra,$
	  fraction=fraction,stop=stop,smooth=smooth

;+
; NAME: scatter_tk.pro   ; tk = JMK = Thijs Krijger
; DIR : /tmp_mnt/net/ruunat_home/strknd/krijger/Idl/New/
; PURPOSE:
;
; Create scatterplot with contours replacing very dense areas
;  
; SAMPLE CALLING SEQUENCE:
;   th_scatter,x,y,nouter=10
; INPUT:

; x,y - variables to be plotted against each other
; nouter - density value above which to plot contours [5]
; nxbin,nybin - nmr of 'pixels' in density map [201]
; WARNING: if initial data was byte or int then dont use more pixels then 
;          range of values in data [eg integers from 70-149 use 80 bins]
; levels - density contour levels, overrides nlevels
; nlevels - nmr of density contour levels [5]
; loglevels - flag: use logaritmic levels [off]
; fraction - fraction of plot to use for moments in siteline [.25]
; smooth - number of pixels to smooth the density contours [0]
;
;   
; OUTPUT:
; To screen
;    
; REQUIREMENTS:
;  oplotside routine
;   
; HISTORY:
;   Jan 14 2002 -- 14:49 by JMK - Added Libary info
; NOTE: 
;    
;-

if not keyword_set(nouter) then nouter=5
if not keyword_set(nxbin) then nxbin=201.
if not keyword_set(nybin) then nybin=201
if not keyword_set(nlevels) then nlevels=5

;x,y
;x=randomn(seed,200,200)
;y=randomn(seed,200,200)
;x=center(divv,.95)
;y=center(fov,.95)
sz=size(x)
x0=float(reform(x,float(sz(1))*sz(2)))
y0=float(reform(y,float(sz(1))*sz(2)))
;hist=hist_2d(x,y,bin1=.1,bin2=.1,)
xmin=min(x0)
xmax=float(max(x0))
ymin=min(y0)
ymax=float(max(y0))
x1=round((x0-xmin)/(xmax-xmin)*nxbin)
y1=round((y0-ymin)/(ymax-ymin)*nybin)
xy1=y1*nxbin+ x1
  ; y*xdim+x
xarr=findgen(nxbin)/(nxbin-1)*(xmax-xmin)+xmin
yarr=findgen(nybin)/(nybin-1)*(ymax-ymin)+ymin

; hdens=histogram(xy1,min=0,max=nxbin*nybin-1)
; dens=reform(hdens,nxbin,nybin)
dens=reform(histogram(xy1,min=0,max=float(nxbin)*nybin-1),nxbin,nybin)
if keyword_set(smooth) then dens=smooth(dens,smooth)
;dens2=smooth(dens,15)
;dens=fltarr(101,101) ; -5,+5 101 bins
;for i=0l,200.*200-1 do dens(xy1(i))=dens(xy1(i))+1
;dens2=smooth(dens,15)
; densxy=dens(xy1)
; iplot =where(densxy le nouter)
iplot =where(dens(xy1) le nouter)
;dens3=dens*0
;dens3(where(dens le nouter))=1

if not keyword_set(levels) then $
if keyword_set(loglevels) then begin
     levels=10^(findgen(nlevels)/alog10(max(dens))) -1 + nouter
endif else $
 levels=findgen(nlevels)/(nlevels-1)*10^(alog10(0.9*max(dens)-nouter))+nouter

; hist=histogram(xy1)
; iplot=where(hist lt 20)
contour,dens,xarr,yarr,levels=levels,_extra=_extra
oplot,x0(iplot),y0(iplot),psym=3

; contour,dens,xarr,yarr,levels=levels,_extra=_extra,/overplot
; plot,x0(iplot),y0(iplot),psym=3
; 
; dx=abs(avg(diff(xarr)))
; dy=abs(avg(diff(yarr)))

if keyword_set(stop) then stop
oplotside,avg(dens,0),xarr,yarr,side=3,fraction=fraction,_extra=_extra
oplotside,avg(dens,1),xarr,yarr,side=2,fraction=fraction,_extra=_extra

end
