pro oplotside,data,xarrin,yarrin,_extra=_extra,side=side,fraction=fraction

;+
; NAME: oplotside.pro
; DIR : /tmp_mnt/net/ruunat_home/strknd/krijger/Idl/Plot/
; PURPOSE:
;  
; plot line at side of plot
;  
; SAMPLE CALLING SEQUENCE:
;   oplotside,data,xarrin,yarrin,_extra=_extra,side=side,fraction=fraction
; INPUT:
;   
; OUTPUT:
;    
; REQUIREMENTS:
;   
; HISTORY:
;   Sep 07 2001 -- 17:23 by JMK - Added Libary info
; NOTE: 
;    
;-


if not keyword_set(fraction) then fraction=.25
if n_params() eq 3 then begin
  x1=max(xarrin)
  x0=min(xarrin)
  y1=max(yarrin)
  y0=min(yarrin)
endif else begin
  x1=!x.crange(1)
  x0=!x.crange(0)
  y1=!y.crange(1)
  y0=!y.crange(0)
endelse

if side eq 1 or side eq 3 then begin ; left or right
  x1=!x.crange(1)
  x0=!x.crange(0)

   xarr=(data-min(data))/(max(data)-min(data))*$
    (x1-x0) *fraction + x0
   ndata=findgen(n_elements(data))/(n_elements(data)-1)*$
          (y1-y0) + y0
   if side eq 3 then xarr=x1 -xarr +x0;right

endif
if side eq 2 or side eq 0 then begin ; up
  y1=!y.crange(1)
  y0=!y.crange(0)

  ndata=(data-min(data))/(max(data)-min(data))*$
      (y1-y0) *fraction + y0
  if side eq 2 then ndata=y1 - ndata +y0
	
  xarr=findgen(n_elements(data))/(n_elements(data)-1)*$
      (x1-x0) + x0
endif

oplot,xarr,ndata,_extra=_extra
end



