function get_black_lv,data,contr=contr

if not keyword_set(contr) then contr=.01

nn=n_elements(data)

lv=-1
ma=max(data)
mm=0.
hh=fltarr(256,256)
nstep=0

while (lv gt 100 or lv eq -1) and nstep lt 100 do begin
  
  h=histogram(bytscl(data,min=mm,max=ma))
  for i=0,255 do hh(i:*,i)=(shift(h,i))(i:*)
  htot=total(hh,2)
  
  lv=max(where(htot le contr*nn))
  if lv gt 100 or lv eq -1 then mm=mm+(ma-mm)/2.
  nstep=nstep+1
  
endwhile
return,mm+(ma-mm)/255.*lv
end
